/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.firebase_auth.zzcz;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.FirebaseUserMetadata;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzh;
import com.google.firebase.auth.internal.zzm;
import com.google.firebase.auth.internal.zzn;
import com.google.firebase.auth.zzd;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@SafeParcelable.Class(creator="DefaultFirebaseUserCreator")
public class zzl
extends FirebaseUser {
    public static final Parcelable.Creator<zzl> CREATOR = new zzm();
    @SafeParcelable.Field(id=1, getter="getCachedTokenState")
    private zzcz zzqr;
    @SafeParcelable.Field(id=2, getter="getDefaultAuthUserInfo")
    private zzh zzqs;
    @SafeParcelable.Field(id=3, getter="getFirebaseAppName")
    private String zzqt;
    @SafeParcelable.Field(id=4, getter="getUserType")
    private String zzqu;
    @SafeParcelable.Field(id=5, getter="getUserInfos")
    private List<zzh> zzqv;
    @SafeParcelable.Field(id=6, getter="getProviders")
    private List<String> zzqw;
    @SafeParcelable.Field(id=7, getter="getCurrentVersion")
    private String zzqx;
    @SafeParcelable.Field(id=8, getter="isAnonymous")
    private Boolean zzqy;
    @SafeParcelable.Field(id=9, getter="getMetadata")
    private zzn zzqz;
    @SafeParcelable.Field(id=10, getter="isNewUser")
    private boolean zzor;
    @SafeParcelable.Field(id=11, getter="getDefaultOAuthCredential")
    private zzd zzin;

    @SafeParcelable.Constructor
    zzl(@SafeParcelable.Param(id=1) zzcz zzcz2, @SafeParcelable.Param(id=2) zzh zzh2, @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) String string2, @SafeParcelable.Param(id=5) List<zzh> list, @SafeParcelable.Param(id=6) List<String> list2, @SafeParcelable.Param(id=7) String string3, @SafeParcelable.Param(id=8) Boolean bl, @SafeParcelable.Param(id=9) zzn zzn2, @SafeParcelable.Param(id=10) boolean bl2, @SafeParcelable.Param(id=11) zzd zzd2) {
        this.zzqr = zzcz2;
        this.zzqs = zzh2;
        this.zzqt = string;
        this.zzqu = string2;
        this.zzqv = list;
        this.zzqw = list2;
        this.zzqx = string3;
        this.zzqy = bl;
        this.zzqz = zzn2;
        this.zzor = bl2;
        this.zzin = zzd2;
    }

    public zzl(@NonNull FirebaseApp firebaseApp, @NonNull List<? extends UserInfo> list) {
        Preconditions.checkNotNull((Object)firebaseApp);
        this.zzqt = firebaseApp.getName();
        this.zzqu = "com.google.firebase.auth.internal.DefaultFirebaseUser";
        this.zzqx = "2";
        ((FirebaseUser)this).zza(list);
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.zzqs.getDisplayName();
    }

    @Override
    @Nullable
    public Uri getPhotoUrl() {
        return this.zzqs.getPhotoUrl();
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.zzqs.getEmail();
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return this.zzqs.getPhoneNumber();
    }

    @Override
    @Nullable
    public final String zzcf() {
        String string = null;
        if (this.zzqr != null && this.zzqr.zzdw() != null) {
            Map map = (Map)zzaa.zzcv(this.zzqr.zzdw()).getClaims().get("firebase");
            string = map != null ? (String)map.get("tenant") : null;
        }
        return string;
    }

    public final zzl zzct(@NonNull String string) {
        this.zzqx = string;
        return this;
    }

    @Override
    @NonNull
    public String getProviderId() {
        return this.zzqs.getProviderId();
    }

    @Override
    @NonNull
    public final FirebaseApp zzcc() {
        return FirebaseApp.getInstance((String)this.zzqt);
    }

    public final List<zzh> zzef() {
        return this.zzqv;
    }

    @Override
    @NonNull
    public String getUid() {
        return this.zzqs.getUid();
    }

    @Override
    public boolean isAnonymous() {
        if (this.zzqy == null || this.zzqy.booleanValue()) {
            String string = "";
            if (this.zzqr != null) {
                GetTokenResult getTokenResult = zzaa.zzcv(this.zzqr.zzdw());
                string = getTokenResult != null ? getTokenResult.getSignInProvider() : "";
            }
            this.zzqy = ((FirebaseUser)this).getProviderData().size() <= 1 && (string == null || !string.equals("custom"));
        }
        return this.zzqy;
    }

    @Override
    @Nullable
    public final List<String> getProviders() {
        return this.zzqw;
    }

    @Override
    @NonNull
    public final FirebaseUser zza(@NonNull List<? extends UserInfo> list) {
        Preconditions.checkNotNull(list);
        this.zzqv = new ArrayList<zzh>(list.size());
        this.zzqw = new ArrayList<String>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            UserInfo userInfo = list.get(i);
            if (userInfo.getProviderId().equals("firebase")) {
                this.zzqs = (zzh)userInfo;
            } else {
                this.zzqw.add(userInfo.getProviderId());
            }
            this.zzqv.add((zzh)userInfo);
        }
        if (this.zzqs == null) {
            this.zzqs = this.zzqv.get(0);
        }
        return this;
    }

    @Override
    @NonNull
    public List<? extends UserInfo> getProviderData() {
        return this.zzqv;
    }

    @Override
    @NonNull
    public final zzcz zzcg() {
        return this.zzqr;
    }

    @Override
    @NonNull
    public final String zzci() {
        return ((FirebaseUser)this).zzcg().zzdw();
    }

    @Override
    @NonNull
    public final String zzch() {
        return this.zzqr.zzdz();
    }

    @Override
    public final void zza(@NonNull zzcz zzcz2) {
        this.zzqr = (zzcz)Preconditions.checkNotNull((Object)zzcz2);
    }

    @Override
    public boolean isEmailVerified() {
        return this.zzqs.isEmailVerified();
    }

    public final void zza(zzn zzn2) {
        this.zzqz = zzn2;
    }

    @Override
    public FirebaseUserMetadata getMetadata() {
        return this.zzqz;
    }

    public final void zzr(boolean bl) {
        this.zzor = bl;
    }

    public final boolean isNewUser() {
        return this.zzor;
    }

    public final void zzb(zzd zzd2) {
        this.zzin = zzd2;
    }

    @Nullable
    public final zzd zzcv() {
        return this.zzin;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzl zzl2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)((FirebaseUser)zzl2).zzcg(), (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzl2.zzqs, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzl2.zzqt, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)4, (String)zzl2.zzqu, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)5, zzl2.zzqv, (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)6, ((FirebaseUser)zzl2).getProviders(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)zzl2.zzqx, (boolean)false);
        SafeParcelWriter.writeBooleanObject((Parcel)parcel2, (int)8, (Boolean)((FirebaseUser)zzl2).isAnonymous(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)9, (Parcelable)((FirebaseUser)zzl2).getMetadata(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)10, (boolean)zzl2.zzor);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)11, (Parcelable)zzl2.zzin, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public static FirebaseUser zza(FirebaseApp firebaseApp, FirebaseUser firebaseUser) {
        zzl zzl2 = new zzl(firebaseApp, firebaseUser.getProviderData());
        if (firebaseUser instanceof zzl) {
            zzl zzl3 = (zzl)firebaseUser;
            Object object = zzl3.zzqx;
            zzl2.zzqx = object;
            object = zzl3.zzqu;
            zzl2.zzqu = object;
            object = (zzn)((FirebaseUser)zzl3).getMetadata();
            zzl2.zzqz = object;
        } else {
            zzl2.zzqz = null;
        }
        if (firebaseUser.zzcg() != null) {
            ((FirebaseUser)zzl2).zza(firebaseUser.zzcg());
        }
        if (!firebaseUser.isAnonymous()) {
            ((FirebaseUser)zzl2).zzce();
        }
        return zzl2;
    }

    @Override
    public final /* synthetic */ FirebaseUser zzce() {
        zzl zzl2 = this;
        this.zzqy = false;
        return zzl2;
    }
}

