/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.android.gms.internal.firebase_auth.zzfv;
import com.google.android.gms.internal.firebase_auth.zzgb;
import com.google.android.gms.internal.firebase_auth.zzhn;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfd
extends zzed<Double>
implements zzgb<Double>,
zzhn,
RandomAccess {
    private static final zzfd zztr = new zzfd();
    private double[] zzts;
    private int size;

    zzfd() {
        this(new double[10], 0);
    }

    private zzfd(double[] dArray, int n) {
        this.zzts = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzew();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzts, n2, this.zzts, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfd)) {
            return super.equals(object);
        }
        zzfd zzfd2 = (zzfd)object;
        if (this.size != zzfd2.size) {
            return false;
        }
        double[] dArray = zzfd2.zzts;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzts[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzts[i]);
            n = n * 31 + zzfv.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzew();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzts.length) {
            System.arraycopy(this.zzts, n, this.zzts, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzts, 0, dArray, 0, n);
            System.arraycopy(this.zzts, n, dArray, n + 1, this.size - n);
            this.zzts = dArray;
        }
        this.zzts[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzew();
        zzfv.checkNotNull(collection);
        if (!(collection instanceof zzfd)) {
            return super.addAll(collection);
        }
        zzfd zzfd2 = (zzfd)collection;
        if (zzfd2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfd2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfd2.size;
        if (n > this.zzts.length) {
            this.zzts = Arrays.copyOf(this.zzts, n);
        }
        System.arraycopy(zzfd2.zzts, 0, this.zzts, this.size, zzfd2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzew();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzts[i])) continue;
            System.arraycopy(this.zzts, i + 1, this.zzts, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzfd zzfd2 = this;
        zzfd2.zzew();
        zzfd2.zzh(n);
        double d3 = zzfd2.zzts[n];
        zzfd2.zzts[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfd zzfd2 = this;
        zzfd2.zzew();
        zzfd2.zzh(n);
        double d = zzfd2.zzts[n];
        if (n < zzfd2.size - 1) {
            System.arraycopy(zzfd2.zzts, n + 1, zzfd2.zzts, n, zzfd2.size - n - 1);
        }
        --zzfd2.size;
        ++zzfd2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzgb zzj(int n) {
        int n2 = n;
        zzfd zzfd2 = this;
        if (n2 < zzfd2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfd(Arrays.copyOf(zzfd2.zzts, n2), zzfd2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfd zzfd2 = this;
        zzfd2.zzh(n);
        return zzfd2.zzts[n];
    }

    static {
        zztr.zzev();
    }
}

