/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import android.app.Activity;
import android.support.annotation.Keep;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.internal.zzdzh;
import com.google.android.gms.internal.zzeaw;
import com.google.android.gms.internal.zzebb;
import com.google.android.gms.internal.zzebd;
import com.google.android.gms.internal.zzebe;
import com.google.android.gms.internal.zzebf;
import com.google.android.gms.internal.zzebw;
import com.google.android.gms.internal.zzece;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.ActionCodeResult;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthCredential;
import com.google.firebase.auth.EmailAuthProvider;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthProvider;
import com.google.firebase.auth.ProviderQueryResult;
import com.google.firebase.auth.SignInMethodQueryResult;
import com.google.firebase.auth.UserProfileChangeRequest;
import com.google.firebase.auth.internal.zzaa;
import com.google.firebase.auth.internal.zzab;
import com.google.firebase.auth.internal.zzf;
import com.google.firebase.auth.internal.zzk;
import com.google.firebase.auth.internal.zzu;
import com.google.firebase.auth.internal.zzx;
import com.google.firebase.auth.internal.zzy;
import com.google.firebase.auth.zzi;
import com.google.firebase.auth.zzj;
import com.google.firebase.auth.zzl;
import com.google.firebase.auth.zzm;
import com.google.firebase.auth.zzn;
import com.google.firebase.internal.InternalTokenProvider;
import com.google.firebase.internal.zzc;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class FirebaseAuth
implements InternalTokenProvider {
    private FirebaseApp zzmpb;
    private List<IdTokenListener> zzmmu;
    private List<AuthStateListener> zzmpc;
    private zzdzh zzmpd;
    private FirebaseUser zzmpe;
    private final Object zzmpf;
    private String zzmpg;
    private zzx zzmph;
    private zzy zzmpi;
    private zzaa zzmpj;
    private static Map<String, FirebaseAuth> zzimu = new ArrayMap();
    private static FirebaseAuth zzmpk;

    @Keep
    public static FirebaseAuth getInstance() {
        return FirebaseAuth.zzb(FirebaseApp.getInstance());
    }

    @Keep
    public static FirebaseAuth getInstance(@NonNull FirebaseApp firebaseApp) {
        return FirebaseAuth.zzb(firebaseApp);
    }

    @Hide
    public FirebaseAuth(FirebaseApp firebaseApp) {
        FirebaseApp firebaseApp2 = firebaseApp;
        zzebd zzebd2 = new zzebe(firebaseApp2.getOptions().getApiKey()).zzbtz();
        this(firebaseApp, zzebb.zza(firebaseApp2.getApplicationContext(), zzebd2), new zzx(firebaseApp.getApplicationContext(), firebaseApp.zzbsv()));
    }

    @Hide
    private FirebaseAuth(FirebaseApp firebaseApp, zzdzh zzdzh2, zzx zzx2) {
        zzebw zzebw2;
        this.zzmpf = new Object();
        this.zzmpb = (FirebaseApp)zzbq.checkNotNull((Object)firebaseApp);
        this.zzmpd = (zzdzh)zzbq.checkNotNull((Object)zzdzh2);
        this.zzmph = (zzx)zzbq.checkNotNull((Object)zzx2);
        this.zzmmu = new CopyOnWriteArrayList<IdTokenListener>();
        this.zzmpc = new CopyOnWriteArrayList<AuthStateListener>();
        this.zzmpj = zzaa.zzbus();
        FirebaseAuth firebaseAuth = this;
        firebaseAuth.zzmpe = firebaseAuth.zzmph.zzbuq();
        if (firebaseAuth.zzmpe != null && (zzebw2 = firebaseAuth.zzmph.zzh(firebaseAuth.zzmpe)) != null) {
            firebaseAuth.zza(firebaseAuth.zzmpe, zzebw2, false);
        }
    }

    @Nullable
    public FirebaseUser getCurrentUser() {
        return this.zzmpe;
    }

    @Hide
    @Nullable
    public final String getUid() {
        if (this.zzmpe == null) {
            return null;
        }
        return this.zzmpe.getUid();
    }

    @Hide
    public final void zza(@NonNull FirebaseUser firebaseUser, @NonNull zzebw zzebw2, boolean bl) {
        boolean bl2;
        boolean bl3;
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)zzebw2));
        if (this.zzmpe == null) {
            bl3 = true;
            bl2 = true;
        } else {
            String string;
            String string2 = this.zzmpe.zzbtm().getAccessToken();
            boolean bl4 = !string2.equals(string = zzebw2.getAccessToken());
            boolean bl5 = this.zzmpe.getUid().equals(firebaseUser.getUid());
            bl3 = !bl5 || bl4;
            bl2 = !bl5;
        }
        boolean bl6 = bl2;
        boolean bl7 = bl;
        FirebaseUser firebaseUser2 = firebaseUser;
        FirebaseAuth firebaseAuth = this;
        zzbq.checkNotNull((Object)firebaseUser2);
        if (firebaseAuth.zzmpe == null) {
            firebaseAuth.zzmpe = firebaseUser2;
        } else {
            firebaseAuth.zzmpe.zzck(firebaseUser2.isAnonymous());
            firebaseAuth.zzmpe.zzar(firebaseUser2.getProviderData());
        }
        if (bl7) {
            firebaseAuth.zzmph.zzg(firebaseAuth.zzmpe);
        }
        if (bl3) {
            if (this.zzmpe != null) {
                this.zzmpe.zza(zzebw2);
            }
            this.zzb(this.zzmpe);
        }
        if (bl6) {
            this.zzc(this.zzmpe);
        }
        if (bl) {
            this.zzmph.zza(firebaseUser, zzebw2);
        }
        firebaseAuth = this;
        firebaseAuth.zzbtj().zzc(firebaseAuth.zzmpe.zzbtm());
    }

    @Hide
    public final void zzbti() {
        if (this.zzmpe != null) {
            FirebaseUser firebaseUser = this.zzmpe;
            zzx zzx2 = this.zzmph;
            zzbq.checkNotNull((Object)firebaseUser);
            zzx2.clear(String.format("com.google.firebase.auth.GET_TOKEN_RESPONSE.%s", firebaseUser.getUid()));
            this.zzmpe = null;
        }
        this.zzmph.clear("com.google.firebase.auth.FIREBASE_USER");
        this.zzb(null);
        this.zzc(null);
    }

    @Hide
    private final synchronized void zza(zzy zzy2) {
        this.zzmpi = zzy2;
        this.zzmpb.zza((FirebaseApp.zzb)zzy2);
    }

    @Hide
    private final synchronized zzy zzbtj() {
        if (this.zzmpi == null) {
            this.zza(new zzy(this.zzmpb));
        }
        return this.zzmpi;
    }

    public FirebaseApp getApp() {
        return this.zzmpb;
    }

    private static synchronized FirebaseAuth zzb(@NonNull FirebaseApp firebaseApp) {
        String string = firebaseApp.zzbsv();
        FirebaseAuth firebaseAuth = zzimu.get(string);
        if (firebaseAuth == null) {
            firebaseAuth = new com.google.firebase.auth.internal.zzj(firebaseApp);
            firebaseApp.zza((InternalTokenProvider)firebaseAuth);
            if (zzmpk == null) {
                zzmpk = firebaseAuth;
            }
            zzimu.put(string, firebaseAuth);
            return firebaseAuth;
        }
        return firebaseAuth;
    }

    public void addIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzmmu.add(idTokenListener);
        this.zzmpj.execute(new zzi(this, idTokenListener));
    }

    public void removeIdTokenListener(@NonNull IdTokenListener idTokenListener) {
        this.zzmmu.remove(idTokenListener);
    }

    public void addAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzmpc.add(authStateListener);
        this.zzmpj.execute(new zzj(this, authStateListener));
    }

    public void removeAuthStateListener(@NonNull AuthStateListener authStateListener) {
        this.zzmpc.remove(authStateListener);
    }

    @Hide
    private final void zzb(@Nullable FirebaseUser firebaseUser) {
        String string;
        if (firebaseUser != null) {
            string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(45 + String.valueOf(string).length()).append("Notifying id token listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying id token listeners about a sign-out event.");
        }
        string = firebaseUser != null ? firebaseUser.zzbto() : null;
        zzc zzc2 = new zzc(string);
        this.zzmpj.execute(new com.google.firebase.auth.zzk(this, zzc2));
    }

    @Hide
    private final void zzc(@Nullable FirebaseUser firebaseUser) {
        if (firebaseUser != null) {
            String string = firebaseUser.getUid();
            Log.d((String)"FirebaseAuth", (String)new StringBuilder(47 + String.valueOf(string).length()).append("Notifying auth state listeners about user ( ").append(string).append(" ).").toString());
        } else {
            Log.d((String)"FirebaseAuth", (String)"Notifying auth state listeners about a sign-out event.");
        }
        this.zzmpj.execute(new zzl(this));
    }

    @Hide
    @NonNull
    public final Task<GetTokenResult> zzcj(boolean bl) {
        return this.zza(this.zzmpe, bl);
    }

    @Hide
    @NonNull
    public final Task<GetTokenResult> zza(@Nullable FirebaseUser firebaseUser, boolean bl) {
        if (firebaseUser == null) {
            return Tasks.forException((Exception)zzeaw.zzaw(new Status(17495)));
        }
        zzebw zzebw2 = this.zzmpe.zzbtm();
        if (zzebw2.isValid() && !bl) {
            return Tasks.forResult((Object)new GetTokenResult(zzebw2.getAccessToken()));
        }
        return this.zzmpd.zza(this.zzmpb, firebaseUser, zzebw2.zzbue(), (zzab)((Object)new zzm(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCredential(@NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (authCredential instanceof EmailAuthCredential) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if (!emailAuthCredential.zzbth()) {
                return this.zzmpd.zzb(this.zzmpb, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), new zza(this));
            }
            return this.zzmpd.zza(this.zzmpb, emailAuthCredential, (com.google.firebase.auth.internal.zza)new zza(this));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            PhoneAuthCredential phoneAuthCredential = (PhoneAuthCredential)authCredential;
            return this.zzmpd.zza(this.zzmpb, phoneAuthCredential, (com.google.firebase.auth.internal.zza)new zza(this));
        }
        return this.zzmpd.zza(this.zzmpb, authCredential, (com.google.firebase.auth.internal.zza)new zza(this));
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzmpd.zza(this.zzmpb, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzab)((Object)new zzb(this)));
            }
            return this.zzmpd.zza(this.zzmpb, firebaseUser, emailAuthCredential, (zzab)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzmpd.zzb(this.zzmpb, firebaseUser, (PhoneAuthCredential)authCredential, (zzab)((Object)new zzb(this)));
        }
        return this.zzmpd.zza(this.zzmpb, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
    }

    @Hide
    public final Task<AuthResult> zzb(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)authCredential));
        if (EmailAuthCredential.class.isAssignableFrom(((Object)((Object)authCredential)).getClass())) {
            EmailAuthCredential emailAuthCredential = (EmailAuthCredential)authCredential;
            if ("password".equals(((AuthCredential)emailAuthCredential).getSignInMethod())) {
                return this.zzmpd.zzb(this.zzmpb, firebaseUser, emailAuthCredential.getEmail(), emailAuthCredential.getPassword(), (zzab)((Object)new zzb(this)));
            }
            return this.zzmpd.zzb(this.zzmpb, firebaseUser, emailAuthCredential, (zzab)((Object)new zzb(this)));
        }
        if (authCredential instanceof PhoneAuthCredential) {
            return this.zzmpd.zzc(this.zzmpb, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
        }
        return this.zzmpd.zzb(this.zzmpb, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> signInWithCustomToken(@NonNull String string) {
        zzbq.zzgv((String)string);
        return this.zzmpd.zza(this.zzmpb, string, (com.google.firebase.auth.internal.zza)new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        return this.zzmpd.zzb(this.zzmpb, string, string2, new zza(this));
    }

    @NonNull
    public Task<AuthResult> signInWithEmailLink(@NonNull String string, @NonNull String string2) {
        return this.signInWithCredential(EmailAuthProvider.getCredentialWithLink(string, string2));
    }

    @NonNull
    public Task<AuthResult> signInAnonymously() {
        if (this.zzmpe != null && this.zzmpe.isAnonymous()) {
            zzk zzk2 = (zzk)this.zzmpe;
            zzk2.zzco(false);
            return Tasks.forResult((Object)new zzf(zzk2));
        }
        return this.zzmpd.zza(this.zzmpb, new zza(this));
    }

    @Hide
    @NonNull
    public final void zza(@NonNull String string, long l, TimeUnit timeUnit, @NonNull PhoneAuthProvider.OnVerificationStateChangedCallbacks onVerificationStateChangedCallbacks, @Nullable Activity activity, @NonNull Executor executor, boolean bl) {
        long l2 = TimeUnit.SECONDS.convert(l, timeUnit);
        if (l2 < 0L || l2 > 120L) {
            throw new IllegalArgumentException("We only support 0-120 seconds for sms-auto-retrieval timeout");
        }
        zzece zzece2 = new zzece(string, l2, bl, this.zzmpg);
        this.zzmpd.zza(this.zzmpb, zzece2, onVerificationStateChangedCallbacks, activity, executor);
    }

    @Hide
    @NonNull
    public final Task<Void> zzd(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmpd.zza(this.zzmpb, firebaseUser, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<AuthResult> zzc(@NonNull FirebaseUser firebaseUser, @NonNull AuthCredential authCredential) {
        zzbq.checkNotNull((Object)((Object)authCredential));
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmpd.zzd(this.zzmpb, firebaseUser, authCredential, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<AuthResult> zza(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmpd.zzd(this.zzmpb, firebaseUser, string, (zzab)((Object)new zzb(this)));
    }

    @NonNull
    public Task<AuthResult> createUserWithEmailAndPassword(@NonNull String string, @NonNull String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        return this.zzmpd.zza(this.zzmpb, string, string2, new zza(this));
    }

    @Deprecated
    @NonNull
    public Task<ProviderQueryResult> fetchProvidersForEmail(@NonNull String string) {
        zzbq.zzgv((String)string);
        return this.zzmpd.zza(this.zzmpb, string);
    }

    @NonNull
    public Task<SignInMethodQueryResult> fetchSignInMethodsForEmail(@NonNull String string) {
        zzbq.zzgv((String)string);
        return this.zzmpd.zzb(this.zzmpb, string);
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull UserProfileChangeRequest userProfileChangeRequest) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)((Object)userProfileChangeRequest));
        return this.zzmpd.zza(this.zzmpb, firebaseUser, userProfileChangeRequest, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<Void> zzb(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgv((String)string);
        return this.zzmpd.zzb(this.zzmpb, firebaseUser, string, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@NonNull FirebaseUser firebaseUser, @NonNull PhoneAuthCredential phoneAuthCredential) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.checkNotNull((Object)phoneAuthCredential);
        return this.zzmpd.zza(this.zzmpb, firebaseUser, phoneAuthCredential, (zzab)((Object)new zzb(this)));
    }

    @Hide
    @NonNull
    public final Task<Void> zzc(@NonNull FirebaseUser firebaseUser, @NonNull String string) {
        zzbq.checkNotNull((Object)firebaseUser);
        zzbq.zzgv((String)string);
        return this.zzmpd.zzc(this.zzmpb, firebaseUser, string, (zzab)((Object)new zzb(this)));
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string) {
        zzbq.zzgv((String)string);
        return this.sendPasswordResetEmail(string, null);
    }

    @NonNull
    public Task<Void> sendPasswordResetEmail(@NonNull String string, @Nullable ActionCodeSettings actionCodeSettings) {
        zzbq.zzgv((String)string);
        if (actionCodeSettings == null) {
            actionCodeSettings = ActionCodeSettings.newBuilder().build();
        }
        if (this.zzmpg != null) {
            actionCodeSettings.zzpa(this.zzmpg);
        }
        actionCodeSettings.zzhc(1);
        return this.zzmpd.zza(this.zzmpb, string, actionCodeSettings);
    }

    public Task<Void> sendSignInLinkToEmail(@NonNull String string, @NonNull ActionCodeSettings actionCodeSettings) {
        zzbq.zzgv((String)string);
        zzbq.checkNotNull((Object)((Object)actionCodeSettings));
        if (this.zzmpg != null) {
            actionCodeSettings.zzpa(this.zzmpg);
        }
        return this.zzmpd.zzb(this.zzmpb, string, actionCodeSettings);
    }

    public boolean isSignInWithEmailLink(@NonNull String string) {
        return EmailAuthCredential.isSignInWithEmailLink(string);
    }

    @Hide
    @NonNull
    public final Task<Void> zza(@Nullable ActionCodeSettings actionCodeSettings, @NonNull String string) {
        zzbq.zzgv((String)string);
        if (this.zzmpg != null) {
            if (actionCodeSettings == null) {
                actionCodeSettings = ActionCodeSettings.newBuilder().build();
            }
            actionCodeSettings.zzpa(this.zzmpg);
        }
        return this.zzmpd.zza(this.zzmpb, actionCodeSettings, string);
    }

    @NonNull
    public Task<ActionCodeResult> checkActionCode(@NonNull String string) {
        zzbq.zzgv((String)string);
        return this.zzmpd.zzc(this.zzmpb, string);
    }

    @NonNull
    public Task<Void> applyActionCode(@NonNull String string) {
        zzbq.zzgv((String)string);
        return this.zzmpd.zzd(this.zzmpb, string);
    }

    @NonNull
    public Task<String> verifyPasswordResetCode(@NonNull String string) {
        zzbq.zzgv((String)string);
        return this.zzmpd.zze(this.zzmpb, string);
    }

    @NonNull
    public Task<Void> confirmPasswordReset(@NonNull String string, @NonNull String string2) {
        zzbq.zzgv((String)string);
        zzbq.zzgv((String)string2);
        return this.zzmpd.zza(this.zzmpb, string, string2);
    }

    @Hide
    @NonNull
    public final Task<Void> zze(@NonNull FirebaseUser firebaseUser) {
        zzbq.checkNotNull((Object)firebaseUser);
        return this.zzmpd.zza(firebaseUser, new zzn(this, firebaseUser));
    }

    public void signOut() {
        this.zzbti();
        if (this.zzmpi != null) {
            this.zzmpi.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageCode(@NonNull String string) {
        zzbq.zzgv((String)string);
        Object object = this.zzmpf;
        synchronized (object) {
            this.zzmpg = string;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getLanguageCode() {
        Object object = this.zzmpf;
        synchronized (object) {
            return this.zzmpg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useAppLanguage() {
        Object object = this.zzmpf;
        synchronized (object) {
            this.zzmpg = zzebf.zzbua();
            return;
        }
    }

    public Task<Void> setFirebaseUIVersion(@Nullable String string) {
        return this.zzmpd.setFirebaseUIVersion(string);
    }

    static /* synthetic */ FirebaseApp zza(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmpb;
    }

    static /* synthetic */ List zzb(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmmu;
    }

    static /* synthetic */ List zzc(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmpc;
    }

    static /* synthetic */ FirebaseUser zzd(FirebaseAuth firebaseAuth) {
        return firebaseAuth.zzmpe;
    }

    final class zzb
    extends zza
    implements com.google.firebase.auth.internal.zza,
    zzu {
        private /* synthetic */ FirebaseAuth zzmpm;

        zzb(FirebaseAuth firebaseAuth) {
            this.zzmpm = firebaseAuth;
            super(firebaseAuth);
        }

        @Override
        public final void onError(Status status) {
            if (status.getStatusCode() == 17011 || status.getStatusCode() == 17021 || status.getStatusCode() == 17005) {
                this.zzmpm.signOut();
            }
        }
    }

    class zza
    implements com.google.firebase.auth.internal.zza {
        private /* synthetic */ FirebaseAuth zzmpm;

        zza(FirebaseAuth firebaseAuth) {
            this.zzmpm = firebaseAuth;
        }

        @Override
        public final void zza(@NonNull zzebw zzebw2, @NonNull FirebaseUser firebaseUser) {
            zzbq.checkNotNull((Object)((Object)zzebw2));
            zzbq.checkNotNull((Object)firebaseUser);
            firebaseUser.zza(zzebw2);
            this.zzmpm.zza(firebaseUser, zzebw2, true);
        }
    }

    public static interface AuthStateListener {
        public void onAuthStateChanged(@NonNull FirebaseAuth var1);
    }

    public static interface IdTokenListener {
        public void onIdTokenChanged(@NonNull FirebaseAuth var1);
    }
}

