/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpResponse;
import com.google.firebase.appdistribution.ApiEndpoints;
import com.google.firebase.appdistribution.AppDistributionLogger;
import com.google.firebase.appdistribution.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.AuthenticatedHttpClient;
import com.google.firebase.appdistribution.BinaryType;
import com.google.firebase.appdistribution.models.StatusToken;
import com.google.firebase.appdistribution.models.UploadResponse;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class UploadService {
    AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();
    public static final String X_GOOG_UPLOAD_FILE_NAME = "X-Goog-Upload-File-Name";
    public static final String X_GOOG_UPLOAD_PROTOCOL = "X-Goog-Upload-Protocol";
    public static final String RAW = "raw";
    private final AuthenticatedHttpClient httpClient;

    public UploadService(AuthenticatedHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Optional<StatusToken> uploadDistribution(String appId, File distributionFile) throws IOException {
        FileContent fileContent = new FileContent("application/octet-stream", distributionFile);
        HttpResponse uploadDistributionResponse = this.httpClient.newPostRequest(ApiEndpoints.getScottyUploadEndpoint(appId)).setContent((HttpContent)fileContent).setHeader(X_GOOG_UPLOAD_FILE_NAME, distributionFile.getName()).setHeader(X_GOOG_UPLOAD_PROTOCOL, RAW).execute();
        if (uploadDistributionResponse.isSuccessStatusCode()) {
            StatusToken statusToken;
            try {
                String responseBody = uploadDistributionResponse.parseAsString();
                statusToken = new StatusToken(((UploadResponse)new Gson().fromJson(responseBody, UploadResponse.class)).getToken());
            }
            catch (JsonSyntaxException e) {
                this.LOGGER.info("Failed to parse upload response. Message: %s", e.getMessage());
                return Optional.empty();
            }
            this.LOGGER.info("Uploaded %s successfully %s", new Object[]{BinaryType.fromPath(distributionFile.getPath()), uploadDistributionResponse.getStatusCode()});
            return Optional.of(statusToken);
        }
        this.LOGGER.info("Unable to upload %s. Response code: %s", new Object[]{BinaryType.fromPath(distributionFile.getPath()), uploadDistributionResponse.getStatusCode()});
        return Optional.empty();
    }
}

