/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.firebase.appdistribution.ApiService;
import com.google.firebase.appdistribution.AppDistributionException;
import com.google.firebase.appdistribution.BinaryType;
import com.google.firebase.appdistribution.ThreadSleeper;
import com.google.firebase.appdistribution.models.UploadStatus;
import com.google.firebase.appdistribution.models.UploadStatusResponse;

public class ReleaseLookup {
    private static long POLLING_INTERVAL = 2000L;
    private static int MAX_POLLING_RETRIES = 60;
    private ThreadSleeper threadSleeper;
    private int maxPollingRetries;

    public ReleaseLookup() {
        this(new ThreadSleeper(), MAX_POLLING_RETRIES);
    }

    ReleaseLookup(ThreadSleeper threadSleeper, int maxPollingRetries) {
        this.threadSleeper = threadSleeper;
        this.maxPollingRetries = maxPollingRetries;
    }

    public UploadStatusResponse pollForRelease(ApiService apiService, String statusToken, BinaryType binaryType) throws AppDistributionException {
        for (int numRetries = 0; numRetries < this.maxPollingRetries; ++numRetries) {
            UploadStatusResponse response = apiService.getUploadStatus(statusToken, binaryType);
            if (response.getStatus() == UploadStatus.IN_PROGRESS) {
                try {
                    this.threadSleeper.sleep(POLLING_INTERVAL);
                    continue;
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException("App Distribution ran into an error while looking up the release", ie);
                }
            }
            return response;
        }
        throw new AppDistributionException(AppDistributionException.Reason.GET_RELEASE_TIMEOUT, "It took longer than expected to process your APK, please try again");
    }
}

