/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.auth.oauth2.Credential;
import com.google.firebase.appdistribution.ApiService;
import com.google.firebase.appdistribution.AppDistributionException;
import com.google.firebase.appdistribution.AppDistributionLogger;
import com.google.firebase.appdistribution.AppDistributionLoggerHelper;
import com.google.firebase.appdistribution.AuthenticatedHttpClient;
import com.google.firebase.appdistribution.AuthenticationFlow;
import com.google.firebase.appdistribution.Cli;
import com.google.firebase.appdistribution.CliRuntime;
import com.google.firebase.appdistribution.CliRuntimeProperties;
import com.google.firebase.appdistribution.ConsoleLogger;
import com.google.firebase.appdistribution.FirebaseAppDistributionOptions;
import com.google.firebase.appdistribution.FirebaseAppDistributionUpload;
import com.google.firebase.appdistribution.UploadService;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.logging.Level;

public class FirebaseAppDistribution {
    static AppDistributionLogger LOGGER = AppDistributionLoggerHelper.getLogger();

    public static void main(String ... args) {
        FirebaseAppDistribution.login(new ConsoleLogger());
        try {
            FirebaseAppDistributionOptions options = Cli.parseOptions(args);
            FirebaseAppDistribution.run(options, CliRuntimeProperties.newBuilder().setClientId(CliRuntime.getMainClassFromManifest()).setClientType(CliRuntime.CONSOLE_TYPE).setClientVersion(CliRuntime.getVersionFromManifest()).build());
        }
        catch (AppDistributionException e) {
            LOGGER.info(e.getMessage(), new Object[0]);
            System.exit(1);
        }
    }

    public static void run(FirebaseAppDistributionOptions options, CliRuntimeProperties props) {
        ConsoleLogger logger = options.isDebug() ? new ConsoleLogger(Level.FINEST) : new ConsoleLogger();
        FirebaseAppDistribution.run(options, logger, props);
    }

    public static void login(AppDistributionLogger logger) {
        try {
            Credential credential = new AuthenticationFlow().oauthFlow();
            logger.info("\nRefresh token: " + credential.getRefreshToken(), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating oauth flow", e);
        }
    }

    public static void run(FirebaseAppDistributionOptions options, AppDistributionLogger logger, CliRuntimeProperties props) {
        AuthenticatedHttpClient googleHttpClient;
        AppDistributionLoggerHelper.setLogger(logger);
        CliRuntime.getInstance().setClientId(props.getClientId()).setClientType(props.getClientType()).setClientVersion(props.getClientVersion());
        if (options.getBinary() == null) {
            throw new AppDistributionException(AppDistributionException.Reason.BINARY_NOT_FOUND);
        }
        if (options.getAppId() == null) {
            throw new AppDistributionException(AppDistributionException.Reason.MISSING_APP_ID);
        }
        if (options.getCredentials() == null) {
            throw new AppDistributionException(AppDistributionException.Reason.MISSING_CREDENTIALS);
        }
        try {
            googleHttpClient = new AuthenticatedHttpClient(options.getCredentials());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("There was a problem. Please try again.", e);
        }
        ApiService apiService = new ApiService(googleHttpClient, options.getAppId());
        UploadService uploadService = new UploadService(googleHttpClient);
        FirebaseAppDistributionUpload upload = new FirebaseAppDistributionUpload(options, apiService, uploadService);
        upload.uploadDistribution();
    }
}

