/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.firebase.appdistribution.FirebaseAppDistributionOptions;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Cli {
    static final String OPT_DISTRIBUTION_FILE = "distributionFile";
    static final String OPT_SERVICE_ACCOUNT_CREDENTIALS_FILE = "serviceAccountCredentialsFile";
    static final String OPT_RELEASE_NOTES = "releaseNotes";
    static final String OPT_RELEASE_NOTES_FILE = "releaseNotesFile";
    static final String OPT_TESTERS = "testers";
    static final String OPT_TESTERS_FILE = "testersFile";
    static final String OPT_GROUPS = "groups";
    static final String OPT_GROUPS_FILE = "groupsFile";
    static final String OPT_APP_ID = "appId";
    static final String OPT_DEBUG = "debug";
    static final String OPT_HELP = "help";
    private CommandLineParser parser = new DefaultParser();
    private Options options = new Options();

    private Cli() {
        this.options.addOption(Option.builder().argName(OPT_DISTRIBUTION_FILE).longOpt(OPT_DISTRIBUTION_FILE).hasArg().desc("Filepath to the apk to distribute.").build());
        this.options.addOption(Option.builder().argName(OPT_SERVICE_ACCOUNT_CREDENTIALS_FILE).longOpt(OPT_SERVICE_ACCOUNT_CREDENTIALS_FILE).hasArg().desc("Filepath to the service account key JSON file.").build());
        this.options.addOption(Option.builder().argName(OPT_RELEASE_NOTES).longOpt(OPT_RELEASE_NOTES).hasArg().desc("Release notes to include with this distribution").build());
        this.options.addOption(Option.builder().argName(OPT_RELEASE_NOTES_FILE).longOpt(OPT_RELEASE_NOTES_FILE).hasArg().desc("Path to file with release notes to include with this distribution").build());
        this.options.addOption(Option.builder().argName(OPT_TESTERS).longOpt(OPT_TESTERS).hasArg().desc("A comma separated list of tester emails to distribute to").build());
        this.options.addOption(Option.builder().argName(OPT_TESTERS_FILE).longOpt(OPT_TESTERS_FILE).hasArg().desc("Path to file with a comma separated list of tester emails to distribute to").build());
        this.options.addOption(Option.builder().argName(OPT_GROUPS).longOpt(OPT_GROUPS).hasArg().desc("A comma separated list of group aliases to distribute to").build());
        this.options.addOption(Option.builder().argName(OPT_GROUPS_FILE).longOpt(OPT_GROUPS_FILE).hasArg().desc("Path to file with a comma separated list of group aliases to distribute to").build());
        this.options.addOption(Option.builder().argName(OPT_APP_ID).longOpt(OPT_APP_ID).hasArg().desc("App id for your Firebase app").build());
        this.options.addOption(Option.builder().argName(OPT_DEBUG).longOpt(OPT_DEBUG).desc("Output debug information.").build());
        this.options.addOption(Option.builder().argName(OPT_HELP).longOpt(OPT_HELP).desc("Prints this message").build());
    }

    private CommandLine parse(String ... args) {
        try {
            CommandLine line = this.parser.parse(this.options, args);
            if (line.hasOption(OPT_HELP)) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.setWidth(120);
                formatter.printHelp("Main", this.options);
                System.exit(0);
            }
            return line;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid command line arguments", e);
        }
    }

    public static FirebaseAppDistributionOptions parseOptions(String ... args) {
        CommandLine line = new Cli().parse(args);
        FirebaseAppDistributionOptions.Builder cliOptions = FirebaseAppDistributionOptions.newBuilder();
        if (line.hasOption(OPT_DISTRIBUTION_FILE)) {
            cliOptions.setDistributionFile(line.getOptionValue(OPT_DISTRIBUTION_FILE));
        }
        if (line.hasOption(OPT_SERVICE_ACCOUNT_CREDENTIALS_FILE)) {
            cliOptions.setServiceAccountCredentialsFile(line.getOptionValue(OPT_SERVICE_ACCOUNT_CREDENTIALS_FILE));
        }
        if (line.hasOption(OPT_RELEASE_NOTES_FILE) || line.hasOption(OPT_RELEASE_NOTES)) {
            cliOptions.setReleaseNotes(line.getOptionValue(OPT_RELEASE_NOTES), line.getOptionValue(OPT_RELEASE_NOTES_FILE));
        }
        if (line.hasOption(OPT_TESTERS_FILE) || line.hasOption(OPT_TESTERS)) {
            cliOptions.setTesters(line.getOptionValue(OPT_TESTERS), line.getOptionValue(OPT_TESTERS_FILE));
        }
        if (line.hasOption(OPT_GROUPS_FILE) || line.hasOption(OPT_GROUPS)) {
            cliOptions.setGroups(line.getOptionValue(OPT_GROUPS), line.getOptionValue(OPT_GROUPS_FILE));
        }
        if (line.hasOption(OPT_APP_ID)) {
            cliOptions.setAppId(line.getOptionValue(OPT_APP_ID));
        }
        cliOptions.setDebug(line.hasOption(OPT_DEBUG));
        return cliOptions.build();
    }
}

