/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.firebase.appdistribution.RequestBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

public class AuthenticatedHttpClient {
    private final HttpTransport httpTransport;
    private HttpRequestInitializer httpRequestInitializer = new DefaultHttpRequestInitializer();

    public AuthenticatedHttpClient() throws GeneralSecurityException, IOException {
        this(AuthenticatedHttpClient.newGoogleHttpTransport());
    }

    public AuthenticatedHttpClient(Credential credential) throws GeneralSecurityException, IOException {
        this(AuthenticatedHttpClient.newGoogleHttpTransport(), credential);
    }

    public AuthenticatedHttpClient(HttpTransport httpTransport) {
        this.httpTransport = httpTransport;
    }

    public AuthenticatedHttpClient(HttpTransport httpTransport, Credential requestInitializer) {
        this.httpTransport = httpTransport;
        this.httpRequestInitializer = requestInitializer;
    }

    public RequestBuilder newGetRequest(GenericUrl url) throws IOException {
        return new RequestBuilder(this.httpTransport.createRequestFactory(this.httpRequestInitializer).buildGetRequest(url));
    }

    public RequestBuilder newPostRequest(GenericUrl url) throws IOException {
        return this.newPostRequest(url, null);
    }

    public RequestBuilder newPostRequest(GenericUrl url, HttpContent content) throws IOException {
        return new RequestBuilder(this.httpTransport.createRequestFactory(this.httpRequestInitializer).buildPostRequest(url, content));
    }

    static HttpTransport newGoogleHttpTransport() throws IOException, GeneralSecurityException {
        NetHttpTransport.Builder builder = new NetHttpTransport.Builder();
        builder.trustCertificates(GoogleUtils.getCertificateTrustStore());
        String trustStorePath = System.getProperty("javax.net.ssl.trustStore");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        if (trustStorePath != null && trustStorePassword != null) {
            builder.trustCertificatesFromJavaKeyStore((InputStream)new FileInputStream(trustStorePath), trustStorePassword);
        }
        return builder.build();
    }

    class DefaultHttpRequestInitializer
    implements HttpRequestInitializer {
        DefaultHttpRequestInitializer() {
        }

        public void initialize(HttpRequest request) {
        }
    }
}

