/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appdistribution.internal;

import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.google.android.gms.tasks.Task;
import com.google.firebase.appdistribution.AppDistributionRelease;
import com.google.firebase.appdistribution.FirebaseAppDistribution;
import com.google.firebase.appdistribution.InterruptionLevel;
import com.google.firebase.appdistribution.UpdateTask;
import com.google.firebase.appdistribution.internal.FirebaseAppDistributionStub;
import com.google.firebase.inject.Provider;

public class FirebaseAppDistributionProxy
implements FirebaseAppDistribution {
    private final FirebaseAppDistribution delegate;

    public FirebaseAppDistributionProxy(Provider<FirebaseAppDistribution> firebaseAppDistributionImplProvider) {
        FirebaseAppDistribution impl = (FirebaseAppDistribution)firebaseAppDistributionImplProvider.get();
        this.delegate = impl != null ? impl : new FirebaseAppDistributionStub();
    }

    @Override
    @NonNull
    public UpdateTask updateIfNewReleaseAvailable() {
        return this.delegate.updateIfNewReleaseAvailable();
    }

    @Override
    public boolean isTesterSignedIn() {
        return this.delegate.isTesterSignedIn();
    }

    @Override
    @NonNull
    public Task<Void> signInTester() {
        return this.delegate.signInTester();
    }

    @Override
    public void signOutTester() {
        this.delegate.signOutTester();
    }

    @Override
    @NonNull
    public synchronized Task<AppDistributionRelease> checkForNewRelease() {
        return this.delegate.checkForNewRelease();
    }

    @Override
    @NonNull
    public UpdateTask updateApp() {
        return this.delegate.updateApp();
    }

    @Override
    public void startFeedback(@StringRes int additionalFormText) {
        this.delegate.startFeedback(additionalFormText);
    }

    @Override
    public void startFeedback(@NonNull CharSequence additionalFormText) {
        this.delegate.startFeedback(additionalFormText);
    }

    @Override
    public void startFeedback(@StringRes int additionalFormText, @Nullable Uri screenshotUri) {
        this.delegate.startFeedback(additionalFormText, screenshotUri);
    }

    @Override
    public void startFeedback(@NonNull CharSequence additionalFormText, @Nullable Uri screenshotUri) {
        this.delegate.startFeedback(additionalFormText, screenshotUri);
    }

    @Override
    public void showFeedbackNotification(@StringRes int additionalFormText, @NonNull InterruptionLevel interruptionLevel) {
        this.delegate.showFeedbackNotification(additionalFormText, interruptionLevel);
    }

    @Override
    public void showFeedbackNotification(@NonNull CharSequence additionalFormText, @NonNull InterruptionLevel interruptionLevel) {
        this.delegate.showFeedbackNotification(additionalFormText, interruptionLevel);
    }

    @Override
    public void cancelFeedbackNotification() {
        this.delegate.cancelFeedbackNotification();
    }
}

