/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.appcheck.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.annotations.concurrent.Background;
import com.google.firebase.annotations.concurrent.Blocking;
import com.google.firebase.annotations.concurrent.Lightweight;
import com.google.firebase.annotations.concurrent.UiThread;
import com.google.firebase.appcheck.AppCheckProvider;
import com.google.firebase.appcheck.AppCheckProviderFactory;
import com.google.firebase.appcheck.AppCheckToken;
import com.google.firebase.appcheck.AppCheckTokenResult;
import com.google.firebase.appcheck.FirebaseAppCheck;
import com.google.firebase.appcheck.internal.DefaultAppCheckTokenResult;
import com.google.firebase.appcheck.internal.StorageHelper;
import com.google.firebase.appcheck.internal.TokenRefreshManager;
import com.google.firebase.appcheck.internal.util.Clock;
import com.google.firebase.appcheck.interop.AppCheckTokenListener;
import com.google.firebase.heartbeatinfo.HeartBeatController;
import com.google.firebase.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

public class DefaultFirebaseAppCheck
extends FirebaseAppCheck {
    private static final long BUFFER_TIME_MILLIS = 300000L;
    private final FirebaseApp firebaseApp;
    private final Provider<HeartBeatController> heartbeatControllerProvider;
    private final List<AppCheckTokenListener> appCheckTokenListenerList;
    private final List<FirebaseAppCheck.AppCheckListener> appCheckListenerList;
    private final StorageHelper storageHelper;
    private final TokenRefreshManager tokenRefreshManager;
    private final Executor uiExecutor;
    private final Executor liteExecutor;
    private final Executor backgroundExecutor;
    private final Task<Void> retrieveStoredTokenTask;
    private final Clock clock;
    private AppCheckProviderFactory appCheckProviderFactory;
    private AppCheckProvider appCheckProvider;
    private AppCheckToken cachedToken;
    private Task<AppCheckToken> cachedTokenTask;

    public DefaultFirebaseAppCheck(@NonNull FirebaseApp firebaseApp, @NonNull Provider<HeartBeatController> heartBeatController, @UiThread Executor uiExecutor, @Lightweight Executor liteExecutor, @Background Executor backgroundExecutor, @Blocking ScheduledExecutorService scheduledExecutorService) {
        Preconditions.checkNotNull((Object)firebaseApp);
        Preconditions.checkNotNull(heartBeatController);
        this.firebaseApp = firebaseApp;
        this.heartbeatControllerProvider = heartBeatController;
        this.appCheckTokenListenerList = new ArrayList<AppCheckTokenListener>();
        this.appCheckListenerList = new ArrayList<FirebaseAppCheck.AppCheckListener>();
        this.storageHelper = new StorageHelper(firebaseApp.getApplicationContext(), firebaseApp.getPersistenceKey());
        this.tokenRefreshManager = new TokenRefreshManager(firebaseApp.getApplicationContext(), this, liteExecutor, scheduledExecutorService);
        this.uiExecutor = uiExecutor;
        this.liteExecutor = liteExecutor;
        this.backgroundExecutor = backgroundExecutor;
        this.retrieveStoredTokenTask = this.retrieveStoredAppCheckTokenInBackground(backgroundExecutor);
        this.clock = new Clock.DefaultClock();
    }

    private Task<Void> retrieveStoredAppCheckTokenInBackground(@NonNull Executor executor) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        executor.execute(() -> {
            AppCheckToken token = this.storageHelper.retrieveAppCheckToken();
            if (token != null) {
                this.setCachedToken(token);
            }
            taskCompletionSource.setResult(null);
        });
        return taskCompletionSource.getTask();
    }

    @Override
    public void installAppCheckProviderFactory(@NonNull AppCheckProviderFactory factory) {
        this.installAppCheckProviderFactory(factory, this.firebaseApp.isDataCollectionDefaultEnabled());
    }

    @Override
    public void installAppCheckProviderFactory(@NonNull AppCheckProviderFactory factory, boolean isTokenAutoRefreshEnabled) {
        Preconditions.checkNotNull((Object)factory);
        this.appCheckProviderFactory = factory;
        this.appCheckProvider = factory.create(this.firebaseApp);
        this.tokenRefreshManager.setIsAutoRefreshEnabled(isTokenAutoRefreshEnabled);
    }

    @VisibleForTesting
    @Nullable
    public AppCheckProviderFactory getInstalledAppCheckProviderFactory() {
        return this.appCheckProviderFactory;
    }

    @Override
    public void setTokenAutoRefreshEnabled(boolean isTokenAutoRefreshEnabled) {
        this.tokenRefreshManager.setIsAutoRefreshEnabled(isTokenAutoRefreshEnabled);
    }

    @VisibleForTesting
    public void resetAppCheckState() {
        this.appCheckProviderFactory = null;
        this.appCheckProvider = null;
        this.cachedToken = null;
        this.storageHelper.clearSharedPrefs();
    }

    public void addAppCheckTokenListener(@NonNull AppCheckTokenListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckTokenListenerList.add(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
        if (this.hasValidToken()) {
            listener.onAppCheckTokenChanged((AppCheckTokenResult)DefaultAppCheckTokenResult.constructFromAppCheckToken(this.cachedToken));
        }
    }

    public void removeAppCheckTokenListener(@NonNull AppCheckTokenListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckTokenListenerList.remove(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
    }

    @Override
    public void addAppCheckListener(@NonNull FirebaseAppCheck.AppCheckListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckListenerList.add(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
        if (this.hasValidToken()) {
            listener.onAppCheckTokenChanged(this.cachedToken);
        }
    }

    @Override
    public void removeAppCheckListener(@NonNull FirebaseAppCheck.AppCheckListener listener) {
        Preconditions.checkNotNull((Object)listener);
        this.appCheckListenerList.remove(listener);
        this.tokenRefreshManager.onListenerCountChanged(this.appCheckTokenListenerList.size() + this.appCheckListenerList.size());
    }

    @NonNull
    public Task<AppCheckTokenResult> getToken(boolean forceRefresh) {
        return this.retrieveStoredTokenTask.continueWithTask(this.liteExecutor, unused -> {
            if (!forceRefresh && this.hasValidToken()) {
                return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromAppCheckToken(this.cachedToken)));
            }
            if (this.appCheckProvider == null) {
                return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromError(new FirebaseException("No AppCheckProvider installed."))));
            }
            if (this.cachedTokenTask == null || this.cachedTokenTask.isComplete() || this.cachedTokenTask.isCanceled()) {
                this.cachedTokenTask = this.fetchTokenFromProvider();
            }
            return this.cachedTokenTask.continueWithTask(this.liteExecutor, appCheckTokenTask -> {
                if (appCheckTokenTask.isSuccessful()) {
                    return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromAppCheckToken((AppCheckToken)appCheckTokenTask.getResult())));
                }
                return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromError(new FirebaseException(appCheckTokenTask.getException().getMessage(), (Throwable)appCheckTokenTask.getException()))));
            });
        });
    }

    @NonNull
    public Task<AppCheckTokenResult> getLimitedUseToken() {
        return this.getLimitedUseAppCheckToken().continueWithTask(this.liteExecutor, appCheckTokenTask -> {
            if (appCheckTokenTask.isSuccessful()) {
                return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromAppCheckToken((AppCheckToken)appCheckTokenTask.getResult())));
            }
            return Tasks.forResult((Object)((Object)DefaultAppCheckTokenResult.constructFromError(new FirebaseException(appCheckTokenTask.getException().getMessage(), (Throwable)appCheckTokenTask.getException()))));
        });
    }

    @Override
    @NonNull
    public Task<AppCheckToken> getAppCheckToken(boolean forceRefresh) {
        return this.retrieveStoredTokenTask.continueWithTask(this.liteExecutor, unused -> {
            if (!forceRefresh && this.hasValidToken()) {
                return Tasks.forResult((Object)this.cachedToken);
            }
            if (this.appCheckProvider == null) {
                return Tasks.forException((Exception)new FirebaseException("No AppCheckProvider installed."));
            }
            if (this.cachedTokenTask == null || this.cachedTokenTask.isComplete() || this.cachedTokenTask.isCanceled()) {
                this.cachedTokenTask = this.fetchTokenFromProvider();
            }
            return this.cachedTokenTask;
        });
    }

    @Override
    @NonNull
    public Task<AppCheckToken> getLimitedUseAppCheckToken() {
        if (this.appCheckProvider == null) {
            return Tasks.forException((Exception)new FirebaseException("No AppCheckProvider installed."));
        }
        return this.appCheckProvider.getToken();
    }

    Task<AppCheckToken> fetchTokenFromProvider() {
        return this.appCheckProvider.getToken().onSuccessTask(this.uiExecutor, token -> {
            this.updateStoredToken((AppCheckToken)token);
            for (FirebaseAppCheck.AppCheckListener listener : this.appCheckListenerList) {
                listener.onAppCheckTokenChanged((AppCheckToken)token);
            }
            DefaultAppCheckTokenResult tokenResult = DefaultAppCheckTokenResult.constructFromAppCheckToken(token);
            for (AppCheckTokenListener listener : this.appCheckTokenListenerList) {
                listener.onAppCheckTokenChanged((AppCheckTokenResult)tokenResult);
            }
            return Tasks.forResult((Object)token);
        });
    }

    @NonNull
    Provider<HeartBeatController> getHeartbeatControllerProvider() {
        return this.heartbeatControllerProvider;
    }

    @VisibleForTesting
    void setCachedToken(@NonNull AppCheckToken token) {
        this.cachedToken = token;
    }

    private void updateStoredToken(@NonNull AppCheckToken token) {
        this.backgroundExecutor.execute(() -> this.storageHelper.saveAppCheckToken(token));
        this.setCachedToken(token);
        this.tokenRefreshManager.maybeScheduleTokenRefresh(token);
    }

    private boolean hasValidToken() {
        return this.cachedToken != null && this.cachedToken.getExpireTimeMillis() - this.clock.currentTimeMillis() > 300000L;
    }
}

