/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.sqlite.SQLiteException;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.internal.measurement.zzfq;
import com.google.android.gms.internal.measurement.zzxz;
import com.google.android.gms.internal.measurement.zzya;
import com.google.android.gms.internal.measurement.zzyc;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzcu;
import com.google.android.gms.measurement.internal.zzcv;
import com.google.android.gms.measurement.internal.zzcw;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzs;
import com.google.android.gms.measurement.internal.zzt;
import java.io.IOException;
import java.util.Map;

public final class zzbq
extends zzfn
implements zzs {
    @VisibleForTesting
    private static int zzaoi = 65535;
    @VisibleForTesting
    private static int zzaoj = 2;
    private final Map<String, Map<String, String>> zzaok = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaol = new ArrayMap();
    private final Map<String, Map<String, Boolean>> zzaom = new ArrayMap();
    private final Map<String, zzfp> zzaon = new ArrayMap();
    private final Map<String, Map<String, Integer>> zzaoo;
    private final Map<String, String> zzaop = new ArrayMap();

    zzbq(zzfo zzfo2) {
        super(zzfo2);
        this.zzaoo = new ArrayMap();
    }

    @WorkerThread
    private final void zzcf(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        if (this.zzaon.get(string) == null) {
            byte[] byArray = ((zzfm)this).zzjt().zzbo(string);
            if (byArray == null) {
                this.zzaok.put(string, null);
                this.zzaol.put(string, null);
                this.zzaom.put(string, null);
                this.zzaon.put(string, null);
                this.zzaop.put(string, null);
                this.zzaoo.put(string, null);
                return;
            }
            zzfp zzfp2 = this.zza(string, byArray);
            this.zzaok.put(string, zzbq.zza(zzfp2));
            this.zza(string, zzfp2);
            this.zzaon.put(string, zzfp2);
            this.zzaop.put(string, null);
        }
    }

    @WorkerThread
    protected final zzfp zzcg(String string) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        this.zzcf(string);
        return this.zzaon.get(string);
    }

    @WorkerThread
    protected final String zzch(String string) {
        this.zzaf();
        return this.zzaop.get(string);
    }

    @WorkerThread
    protected final void zzci(String string) {
        this.zzaf();
        this.zzaop.put(string, null);
    }

    @WorkerThread
    final void zzcj(String string) {
        this.zzaf();
        this.zzaon.remove(string);
    }

    @WorkerThread
    public final String zzf(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        Map<String, String> map = this.zzaok.get(string);
        if (map != null) {
            return map.get(string2);
        }
        return null;
    }

    private static Map<String, String> zza(zzfp zzfp2) {
        ArrayMap arrayMap = new ArrayMap();
        if (zzfp2 != null && zzfp2.zzawm != null) {
            zzfq[] zzfqArray = zzfp2.zzawm;
            int n = zzfp2.zzawm.length;
            for (int i = 0; i < n; ++i) {
                zzfq zzfq2 = zzfqArray[i];
                if (zzfq2 == null) continue;
                arrayMap.put(zzfq2.zzoj, zzfq2.value);
            }
        }
        return arrayMap;
    }

    private final void zza(String string, zzfp zzfp2) {
        ArrayMap arrayMap = new ArrayMap();
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        if (zzfp2 != null && zzfp2.zzawn != null) {
            com.google.android.gms.internal.measurement.zzfo[] zzfoArray = zzfp2.zzawn;
            int n = zzfp2.zzawn.length;
            for (int i = 0; i < n; ++i) {
                com.google.android.gms.internal.measurement.zzfo zzfo2 = zzfoArray[i];
                if (TextUtils.isEmpty((CharSequence)zzfo2.name)) {
                    this.zzgt().zzjj().zzby("EventConfig contained null event name");
                    continue;
                }
                String string2 = zzcu.zzco((String)zzfo2.name);
                if (!TextUtils.isEmpty((CharSequence)string2)) {
                    zzfo2.name = string2;
                }
                arrayMap.put(zzfo2.name, zzfo2.zzawh);
                arrayMap2.put(zzfo2.name, zzfo2.zzawi);
                if (zzfo2.zzawj == null) continue;
                if (zzfo2.zzawj < zzaoj || zzfo2.zzawj > zzaoi) {
                    this.zzgt().zzjj().zze("Invalid sampling rate. Event name, sample rate", (Object)zzfo2.name, (Object)zzfo2.zzawj);
                    continue;
                }
                arrayMap3.put(zzfo2.name, zzfo2.zzawj);
            }
        }
        this.zzaol.put(string, (Map<String, Boolean>)arrayMap);
        this.zzaom.put(string, (Map<String, Boolean>)arrayMap2);
        this.zzaoo.put(string, (Map<String, Integer>)arrayMap3);
    }

    @WorkerThread
    protected final boolean zza(String string, byte[] byArray, String string2) {
        this.zzcl();
        this.zzaf();
        Preconditions.checkNotEmpty((String)string);
        zzfp zzfp2 = this.zza(string, byArray);
        if (zzfp2 == null) {
            return false;
        }
        this.zza(string, zzfp2);
        this.zzaon.put(string, zzfp2);
        this.zzaop.put(string, string2);
        this.zzaok.put(string, zzbq.zza(zzfp2));
        Object object = zzfp2.zzawo;
        String string3 = string;
        Object object2 = ((zzfm)this).zzjs();
        Preconditions.checkNotNull((Object)object);
        for (zzfi zzfi2 : object) {
            String string4;
            zzfj zzfj2;
            int n;
            zzyc[] zzycArray = zzfi2.zzavg;
            int n2 = zzfi2.zzavg.length;
            for (n = 0; n < n2; ++n) {
                zzfj2 = zzycArray[n];
                string4 = zzcu.zzco((String)zzfj2.zzavl);
                if (string4 != null) {
                    zzfj2.zzavl = string4;
                }
                zzfk[] zzfkArray = zzfj2.zzavm;
                int n3 = zzfj2.zzavm.length;
                for (int i = 0; i < n3; ++i) {
                    zzfk zzfk2 = zzfkArray[i];
                    String string5 = zzcv.zzco((String)zzfk2.zzavt);
                    if (string5 == null) continue;
                    zzfk2.zzavt = string5;
                }
            }
            zzycArray = zzfi2.zzavf;
            n2 = zzfi2.zzavf.length;
            for (n = 0; n < n2; ++n) {
                zzfj2 = zzycArray[n];
                string4 = zzcw.zzco((String)((com.google.android.gms.internal.measurement.zzfm)((Object)zzfj2)).zzawa);
                if (string4 == null) continue;
                ((com.google.android.gms.internal.measurement.zzfm)((Object)zzfj2)).zzawa = string4;
            }
        }
        ((zzfm)((Object)object2)).zzjt().zza(string3, (zzfi[])object);
        try {
            zzfp2.zzawo = null;
            byte[] byArray2 = new byte[zzfp2.zzvx()];
            object2 = byArray2;
            zzya zzya2 = zzya.zzk((byte[])byArray2, (int)0, (int)((zzm)object2).length);
            zzfp2.zza(zzya2);
            byArray = byArray2;
        }
        catch (IOException iOException) {
            this.zzgt().zzjj().zze("Unable to serialize reduced-size config. Storing full config instead. appId", zzas.zzbw((String)string), (Object)iOException);
        }
        object = byArray;
        string3 = string;
        object2 = ((zzfm)this).zzjt();
        Preconditions.checkNotEmpty((String)string3);
        object2.zzaf();
        ((zzfn)((Object)object2)).zzcl();
        ContentValues contentValues = new ContentValues();
        contentValues.put("remote_config", (byte[])object);
        try {
            if ((long)((zzt)((Object)object2)).getWritableDatabase().update("apps", contentValues, "app_id = ?", new String[]{string3}) == 0L) {
                object2.zzgt().zzjg().zzg("Failed to update remote config (got 0). appId", zzas.zzbw((String)string3));
            }
        }
        catch (SQLiteException sQLiteException) {
            object2.zzgt().zzjg().zze("Error storing remote config. appId", zzas.zzbw((String)string3), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    final boolean zzo(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        if (this.zzcl(string) && zzfy.zzcy((String)string2)) {
            return true;
        }
        if (this.zzcm(string) && zzfy.zzct((String)string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaol.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final boolean zzp(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        if ("ecommerce_purchase".equals(string2)) {
            return true;
        }
        Map<String, Boolean> map = this.zzaom.get(string);
        if (map != null) {
            Boolean bl = map.get(string2);
            if (bl == null) {
                return false;
            }
            return bl;
        }
        return false;
    }

    @WorkerThread
    final int zzq(String string, String string2) {
        this.zzaf();
        this.zzcf(string);
        Map<String, Integer> map = this.zzaoo.get(string);
        if (map != null) {
            Integer n = map.get(string2);
            if (n == null) {
                return 1;
            }
            return n;
        }
        return 1;
    }

    @WorkerThread
    final long zzck(String string) {
        String string2 = this.zzf(string, "measurement.account.time_zone_offset_minutes");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.zzgt().zzjj().zze("Unable to parse timezone offset. appId", zzas.zzbw((String)string), (Object)numberFormatException);
            }
        }
        return 0L;
    }

    @WorkerThread
    private final zzfp zza(String string, byte[] byArray) {
        if (byArray == null) {
            return new zzfp();
        }
        byte[] byArray2 = byArray;
        zzxz zzxz2 = zzxz.zzj((byte[])byArray, (int)0, (int)byArray2.length);
        zzfp zzfp2 = new zzfp();
        try {
            zzfp2.zza(zzxz2);
            this.zzgt().zzjo().zze("Parsed config. version, gmp_app_id", (Object)zzfp2.zzawk, (Object)zzfp2.zzafi);
        }
        catch (IOException iOException) {
            this.zzgt().zzjj().zze("Unable to merge remote config. appId", zzas.zzbw((String)string), (Object)iOException);
            return new zzfp();
        }
        return zzfp2;
    }

    final boolean zzcl(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_internal"));
    }

    final boolean zzcm(String string) {
        return "1".equals(this.zzf(string, "measurement.upload.blacklist_public"));
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }
}

