/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzeu;
import com.google.android.gms.measurement.internal.zzev;
import com.google.android.gms.measurement.internal.zzew;
import com.google.android.gms.measurement.internal.zzex;

@VisibleForTesting
public final class zzes
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzaso;
    private volatile zzar zzasp;
    final /* synthetic */ zzeb zzasi;

    protected zzes(zzeb zzeb2) {
        this.zzasi = zzeb2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb(Intent intent) {
        ((zzcr)this.zzasi).zzaf();
        Context context = ((zzcr)this.zzasi).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzes zzes2 = this;
        synchronized (zzes2) {
            if (this.zzaso) {
                ((zzcr)this.zzasi).zzgt().zzjo().zzby("Connection attempt already in progress");
                return;
            }
            ((zzcr)this.zzasi).zzgt().zzjo().zzby("Using local app measurement service");
            this.zzaso = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzeb.zza(this.zzasi), 129);
            return;
        }
    }

    @WorkerThread
    public final void zzlk() {
        if (this.zzasp != null && (this.zzasp.isConnected() || this.zzasp.isConnecting())) {
            this.zzasp.disconnect();
        }
        this.zzasp = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzes zzes2 = this;
        synchronized (zzes2) {
            String string;
            if (iBinder == null) {
                this.zzaso = false;
                ((zzcr)this.zzasi).zzgt().zzjg().zzby("Service connected with null binder");
                return;
            }
            zzaj zzaj2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzaj2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzaj ? (zzaj)iInterface : new zzal(iBinder2));
                    ((zzcr)this.zzasi).zzgt().zzjo().zzby("Bound to IMeasurementService interface");
                } else {
                    ((zzcr)this.zzasi).zzgt().zzjg().zzg("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzcr)this.zzasi).zzgt().zzjg().zzby("Service connect failed to get IMeasurementService");
            }
            if (zzaj2 == null) {
                this.zzaso = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzcr)this.zzasi).getContext(), (ServiceConnection)zzeb.zza(this.zzasi));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzaj2;
                ((zzcr)this.zzasi).zzgs().zzc(new zzet(this, (zzaj)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzcr)this.zzasi).zzgt().zzjn().zzby("Service disconnected");
        ((zzcr)this.zzasi).zzgs().zzc(new zzeu(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzll() {
        ((zzcr)this.zzasi).zzaf();
        Context context = ((zzcr)this.zzasi).getContext();
        zzes zzes2 = this;
        synchronized (zzes2) {
            if (this.zzaso) {
                ((zzcr)this.zzasi).zzgt().zzjo().zzby("Connection attempt already in progress");
                return;
            }
            if (this.zzasp != null && (this.zzasp.isConnecting() || this.zzasp.isConnected())) {
                ((zzcr)this.zzasi).zzgt().zzjo().zzby("Already awaiting connection attempt");
                return;
            }
            this.zzasp = new zzar(context, Looper.getMainLooper(), this, this);
            ((zzcr)this.zzasi).zzgt().zzjo().zzby("Connecting to remote service");
            this.zzaso = true;
            this.zzasp.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzes zzes2 = this;
        synchronized (zzes2) {
            try {
                zzaj zzaj2 = (zzaj)this.zzasp.getService();
                ((zzcr)this.zzasi).zzgs().zzc(new zzev(this, zzaj2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzasp = null;
                this.zzaso = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzcr)this.zzasi).zzgt().zzjn().zzby("Service connection suspended");
        ((zzcr)this.zzasi).zzgs().zzc(new zzew(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzas zzas2 = this.zzasi.zzada.zzkj();
        if (zzas2 != null) {
            zzas2.zzjj().zzg("Service connection failed", connectionResult);
        }
        zzes zzes2 = this;
        synchronized (zzes2) {
            this.zzaso = false;
            this.zzasp = null;
        }
        ((zzcr)this.zzasi).zzgs().zzc(new zzex(this));
    }

    static /* synthetic */ boolean zza(zzes zzes2, boolean bl) {
        zzes2.zzaso = false;
        return false;
    }
}

