/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzsi;
import com.google.android.gms.measurement.AppMeasurement;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzbd;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzbm;
import com.google.android.gms.measurement.internal.zzbr;
import com.google.android.gms.measurement.internal.zzbx;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcs;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzcz;
import com.google.android.gms.measurement.internal.zzda;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzdy;
import com.google.android.gms.measurement.internal.zzeb;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzq;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class zzbw
implements zzct {
    private static volatile zzbw zzapg;
    private final Context zzri;
    private final String zzadi;
    private final String zzaph;
    private final String zzapi;
    private final boolean zzadg;
    private final zzn zzaih;
    private final zzq zzapj;
    private final zzbd zzapk;
    private final zzas zzapl;
    private final zzbr zzapm;
    private final zzfd zzapn;
    private final AppMeasurement zzapo;
    private final zzfy zzapp;
    private final zzaq zzapq;
    private final Clock zzrz;
    private final zzdy zzapr;
    private final zzda zzaps;
    private final zza zzapt;
    private zzao zzapu;
    private zzeb zzapv;
    private zzaa zzapw;
    private zzam zzapx;
    private zzbj zzapy;
    private boolean zzvz = false;
    private Boolean zzapz;
    private long zzaqa;
    private volatile Boolean zzaqb;
    @VisibleForTesting
    private Boolean zzaqc;
    @VisibleForTesting
    private Boolean zzaqd;
    private int zzaqe;
    private AtomicInteger zzaqf = new AtomicInteger(0);
    private final long zzago;

    private zzbw(zzcz zzcz2) {
        Object object;
        Preconditions.checkNotNull((Object)zzcz2);
        Object object2 = zzcz2.zzri;
        this.zzaih = new zzn((Context)object2);
        zzai.zza(this.zzaih);
        this.zzri = zzcz2.zzri;
        this.zzadi = zzcz2.zzadi;
        this.zzaph = zzcz2.zzaph;
        this.zzapi = zzcz2.zzapi;
        this.zzadg = zzcz2.zzadg;
        this.zzaqb = zzcz2.zzaqb;
        zzan zzan2 = zzcz2.zzaqw;
        if (zzan2 != null && zzan2.zzadj != null) {
            object = zzan2.zzadj.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzaqc = (Boolean)object;
            }
            if ((object = zzan2.zzadj.get("measurementDeactivated")) instanceof Boolean) {
                this.zzaqd = (Boolean)object;
            }
        }
        zzsi.zzae(this.zzri);
        this.zzrz = DefaultClock.getInstance();
        this.zzago = this.zzrz.currentTimeMillis();
        object2 = this;
        this.zzapj = new zzq((zzbw)object2);
        object2 = this;
        object = new zzbd((zzbw)object2);
        ((zzcs)object).zzq();
        this.zzapk = object;
        object2 = this;
        zzas zzas2 = new zzas((zzbw)object2);
        zzas2.zzq();
        this.zzapl = zzas2;
        object2 = this;
        zzfy zzfy2 = new zzfy((zzbw)object2);
        zzfy2.zzq();
        this.zzapp = zzfy2;
        object2 = this;
        zzaq zzaq2 = new zzaq((zzbw)object2);
        zzaq2.zzq();
        this.zzapq = zzaq2;
        object2 = this;
        this.zzapt = new zza((zzbw)object2);
        object2 = this;
        zzdy zzdy2 = new zzdy((zzbw)object2);
        zzdy2.zzq();
        this.zzapr = zzdy2;
        object2 = this;
        zzda zzda2 = new zzda((zzbw)object2);
        zzda2.zzq();
        this.zzaps = zzda2;
        object2 = this;
        this.zzapo = new AppMeasurement((zzbw)object2);
        object2 = this;
        zzfd zzfd2 = new zzfd((zzbw)object2);
        zzfd2.zzq();
        this.zzapn = zzfd2;
        object2 = this;
        zzbr zzbr2 = new zzbr((zzbw)object2);
        zzbr2.zzq();
        this.zzapm = zzbr2;
        object2 = this;
        zzn zzn2 = ((zzbw)object2).zzaih;
        if (((zzbw)object2).zzri.getApplicationContext() instanceof Application) {
            zzda zzda3 = ((zzbw)object2).zzgj();
            if (((zzcr)zzda3).getContext().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzcr)zzda3).getContext().getApplicationContext();
                if (zzda3.zzaqx == null) {
                    zzda3.zzaqx = new zzdu(zzda3, null);
                }
                zzdu zzdu2 = zzda3.zzaqx;
                application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdu2);
                zzdu2 = zzda3.zzaqx;
                application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdu2);
                ((zzcr)zzda3).zzgt().zzjo().zzby("Registered activity lifecycle callback");
            }
        } else {
            ((zzbw)object2).zzgt().zzjj().zzby("Application context is not an Application");
        }
        this.zzapm.zzc(new zzbx(this, zzcz2));
    }

    @WorkerThread
    private final void zza(zzcz zzcz2) {
        ((zzcr)this.zzgs()).zzaf();
        zzq.zzhy();
        zzbw zzbw2 = this;
        zzaa zzaa2 = new zzaa(zzbw2);
        zzaa2.zzq();
        this.zzapw = zzaa2;
        zzbw2 = this;
        zzam zzam2 = new zzam(zzbw2);
        zzam2.zzq();
        this.zzapx = zzam2;
        zzbw2 = this;
        zzao zzao2 = new zzao(zzbw2);
        zzao2.zzq();
        this.zzapu = zzao2;
        zzbw2 = this;
        zzeb zzeb2 = new zzeb(zzbw2);
        zzeb2.zzq();
        this.zzapv = zzeb2;
        this.zzapp.zzgx();
        this.zzapk.zzgx();
        zzbw2 = this;
        this.zzapy = new zzbj(zzbw2);
        this.zzapx.zzgx();
        this.zzgt().zzjm().zzg("App measurement is starting up, version", this.zzapj.zzhh());
        zzn zzn2 = this.zzaih;
        this.zzgt().zzjm().zzby("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        zzn2 = this.zzaih;
        String string = zzam2.zzal();
        if (TextUtils.isEmpty((CharSequence)this.zzadi)) {
            String string2;
            zzau zzau2;
            if (this.zzgr().zzcz(string)) {
                zzau2 = this.zzgt().zzjm();
                string2 = "Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.";
            } else {
                zzau2 = this.zzgt().zzjm();
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ".concat(string3) : new String("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app ");
            }
            zzau2.zzby(string2);
        }
        this.zzgt().zzjn().zzby("Debug-level message logging enabled");
        if (this.zzaqe != this.zzaqf.get()) {
            this.zzgt().zzjg().zze("Not all components initialized", this.zzaqe, this.zzaqf.get());
        }
        this.zzvz = true;
    }

    @WorkerThread
    protected final void start() {
        ((zzcr)this.zzgs()).zzaf();
        if (this.zzgu().zzana.get() == 0L) {
            this.zzgu().zzana.set(this.zzrz.currentTimeMillis());
        }
        if (Long.valueOf(this.zzgu().zzanf.get()) == 0L) {
            this.zzgt().zzjo().zzg("Persisting first open", this.zzago);
            this.zzgu().zzanf.set(this.zzago);
        }
        if (!this.zzkv()) {
            if (this.isEnabled()) {
                if (!this.zzgr().zzx("android.permission.INTERNET")) {
                    this.zzgt().zzjg().zzby("App is missing INTERNET permission");
                }
                if (!this.zzgr().zzx("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzgt().zzjg().zzby("App is missing ACCESS_NETWORK_STATE permission");
                }
                zzn zzn2 = this.zzaih;
                if (!Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() && !this.zzapj.zzif()) {
                    if (!zzbm.zza(this.zzri)) {
                        this.zzgt().zzjg().zzby("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zzfy.zza(this.zzri, false)) {
                        this.zzgt().zzjg().zzby("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzgt().zzjg().zzby("Uploading is not possible. App measurement disabled");
                return;
            }
        } else {
            zzn zzn3 = this.zzaih;
            if (!TextUtils.isEmpty((CharSequence)this.zzgk().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb())) {
                this.zzgr();
                if (zzfy.zza(this.zzgk().getGmpAppId(), this.zzgu().zzjv(), this.zzgk().zzhb(), this.zzgu().zzjw())) {
                    this.zzgt().zzjm().zzby("Rechecking which service to use due to a GMP App Id change");
                    this.zzgu().zzjy();
                    this.zzgn().resetAnalyticsData();
                    this.zzapv.disconnect();
                    this.zzapv.zzdj();
                    this.zzgu().zzanf.set(this.zzago);
                    this.zzgu().zzanh.zzcd(null);
                }
                this.zzgu().zzcb(this.zzgk().getGmpAppId());
                this.zzgu().zzcc(this.zzgk().zzhb());
                if (this.zzapj.zzbi(this.zzgk().zzal())) {
                    this.zzapn.zzaj(this.zzago);
                }
            }
            this.zzgj().zzcp(this.zzgu().zzanh.zzkd());
            zzn3 = this.zzaih;
            if (!TextUtils.isEmpty((CharSequence)this.zzgk().getGmpAppId()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb())) {
                boolean bl = this.isEnabled();
                if (!this.zzgu().zzkc() && !this.zzapj.zzhz()) {
                    this.zzgu().zzi(!bl);
                }
                if (!this.zzapj.zzba(this.zzgk().zzal()) || bl) {
                    this.zzgj().zzld();
                }
                this.zzgl().zza(new AtomicReference<String>());
            }
        }
    }

    @Override
    public final zzn zzgw() {
        return this.zzaih;
    }

    public final zzq zzgv() {
        return this.zzapj;
    }

    public final zzbd zzgu() {
        zzbw.zza((zzcr)this.zzapk);
        return this.zzapk;
    }

    @Override
    public final zzas zzgt() {
        zzbw.zza(this.zzapl);
        return this.zzapl;
    }

    public final zzas zzkj() {
        if (this.zzapl != null && this.zzapl.isInitialized()) {
            return this.zzapl;
        }
        return null;
    }

    @Override
    public final zzbr zzgs() {
        zzbw.zza(this.zzapm);
        return this.zzapm;
    }

    public final zzfd zzgo() {
        zzbw.zza(this.zzapn);
        return this.zzapn;
    }

    public final zzbj zzkk() {
        return this.zzapy;
    }

    final zzbr zzkl() {
        return this.zzapm;
    }

    public final zzda zzgj() {
        zzbw.zza(this.zzaps);
        return this.zzaps;
    }

    public final AppMeasurement zzkm() {
        return this.zzapo;
    }

    public final zzfy zzgr() {
        zzbw.zza((zzcr)this.zzapp);
        return this.zzapp;
    }

    public final zzaq zzgq() {
        zzbw.zza((zzcr)this.zzapq);
        return this.zzapq;
    }

    public final zzao zzgn() {
        zzbw.zza(this.zzapu);
        return this.zzapu;
    }

    @Override
    public final Context getContext() {
        return this.zzri;
    }

    public final boolean zzkn() {
        return TextUtils.isEmpty((CharSequence)this.zzadi);
    }

    public final String zzko() {
        return this.zzadi;
    }

    public final String zzkp() {
        return this.zzaph;
    }

    public final String zzkq() {
        return this.zzapi;
    }

    public final boolean zzkr() {
        return this.zzadg;
    }

    @Override
    public final Clock zzbx() {
        return this.zzrz;
    }

    public final zzdy zzgm() {
        zzbw.zza(this.zzapr);
        return this.zzapr;
    }

    public final zzeb zzgl() {
        zzbw.zza(this.zzapv);
        return this.zzapv;
    }

    public final zzaa zzgp() {
        zzbw.zza(this.zzapw);
        return this.zzapw;
    }

    public final zzam zzgk() {
        zzbw.zza(this.zzapx);
        return this.zzapx;
    }

    public final zza zzgi() {
        if (this.zzapt == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzapt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzbw zza(Context context, zzan zzan2) {
        if (zzan2 != null && (zzan2.origin == null || zzan2.zzadi == null)) {
            zzan2 = new zzan(zzan2.zzade, zzan2.zzadf, zzan2.zzadg, zzan2.zzadh, null, null, zzan2.zzadj);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzapg == null) {
            Class<zzbw> clazz = zzbw.class;
            synchronized (zzbw.class) {
                if (zzapg == null) {
                    zzcz zzcz2 = new zzcz(context, zzan2);
                    zzapg = new zzbw(zzcz2);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (zzan2 != null && zzan2.zzadj != null && zzan2.zzadj.containsKey("dataCollectionDefaultEnabled")) {
            zzapg.zzd(zzan2.zzadj.getBoolean("dataCollectionDefaultEnabled"));
        }
        return zzapg;
    }

    private final void zzcl() {
        if (!this.zzvz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
    }

    private static void zza(zzcs zzcs2) {
        if (zzcs2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzcs2.isInitialized()) {
            String string = String.valueOf(zzcs2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzf zzf2) {
        if (zzf2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzf2.isInitialized()) {
            String string = String.valueOf(zzf2.getClass());
            throw new IllegalStateException(new StringBuilder(27 + String.valueOf(string).length()).append("Component not initialized: ").append(string).toString());
        }
    }

    private static void zza(zzcr zzcr2) {
        if (zzcr2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    @WorkerThread
    final void zzd(boolean bl) {
        this.zzaqb = bl;
    }

    @WorkerThread
    public final boolean zzks() {
        return this.zzaqb != null && this.zzaqb != false;
    }

    @WorkerThread
    public final boolean isEnabled() {
        boolean bl;
        ((zzcr)this.zzgs()).zzaf();
        this.zzcl();
        if (this.zzapj.zza(zzai.zzalc)) {
            if (this.zzapj.zzhz()) {
                return false;
            }
            if (this.zzaqd != null && this.zzaqd.booleanValue()) {
                return false;
            }
            Boolean bl2 = this.zzgu().zzjz();
            if (bl2 != null) {
                return bl2;
            }
            Boolean bl3 = this.zzapj.zzia();
            if (bl3 != null) {
                return bl3;
            }
            if (this.zzaqc != null) {
                return this.zzaqc;
            }
            if (GoogleServices.isMeasurementExplicitlyDisabled()) {
                return false;
            }
            if (this.zzapj.zza(zzai.zzaky) && this.zzaqb != null) {
                return this.zzaqb;
            }
            return true;
        }
        if (this.zzapj.zzhz()) {
            return false;
        }
        Boolean bl4 = this.zzapj.zzia();
        if (bl4 != null) {
            bl = bl4;
        } else {
            bl = !GoogleServices.isMeasurementExplicitlyDisabled();
            if (bl && this.zzaqb != null && zzai.zzaky.get().booleanValue()) {
                bl = this.zzaqb;
            }
        }
        return this.zzgu().zzh(bl);
    }

    final long zzkt() {
        Long l = this.zzgu().zzanf.get();
        if (l == 0L) {
            return this.zzago;
        }
        return Math.min(this.zzago, l);
    }

    final void zzgg() {
        zzn zzn2 = this.zzaih;
    }

    final void zzgf() {
        zzn zzn2 = this.zzaih;
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzb(zzcs zzcs2) {
        ++this.zzaqe;
    }

    final void zzb(zzf zzf2) {
        ++this.zzaqe;
    }

    final void zzku() {
        this.zzaqf.incrementAndGet();
    }

    @WorkerThread
    protected final boolean zzkv() {
        this.zzcl();
        ((zzcr)this.zzgs()).zzaf();
        if (this.zzapz == null || this.zzaqa == 0L || this.zzapz != null && !this.zzapz.booleanValue() && Math.abs(this.zzrz.elapsedRealtime() - this.zzaqa) > 1000L) {
            this.zzaqa = this.zzrz.elapsedRealtime();
            zzn zzn2 = this.zzaih;
            this.zzapz = this.zzgr().zzx("android.permission.INTERNET") && this.zzgr().zzx("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzri).isCallerInstantApp() || this.zzapj.zzif() || zzbm.zza(this.zzri) && zzfy.zza(this.zzri, false));
            if (this.zzapz.booleanValue()) {
                this.zzapz = this.zzgr().zzu(this.zzgk().getGmpAppId(), this.zzgk().zzhb()) || !TextUtils.isEmpty((CharSequence)this.zzgk().zzhb());
            }
        }
        return this.zzapz;
    }

    static /* synthetic */ void zza(zzbw zzbw2, zzcz zzcz2) {
        zzbw2.zza(zzcz2);
    }
}

