/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzbt;
import com.google.android.gms.measurement.internal.zzbu;
import com.google.android.gms.measurement.internal.zzbv;
import com.google.android.gms.measurement.internal.zzbw;
import com.google.android.gms.measurement.internal.zzcr;
import com.google.android.gms.measurement.internal.zzcs;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzbr
extends zzcs {
    private ExecutorService zzadl;
    private zzbv zzaoq;
    private zzbv zzaor;
    private final PriorityBlockingQueue<zzbu<?>> zzaos;
    private final BlockingQueue<zzbu<?>> zzaot;
    private final Thread.UncaughtExceptionHandler zzaou;
    private final Thread.UncaughtExceptionHandler zzaov;
    private final Object zzaow = new Object();
    private final Semaphore zzaox = new Semaphore(2);
    private volatile boolean zzaoy;
    private static final AtomicLong zzaoz = new AtomicLong(Long.MIN_VALUE);

    zzbr(zzbw zzbw2) {
        super(zzbw2);
        this.zzaos = new PriorityBlockingQueue();
        this.zzaot = new LinkedBlockingQueue();
        this.zzaou = new zzbt(this, "Thread death: Uncaught exception on worker thread");
        this.zzaov = new zzbt(this, "Thread death: Uncaught exception on network thread");
    }

    @Override
    protected final boolean zzgy() {
        return false;
    }

    @Override
    public final void zzaf() {
        if (Thread.currentThread() != this.zzaoq) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzgh() {
        if (Thread.currentThread() != this.zzaor) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final boolean zzkf() {
        return Thread.currentThread() == this.zzaoq;
    }

    public final <V> Future<V> zzb(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbu zzbu2 = new zzbu(this, callable, false, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzaoq) {
            if (!this.zzaos.isEmpty()) {
                ((zzcr)this).zzgt().zzjj().zzby("Callable skipped the worker queue.");
            }
            zzbu2.run();
        } else {
            this.zza(zzbu2);
        }
        return zzbu2;
    }

    public final <V> Future<V> zzc(Callable<V> callable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull(callable);
        zzbu zzbu2 = new zzbu(this, callable, true, "Task exception on worker thread");
        if (Thread.currentThread() == this.zzaoq) {
            zzbu2.run();
        } else {
            this.zza(zzbu2);
        }
        return zzbu2;
    }

    public final void zzc(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        this.zza(new zzbu(this, runnable, false, "Task exception on worker thread"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <T> T zza(AtomicReference<T> atomicReference, long l, String string, Runnable runnable) {
        AtomicReference<T> atomicReference2 = atomicReference;
        synchronized (atomicReference2) {
            ((zzcr)this).zzgs().zzc(runnable);
            try {
                atomicReference.wait(15000L);
            }
            catch (InterruptedException interruptedException) {
                String string2 = String.valueOf(string);
                ((zzcr)this).zzgt().zzjj().zzby(string2.length() != 0 ? "Interrupted waiting for ".concat(string2) : new String("Interrupted waiting for "));
                return null;
            }
        }
        atomicReference2 = atomicReference.get();
        if (atomicReference2 == null) {
            String string3 = String.valueOf(string);
            ((zzcr)this).zzgt().zzjj().zzby(string3.length() != 0 ? "Timed out waiting for ".concat(string3) : new String("Timed out waiting for "));
        }
        return (T)atomicReference2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(zzbu<?> zzbu2) {
        Object object = this.zzaow;
        synchronized (object) {
            this.zzaos.add(zzbu2);
            if (this.zzaoq == null) {
                this.zzaoq = new zzbv(this, "Measurement Worker", this.zzaos);
                this.zzaoq.setUncaughtExceptionHandler(this.zzaou);
                this.zzaoq.start();
            } else {
                this.zzaoq.zzki();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzd(Runnable runnable) throws IllegalStateException {
        this.zzcl();
        Preconditions.checkNotNull((Object)runnable);
        zzbu zzbu2 = new zzbu(this, runnable, false, "Task exception on network thread");
        zzbr zzbr2 = this;
        Object object = zzbr2.zzaow;
        synchronized (object) {
            zzbr2.zzaot.add(zzbu2);
            if (zzbr2.zzaor == null) {
                zzbr2.zzaor = new zzbv(zzbr2, "Measurement Network", zzbr2.zzaot);
                zzbr2.zzaor.setUncaughtExceptionHandler(zzbr2.zzaov);
                zzbr2.zzaor.start();
            } else {
                zzbr2.zzaor.zzki();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ExecutorService zzkg() {
        Object object = this.zzaow;
        synchronized (object) {
            if (this.zzadl == null) {
                this.zzadl = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100));
            }
            return this.zzadl;
        }
    }

    static /* synthetic */ Semaphore zza(zzbr zzbr2) {
        return zzbr2.zzaox;
    }

    static /* synthetic */ boolean zzb(zzbr zzbr2) {
        return zzbr2.zzaoy;
    }

    static /* synthetic */ Object zzc(zzbr zzbr2) {
        return zzbr2.zzaow;
    }

    static /* synthetic */ zzbv zzd(zzbr zzbr2) {
        return zzbr2.zzaoq;
    }

    static /* synthetic */ zzbv zza(zzbr zzbr2, zzbv zzbv2) {
        zzbr2.zzaoq = null;
        return null;
    }

    static /* synthetic */ zzbv zze(zzbr zzbr2) {
        return zzbr2.zzaor;
    }

    static /* synthetic */ zzbv zzb(zzbr zzbr2, zzbv zzbv2) {
        zzbr2.zzaor = null;
        return null;
    }

    static /* synthetic */ AtomicLong zzkh() {
        return zzaoz;
    }
}

