/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.annotation.TargetApi;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.PersistableBundle;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcka;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcmy;
import com.google.android.gms.internal.zzcnk;

public final class zzcnj
extends zzcli {
    private final AlarmManager zzjsf = (AlarmManager)((zzclh)this).getContext().getSystemService("alarm");
    private final zzcip zzjsg;
    private Integer zzebk;

    protected zzcnj(zzckj zzckj2) {
        super(zzckj2);
        this.zzjsg = new zzcnk(this, zzckj2, zzckj2);
    }

    @Override
    protected final boolean zzazq() {
        this.zzjsf.cancel(this.zzaak());
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzbcp();
        }
        return false;
    }

    @TargetApi(value=24)
    private final void zzbcp() {
        JobScheduler jobScheduler = (JobScheduler)((zzclh)this).getContext().getSystemService("jobscheduler");
        ((zzclh)this).zzayp().zzbba().zzj("Cancelling job. JobID", this.getJobId());
        jobScheduler.cancel(this.getJobId());
    }

    public final void zzs(long l) {
        this.zzyk();
        if (!zzcka.zzbj(((zzclh)this).getContext())) {
            ((zzclh)this).zzayp().zzbaz().log("Receiver not registered/enabled");
        }
        if (!zzcmy.zzg(((zzclh)this).getContext(), false)) {
            ((zzclh)this).zzayp().zzbaz().log("Service not registered/enabled");
        }
        this.cancel();
        long l2 = ((zzclh)this).zzxx().elapsedRealtime() + l;
        if (l < Math.max(0L, zzciz.zzjjk.get()) && !this.zzjsg.zzea()) {
            ((zzclh)this).zzayp().zzbba().log("Scheduling upload with DelayedRunnable");
            this.zzjsg.zzs(l);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            ((zzclh)this).zzayp().zzbba().log("Scheduling upload with JobScheduler");
            long l3 = l;
            zzcnj zzcnj2 = this;
            ComponentName componentName = new ComponentName(((zzclh)zzcnj2).getContext(), "com.google.android.gms.measurement.AppMeasurementJobService");
            JobScheduler jobScheduler = (JobScheduler)((zzclh)zzcnj2).getContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(zzcnj2.getJobId(), componentName);
            builder.setMinimumLatency(l3);
            builder.setOverrideDeadline(l3 << 1);
            PersistableBundle persistableBundle = new PersistableBundle();
            persistableBundle.putString("action", "com.google.android.gms.measurement.UPLOAD");
            builder.setExtras(persistableBundle);
            JobInfo jobInfo = builder.build();
            ((zzclh)zzcnj2).zzayp().zzbba().zzj("Scheduling job. JobID", zzcnj2.getJobId());
            jobScheduler.schedule(jobInfo);
            return;
        }
        ((zzclh)this).zzayp().zzbba().log("Scheduling upload with AlarmManager");
        this.zzjsf.setInexactRepeating(2, l2, Math.max(zzciz.zzjjf.get(), l), this.zzaak());
    }

    private final int getJobId() {
        if (this.zzebk == null) {
            String string = String.valueOf(((zzclh)this).getContext().getPackageName());
            this.zzebk = (string.length() != 0 ? "measurement".concat(string) : new String("measurement")).hashCode();
        }
        return this.zzebk;
    }

    public final void cancel() {
        this.zzyk();
        this.zzjsf.cancel(this.zzaak());
        this.zzjsg.cancel();
        if (Build.VERSION.SDK_INT >= 24) {
            this.zzbcp();
        }
    }

    private final PendingIntent zzaak() {
        Intent intent = new Intent().setClassName(((zzclh)this).getContext(), "com.google.android.gms.measurement.AppMeasurementReceiver");
        intent.setAction("com.google.android.gms.measurement.UPLOAD");
        return PendingIntent.getBroadcast((Context)((zzclh)this).getContext(), (int)0, (Intent)intent, (int)0);
    }
}

