/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.Hide;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.common.stats.zza;
import com.google.android.gms.common.zzf;
import com.google.android.gms.internal.zzbgl;
import com.google.android.gms.internal.zzcif;
import com.google.android.gms.internal.zzcii;
import com.google.android.gms.internal.zzcip;
import com.google.android.gms.internal.zzcix;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjb;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzclh;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzclz;
import com.google.android.gms.internal.zzcmf;
import com.google.android.gms.internal.zzcmg;
import com.google.android.gms.internal.zzcmh;
import com.google.android.gms.internal.zzcmi;
import com.google.android.gms.internal.zzcmj;
import com.google.android.gms.internal.zzcmk;
import com.google.android.gms.internal.zzcml;
import com.google.android.gms.internal.zzcmm;
import com.google.android.gms.internal.zzcmn;
import com.google.android.gms.internal.zzcmo;
import com.google.android.gms.internal.zzcmp;
import com.google.android.gms.internal.zzcmq;
import com.google.android.gms.internal.zzcmr;
import com.google.android.gms.internal.zzcms;
import com.google.android.gms.internal.zzcni;
import com.google.android.gms.internal.zzcnl;
import com.google.android.gms.internal.zzcno;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@Hide
public final class zzcme
extends zzcli {
    private final zzcms zzjrb;
    private zzcjb zzjrc;
    private volatile Boolean zzjrd;
    private final zzcip zzjre;
    private final zzcni zzjrf;
    private final List<Runnable> zzjrg = new ArrayList<Runnable>();
    private final zzcip zzjrh;

    protected zzcme(zzckj zzckj2) {
        super(zzckj2);
        this.zzjrf = new zzcni(zzckj2.zzxx());
        this.zzjrb = new zzcms(this);
        this.zzjre = new zzcmf(this, zzckj2);
        this.zzjrh = new zzcmk(this, zzckj2);
    }

    @Override
    protected final boolean zzazq() {
        return false;
    }

    @WorkerThread
    public final boolean isConnected() {
        ((zzclh)this).zzwj();
        this.zzyk();
        return this.zzjrc != null;
    }

    @WorkerThread
    protected final void zzbci() {
        ((zzclh)this).zzwj();
        this.zzyk();
        zzcif zzcif2 = this.zzbw(true);
        this.zzk(new zzcml(this, zzcif2));
    }

    @WorkerThread
    final void zza(zzcjb zzcjb2, zzbgl zzbgl2, zzcif zzcif2) {
        ((zzclh)this).zzwj();
        this.zzyk();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<zzbgl> arrayList = new ArrayList<zzbgl>();
            n = 0;
            List<zzbgl> list = ((zzclh)this).zzayi().zzep(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (zzbgl2 != null && n < 100) {
                arrayList.add(zzbgl2);
            }
            ArrayList<zzbgl> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                zzbgl zzbgl3 = (zzbgl)e;
                if (zzbgl3 instanceof zzcix) {
                    try {
                        zzcjb2.zza((zzcix)zzbgl3, zzcif2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzclh)this).zzayp().zzbau().zzj("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbgl3 instanceof zzcnl) {
                    try {
                        zzcjb2.zza((zzcnl)zzbgl3, zzcif2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzclh)this).zzayp().zzbau().zzj("Failed to send attribute to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (zzbgl3 instanceof zzcii) {
                    try {
                        zzcjb2.zza((zzcii)zzbgl3, zzcif2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzclh)this).zzayp().zzbau().zzj("Failed to send conditional property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzclh)this).zzayp().zzbau().log("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zzc(zzcix zzcix2, String string) {
        zzbq.checkNotNull((Object)((Object)zzcix2));
        ((zzclh)this).zzwj();
        this.zzyk();
        boolean bl = ((zzclh)this).zzayi().zza(zzcix2);
        zzcif zzcif2 = this.zzbw(true);
        this.zzk(new zzcmm(this, true, bl, zzcix2, zzcif2, string));
    }

    @WorkerThread
    protected final void zzf(zzcii zzcii2) {
        zzbq.checkNotNull((Object)((Object)zzcii2));
        ((zzclh)this).zzwj();
        this.zzyk();
        boolean bl = ((zzclh)this).zzayi().zzc(zzcii2);
        zzcii zzcii3 = new zzcii(zzcii2);
        zzcif zzcif2 = this.zzbw(true);
        this.zzk(new zzcmn(this, true, bl, zzcii3, zzcif2, zzcii2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcii>> atomicReference, String string, String string2, String string3) {
        ((zzclh)this).zzwj();
        this.zzyk();
        zzcif zzcif2 = this.zzbw(false);
        this.zzk(new zzcmo(this, atomicReference, string, string2, string3, zzcif2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcnl>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzclh)this).zzwj();
        this.zzyk();
        zzcif zzcif2 = this.zzbw(false);
        this.zzk(new zzcmp(this, atomicReference, string, string2, string3, bl, zzcif2));
    }

    @WorkerThread
    protected final void zzb(zzcnl zzcnl2) {
        ((zzclh)this).zzwj();
        this.zzyk();
        boolean bl = ((zzclh)this).zzayi().zza(zzcnl2);
        zzcif zzcif2 = this.zzbw(true);
        this.zzk(new zzcmq(this, bl, zzcnl2, zzcif2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzcnl>> atomicReference, boolean bl) {
        ((zzclh)this).zzwj();
        this.zzyk();
        zzcif zzcif2 = this.zzbw(false);
        this.zzk(new zzcmr(this, atomicReference, zzcif2, bl));
    }

    @WorkerThread
    protected final void resetAnalyticsData() {
        ((zzclh)this).zzwj();
        this.zzyk();
        zzcif zzcif2 = this.zzbw(false);
        ((zzclh)this).zzayi().resetAnalyticsData();
        this.zzk(new zzcmg(this, zzcif2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzclh)this).zzwj();
        this.zzyk();
        zzcif zzcif2 = this.zzbw(false);
        this.zzk(new zzcmh(this, atomicReference, zzcif2));
    }

    @WorkerThread
    protected final void zzbcj() {
        ((zzclh)this).zzwj();
        this.zzyk();
        zzcif zzcif2 = this.zzbw(true);
        this.zzk(new zzcmi(this, zzcif2));
    }

    @WorkerThread
    protected final void zza(zzclz zzclz2) {
        ((zzclh)this).zzwj();
        this.zzyk();
        this.zzk(new zzcmj(this, zzclz2));
    }

    @WorkerThread
    private final void zzyw() {
        ((zzclh)this).zzwj();
        this.zzjrf.start();
        this.zzjre.zzs(zzciz.zzjjt.get());
    }

    @WorkerThread
    final void zzzh() {
        Intent intent;
        Object object;
        zzcme zzcme2;
        ((zzclh)this).zzwj();
        this.zzyk();
        if (this.isConnected()) {
            return;
        }
        if (this.zzjrd == null) {
            boolean bl;
            zzcme2 = this;
            ((zzclh)zzcme2).zzwj();
            zzcme2.zzyk();
            object = ((zzclh)zzcme2).zzayq().zzbbg();
            if (object != null && ((Boolean)object).booleanValue()) {
                bl = true;
            } else {
                boolean bl2;
                boolean bl3;
                if (((zzclh)zzcme2).zzaye().zzbas() == 1) {
                    bl3 = true;
                    bl2 = true;
                } else {
                    ((zzclh)zzcme2).zzayp().zzbba().log("Checking service availability");
                    zzcno zzcno2 = ((zzclh)zzcme2).zzayl();
                    int n = zzf.zzahf().isGooglePlayServicesAvailable(((zzclh)zzcno2).getContext());
                    switch (n) {
                        case 0: {
                            ((zzclh)zzcme2).zzayp().zzbba().log("Service available");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            ((zzclh)zzcme2).zzayp().zzbba().log("Service missing");
                            bl3 = false;
                            bl2 = true;
                            break;
                        }
                        case 18: {
                            ((zzclh)zzcme2).zzayp().zzbaw().log("Service updating");
                            bl3 = true;
                            bl2 = true;
                            break;
                        }
                        case 2: {
                            ((zzclh)zzcme2).zzayp().zzbaz().log("Service container out of date");
                            if (12211L < 11800L) {
                                bl3 = false;
                                bl2 = true;
                                break;
                            }
                            Boolean bl4 = ((zzclh)zzcme2).zzayq().zzbbg();
                            bl3 = bl4 == null || bl4 != false;
                            bl2 = false;
                            break;
                        }
                        case 3: {
                            ((zzclh)zzcme2).zzayp().zzbaw().log("Service disabled");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        case 9: {
                            ((zzclh)zzcme2).zzayp().zzbaw().log("Service invalid");
                            bl3 = false;
                            bl2 = false;
                            break;
                        }
                        default: {
                            ((zzclh)zzcme2).zzayp().zzbaw().zzj("Unexpected service status", n);
                            bl3 = false;
                            bl2 = false;
                        }
                    }
                }
                if (bl2) {
                    ((zzclh)zzcme2).zzayq().zzbr(bl3);
                }
                bl = bl3;
            }
            this.zzjrd = bl;
        }
        if (this.zzjrd.booleanValue()) {
            this.zzjrb.zzbcm();
            return;
        }
        zzcme2 = this;
        object = ((zzclh)zzcme2).getContext().getPackageManager();
        List list = object.queryIntentServices(intent = new Intent().setClassName(((zzclh)zzcme2).getContext(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
        if (list != null && list.size() > 0) {
            Intent intent2 = new Intent("com.google.android.gms.measurement.START");
            intent2.setComponent(new ComponentName(((zzclh)this).getContext(), "com.google.android.gms.measurement.AppMeasurementService"));
            this.zzjrb.zzm(intent2);
            return;
        }
        ((zzclh)this).zzayp().zzbau().log("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
    }

    final Boolean zzbck() {
        return this.zzjrd;
    }

    @WorkerThread
    protected final void zza(zzcjb zzcjb2) {
        ((zzclh)this).zzwj();
        zzbq.checkNotNull((Object)zzcjb2);
        this.zzjrc = zzcjb2;
        this.zzyw();
        this.zzbcl();
    }

    @WorkerThread
    public final void disconnect() {
        ((zzclh)this).zzwj();
        this.zzyk();
        try {
            zza.zzanm();
            zzcms zzcms2 = this.zzjrb;
            Context context = ((zzclh)this).getContext();
            context.unbindService((ServiceConnection)zzcms2);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzjrc = null;
    }

    @WorkerThread
    private final void onServiceDisconnected(ComponentName componentName) {
        ((zzclh)this).zzwj();
        if (this.zzjrc != null) {
            this.zzjrc = null;
            ((zzclh)this).zzayp().zzbba().zzj("Disconnected from device MeasurementService", componentName);
            zzcme zzcme2 = this;
            ((zzclh)zzcme2).zzwj();
            zzcme2.zzzh();
        }
    }

    @WorkerThread
    private final void zzyx() {
        ((zzclh)this).zzwj();
        if (!this.isConnected()) {
            return;
        }
        ((zzclh)this).zzayp().zzbba().log("Inactivity, disconnecting from the service");
        this.disconnect();
    }

    @WorkerThread
    private final void zzk(Runnable runnable) throws IllegalStateException {
        ((zzclh)this).zzwj();
        if (this.isConnected()) {
            runnable.run();
            return;
        }
        if ((long)this.zzjrg.size() >= 1000L) {
            ((zzclh)this).zzayp().zzbau().log("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzjrg.add(runnable);
        this.zzjrh.zzs(60000L);
        this.zzzh();
    }

    @WorkerThread
    private final void zzbcl() {
        ((zzclh)this).zzwj();
        ((zzclh)this).zzayp().zzbba().zzj("Processing queued up service tasks", this.zzjrg.size());
        for (Runnable runnable : this.zzjrg) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                ((zzclh)this).zzayp().zzbau().zzj("Task exception while flushing queue", throwable);
            }
        }
        this.zzjrg.clear();
        this.zzjrh.cancel();
    }

    @WorkerThread
    @Nullable
    private final zzcif zzbw(boolean bl) {
        return ((zzclh)this).zzaye().zzjo(bl ? ((zzclh)this).zzayp().zzbbc() : null);
    }

    static /* synthetic */ zzcms zza(zzcme zzcme2) {
        return zzcme2.zzjrb;
    }

    static /* synthetic */ void zza(zzcme zzcme2, ComponentName componentName) {
        zzcme2.onServiceDisconnected(componentName);
    }

    static /* synthetic */ zzcjb zza(zzcme zzcme2, zzcjb zzcjb2) {
        zzcme2.zzjrc = null;
        return null;
    }

    static /* synthetic */ void zzb(zzcme zzcme2) {
        zzcme2.zzbcl();
    }

    static /* synthetic */ void zzc(zzcme zzcme2) {
        zzcme2.zzyx();
    }

    static /* synthetic */ zzcjb zzd(zzcme zzcme2) {
        return zzcme2.zzjrc;
    }

    static /* synthetic */ void zze(zzcme zzcme2) {
        zzcme2.zzyw();
    }
}

