/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.internal.zzciz;
import com.google.android.gms.internal.zzcjw;
import com.google.android.gms.internal.zzcjx;
import com.google.android.gms.internal.zzcjy;
import com.google.android.gms.internal.zzcjz;
import com.google.android.gms.internal.zzckj;
import com.google.android.gms.internal.zzcli;
import com.google.android.gms.internal.zzcno;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Locale;

final class zzcju
extends zzcli {
    static final Pair<String, Long> zzjlk = new Pair((Object)"", (Object)0L);
    private SharedPreferences zzjll;
    public zzcjy zzjlm;
    public final zzcjx zzjln = new zzcjx(this, "last_upload", 0L);
    public final zzcjx zzjlo = new zzcjx(this, "last_upload_attempt", 0L);
    public final zzcjx zzjlp = new zzcjx(this, "backoff", 0L);
    public final zzcjx zzjlq = new zzcjx(this, "last_delete_stale", 0L);
    public final zzcjx zzjlr;
    public final zzcjx zzjls;
    public final zzcjz zzjlt;
    private String zzjlu;
    private boolean zzjlv;
    private long zzjlw;
    private String zzjlx;
    private long zzjly;
    private final Object zzjlz;
    public final zzcjx zzjma = new zzcjx(this, "time_before_start", 10000L);
    public final zzcjx zzjmb = new zzcjx(this, "session_timeout", 1800000L);
    public final zzcjw zzjmc = new zzcjw(this, "start_new_session", true);
    public final zzcjx zzjmd = new zzcjx(this, "last_pause_time", 0L);
    public final zzcjx zzjme = new zzcjx(this, "time_active", 0L);
    public boolean zzjmf;

    @WorkerThread
    @NonNull
    final Pair<String, Boolean> zzju(String string) {
        this.zzwj();
        long l = this.zzxx().elapsedRealtime();
        if (this.zzjlu != null && l < this.zzjlw) {
            return new Pair((Object)this.zzjlu, (Object)this.zzjlv);
        }
        String string2 = string;
        this.zzjlw = l + this.zzayr().zza(string2, zzciz.zzjio);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)this.getContext());
            if (info != null) {
                this.zzjlu = info.getId();
                this.zzjlv = info.isLimitAdTrackingEnabled();
            }
            if (this.zzjlu == null) {
                this.zzjlu = "";
            }
        }
        catch (Throwable throwable) {
            this.zzayp().zzbaz().zzj("Unable to get advertising id", throwable);
            this.zzjlu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzjlu, (Object)this.zzjlv);
    }

    @WorkerThread
    final String zzjv(String string) {
        this.zzwj();
        String string2 = (String)this.zzju((String)string).first;
        MessageDigest messageDigest = zzcno.zzeq("MD5");
        if (messageDigest == null) {
            return null;
        }
        return String.format(Locale.US, "%032X", new BigInteger(1, messageDigest.digest(string2.getBytes())));
    }

    zzcju(zzckj zzckj2) {
        super(zzckj2);
        this.zzjlr = new zzcjx(this, "midnight_offset", 0L);
        this.zzjls = new zzcjx(this, "first_open_time", 0L);
        this.zzjlt = new zzcjz(this, "app_instance_id", null);
        this.zzjlz = new Object();
    }

    @Override
    protected final boolean zzazq() {
        return true;
    }

    @Override
    @WorkerThread
    protected final void zzbap() {
        this.zzjll = this.getContext().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzjmf = this.zzjll.getBoolean("has_been_opened", false);
        if (!this.zzjmf) {
            SharedPreferences.Editor editor = this.zzjll.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzjlm = new zzcjy(this, "health_monitor", Math.max(0L, zzciz.zzjip.get()), null);
    }

    @WorkerThread
    private final SharedPreferences zzbbd() {
        this.zzwj();
        this.zzyk();
        return this.zzjll;
    }

    @WorkerThread
    final void zzjw(String string) {
        this.zzwj();
        SharedPreferences.Editor editor = this.zzbbd().edit();
        editor.putString("gmp_app_id", string);
        editor.apply();
    }

    @WorkerThread
    final String zzbbe() {
        this.zzwj();
        return this.zzbbd().getString("gmp_app_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzjx(String string) {
        Object object = this.zzjlz;
        synchronized (object) {
            this.zzjlx = string;
            this.zzjly = this.zzxx().elapsedRealtime();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final String zzbbf() {
        Object object = this.zzjlz;
        synchronized (object) {
            if (Math.abs(this.zzxx().elapsedRealtime() - this.zzjly) < 1000L) {
                return this.zzjlx;
            }
            return null;
        }
    }

    @WorkerThread
    final Boolean zzbbg() {
        this.zzwj();
        if (!this.zzbbd().contains("use_service")) {
            return null;
        }
        return this.zzbbd().getBoolean("use_service", false);
    }

    @WorkerThread
    final void zzbr(boolean bl) {
        this.zzwj();
        this.zzayp().zzbba().zzj("Setting useService", bl);
        SharedPreferences.Editor editor = this.zzbbd().edit();
        editor.putBoolean("use_service", bl);
        editor.apply();
    }

    @WorkerThread
    final void zzbbh() {
        this.zzwj();
        this.zzayp().zzbba().log("Clearing collection preferences.");
        boolean bl = this.zzbbd().contains("measurement_enabled");
        boolean bl2 = true;
        if (bl) {
            bl2 = this.zzbs(true);
        }
        SharedPreferences.Editor editor = this.zzbbd().edit();
        editor.clear();
        editor.apply();
        if (bl) {
            this.setMeasurementEnabled(bl2);
        }
    }

    @WorkerThread
    final void setMeasurementEnabled(boolean bl) {
        this.zzwj();
        this.zzayp().zzbba().zzj("Setting measurementEnabled", bl);
        SharedPreferences.Editor editor = this.zzbbd().edit();
        editor.putBoolean("measurement_enabled", bl);
        editor.apply();
    }

    @WorkerThread
    final boolean zzbs(boolean bl) {
        this.zzwj();
        return this.zzbbd().getBoolean("measurement_enabled", bl);
    }

    @WorkerThread
    protected final String zzbbi() {
        this.zzwj();
        String string = this.zzbbd().getString("previous_os_version", null);
        this.zzayf().zzyk();
        String string2 = Build.VERSION.RELEASE;
        if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
            SharedPreferences.Editor editor = this.zzbbd().edit();
            editor.putString("previous_os_version", string2);
            editor.apply();
        }
        return string;
    }

    static /* synthetic */ SharedPreferences zza(zzcju zzcju2) {
        return zzcju2.zzbbd();
    }
}

