/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.remoteconfig;

import com.google.api.core.ApiFuture;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.CallableOperation;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigClient;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigClientImpl;
import com.google.firebase.remoteconfig.FirebaseRemoteConfigException;
import com.google.firebase.remoteconfig.ListVersionsOptions;
import com.google.firebase.remoteconfig.ListVersionsPage;
import com.google.firebase.remoteconfig.PublishOptions;
import com.google.firebase.remoteconfig.Template;

public final class FirebaseRemoteConfig {
    private static final String SERVICE_ID = FirebaseRemoteConfig.class.getName();
    private final FirebaseApp app;
    private final FirebaseRemoteConfigClient remoteConfigClient;

    @VisibleForTesting
    FirebaseRemoteConfig(FirebaseApp app, FirebaseRemoteConfigClient client) {
        this.app = (FirebaseApp)Preconditions.checkNotNull((Object)app);
        this.remoteConfigClient = (FirebaseRemoteConfigClient)Preconditions.checkNotNull((Object)client);
    }

    private FirebaseRemoteConfig(FirebaseApp app) {
        this(app, FirebaseRemoteConfigClientImpl.fromApp(app));
    }

    public static FirebaseRemoteConfig getInstance() {
        return FirebaseRemoteConfig.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseRemoteConfig getInstance(FirebaseApp app) {
        FirebaseRemoteConfigService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseRemoteConfigService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseRemoteConfigService(app));
        }
        return (FirebaseRemoteConfig)service.getInstance();
    }

    public Template getTemplate() throws FirebaseRemoteConfigException {
        return this.getTemplateOp().call();
    }

    public ApiFuture<Template> getTemplateAsync() {
        return this.getTemplateOp().callAsync(this.app);
    }

    private CallableOperation<Template, FirebaseRemoteConfigException> getTemplateOp() {
        final FirebaseRemoteConfigClient remoteConfigClient = this.getRemoteConfigClient();
        return new CallableOperation<Template, FirebaseRemoteConfigException>(){

            @Override
            protected Template execute() throws FirebaseRemoteConfigException {
                return remoteConfigClient.getTemplate();
            }
        };
    }

    public Template getTemplateAtVersion(@NonNull String versionNumber) throws FirebaseRemoteConfigException {
        return this.getTemplateAtVersionOp(versionNumber).call();
    }

    public Template getTemplateAtVersion(long versionNumber) throws FirebaseRemoteConfigException {
        String versionNumberString = String.valueOf(versionNumber);
        return this.getTemplateAtVersionOp(versionNumberString).call();
    }

    public ApiFuture<Template> getTemplateAtVersionAsync(@NonNull String versionNumber) {
        return this.getTemplateAtVersionOp(versionNumber).callAsync(this.app);
    }

    public ApiFuture<Template> getTemplateAtVersionAsync(long versionNumber) {
        String versionNumberString = String.valueOf(versionNumber);
        return this.getTemplateAtVersionOp(versionNumberString).callAsync(this.app);
    }

    private CallableOperation<Template, FirebaseRemoteConfigException> getTemplateAtVersionOp(final String versionNumber) {
        final FirebaseRemoteConfigClient remoteConfigClient = this.getRemoteConfigClient();
        return new CallableOperation<Template, FirebaseRemoteConfigException>(){

            @Override
            protected Template execute() throws FirebaseRemoteConfigException {
                return remoteConfigClient.getTemplateAtVersion(versionNumber);
            }
        };
    }

    public Template publishTemplate(@NonNull Template template) throws FirebaseRemoteConfigException {
        return this.publishTemplateOp(template).call();
    }

    public ApiFuture<Template> publishTemplateAsync(@NonNull Template template) {
        return this.publishTemplateOp(template).callAsync(this.app);
    }

    public Template validateTemplate(@NonNull Template template) throws FirebaseRemoteConfigException {
        return this.publishTemplateOp(template, new PublishOptions().setValidateOnly(true)).call();
    }

    public ApiFuture<Template> validateTemplateAsync(@NonNull Template template) {
        return this.publishTemplateOp(template, new PublishOptions().setValidateOnly(true)).callAsync(this.app);
    }

    public Template forcePublishTemplate(@NonNull Template template) throws FirebaseRemoteConfigException {
        return this.publishTemplateOp(template, new PublishOptions().setForcePublish(true)).call();
    }

    public ApiFuture<Template> forcePublishTemplateAsync(@NonNull Template template) {
        return this.publishTemplateOp(template, new PublishOptions().setForcePublish(true)).callAsync(this.app);
    }

    private CallableOperation<Template, FirebaseRemoteConfigException> publishTemplateOp(Template template) {
        return this.publishTemplateOp(template, new PublishOptions());
    }

    private CallableOperation<Template, FirebaseRemoteConfigException> publishTemplateOp(final Template template, final PublishOptions options) {
        final FirebaseRemoteConfigClient remoteConfigClient = this.getRemoteConfigClient();
        return new CallableOperation<Template, FirebaseRemoteConfigException>(){

            @Override
            protected Template execute() throws FirebaseRemoteConfigException {
                return remoteConfigClient.publishTemplate(template, options.isValidateOnly(), options.isForcePublish());
            }
        };
    }

    public Template rollback(long versionNumber) throws FirebaseRemoteConfigException {
        String versionNumberString = String.valueOf(versionNumber);
        return this.rollbackOp(versionNumberString).call();
    }

    public Template rollback(@NonNull String versionNumber) throws FirebaseRemoteConfigException {
        return this.rollbackOp(versionNumber).call();
    }

    public ApiFuture<Template> rollbackAsync(long versionNumber) {
        String versionNumberString = String.valueOf(versionNumber);
        return this.rollbackOp(versionNumberString).callAsync(this.app);
    }

    public ApiFuture<Template> rollbackAsync(@NonNull String versionNumber) {
        String versionNumberString = String.valueOf(versionNumber);
        return this.rollbackOp(versionNumberString).callAsync(this.app);
    }

    private CallableOperation<Template, FirebaseRemoteConfigException> rollbackOp(final String versionNumber) {
        final FirebaseRemoteConfigClient remoteConfigClient = this.getRemoteConfigClient();
        return new CallableOperation<Template, FirebaseRemoteConfigException>(){

            @Override
            protected Template execute() throws FirebaseRemoteConfigException {
                return remoteConfigClient.rollback(versionNumber);
            }
        };
    }

    public ListVersionsPage listVersions() throws FirebaseRemoteConfigException {
        return this.listVersionsOp().call();
    }

    public ListVersionsPage listVersions(@NonNull ListVersionsOptions options) throws FirebaseRemoteConfigException {
        return this.listVersionsOp(options).call();
    }

    public ApiFuture<ListVersionsPage> listVersionsAsync() {
        return this.listVersionsOp().callAsync(this.app);
    }

    public ApiFuture<ListVersionsPage> listVersionsAsync(@NonNull ListVersionsOptions options) {
        return this.listVersionsOp(options).callAsync(this.app);
    }

    private CallableOperation<ListVersionsPage, FirebaseRemoteConfigException> listVersionsOp() {
        return this.listVersionsOp(null);
    }

    private CallableOperation<ListVersionsPage, FirebaseRemoteConfigException> listVersionsOp(ListVersionsOptions options) {
        FirebaseRemoteConfigClient remoteConfigClient = this.getRemoteConfigClient();
        ListVersionsPage.DefaultVersionSource source = new ListVersionsPage.DefaultVersionSource(remoteConfigClient);
        final ListVersionsPage.Factory factory = new ListVersionsPage.Factory(source, options);
        return new CallableOperation<ListVersionsPage, FirebaseRemoteConfigException>(){

            @Override
            protected ListVersionsPage execute() throws FirebaseRemoteConfigException {
                return factory.create();
            }
        };
    }

    @VisibleForTesting
    FirebaseRemoteConfigClient getRemoteConfigClient() {
        return this.remoteConfigClient;
    }

    private static class FirebaseRemoteConfigService
    extends FirebaseService<FirebaseRemoteConfig> {
        FirebaseRemoteConfigService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseRemoteConfig(app));
        }

        @Override
        public void destroy() {
        }
    }
}

