/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.Key;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.Nullable;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.TopicManagementResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class InstanceIdClient {
    private static final String IID_HOST = "https://iid.googleapis.com";
    private static final String IID_SUBSCRIBE_PATH = "iid/v1:batchAdd";
    private static final String IID_UNSUBSCRIBE_PATH = "iid/v1:batchRemove";
    static final Map<Integer, String> IID_ERROR_CODES = ImmutableMap.builder().put((Object)400, (Object)"invalid-argument").put((Object)401, (Object)"authentication-error").put((Object)403, (Object)"authentication-error").put((Object)500, (Object)"internal-error").put((Object)503, (Object)"server-unavailable").build();
    private final HttpRequestFactory requestFactory;
    private final JsonFactory jsonFactory;
    private final HttpResponseInterceptor responseInterceptor;

    InstanceIdClient(FirebaseApp app, @Nullable HttpResponseInterceptor responseInterceptor) {
        this.requestFactory = ApiClientUtils.newAuthorizedRequestFactory(app);
        this.jsonFactory = app.getOptions().getJsonFactory();
        this.responseInterceptor = responseInterceptor;
    }

    TopicManagementResponse subscribeToTopic(String topic, List<String> registrationTokens) throws FirebaseMessagingException {
        try {
            return this.sendInstanceIdRequest(topic, registrationTokens, IID_SUBSCRIBE_PATH);
        }
        catch (HttpResponseException e) {
            throw this.createExceptionFromResponse(e);
        }
        catch (IOException e) {
            throw new FirebaseMessagingException("internal-error", "Error while calling IID backend service", e);
        }
    }

    TopicManagementResponse unsubscribeFromTopic(String topic, List<String> registrationTokens) throws FirebaseMessagingException {
        try {
            return this.sendInstanceIdRequest(topic, registrationTokens, IID_UNSUBSCRIBE_PATH);
        }
        catch (HttpResponseException e) {
            throw this.createExceptionFromResponse(e);
        }
        catch (IOException e) {
            throw new FirebaseMessagingException("internal-error", "Error while calling IID backend service", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopicManagementResponse sendInstanceIdRequest(String topic, List<String> registrationTokens, String path) throws IOException {
        TopicManagementResponse topicManagementResponse;
        String url = String.format("%s/%s", IID_HOST, path);
        ImmutableMap payload = ImmutableMap.of((Object)"to", (Object)this.getPrefixedTopic(topic), (Object)"registration_tokens", registrationTokens);
        HttpResponse response = null;
        try {
            HttpRequest request = this.requestFactory.buildPostRequest(new GenericUrl(url), (HttpContent)new JsonHttpContent(this.jsonFactory, (Object)payload));
            request.getHeaders().set("access_token_auth", (Object)"true");
            request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
            request.setResponseInterceptor(this.responseInterceptor);
            response = request.execute();
            JsonParser parser = this.jsonFactory.createJsonParser(response.getContent());
            InstanceIdServiceResponse parsedResponse = new InstanceIdServiceResponse();
            parser.parse((Object)parsedResponse);
            topicManagementResponse = new TopicManagementResponse(parsedResponse.results);
        }
        catch (Throwable throwable) {
            ApiClientUtils.disconnectQuietly(response);
            throw throwable;
        }
        ApiClientUtils.disconnectQuietly(response);
        return topicManagementResponse;
    }

    private FirebaseMessagingException createExceptionFromResponse(HttpResponseException e) {
        InstanceIdServiceErrorResponse response = new InstanceIdServiceErrorResponse();
        if (e.getContent() != null) {
            try {
                JsonParser parser = this.jsonFactory.createJsonParser(e.getContent());
                parser.parseAndClose((Object)response);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return InstanceIdClient.newException(response, e);
    }

    private String getPrefixedTopic(String topic) {
        if (topic.startsWith("/topics/")) {
            return topic;
        }
        return "/topics/" + topic;
    }

    private static FirebaseMessagingException newException(InstanceIdServiceErrorResponse response, HttpResponseException e) {
        String msg;
        String code = IID_ERROR_CODES.get(e.getStatusCode());
        if (code == null) {
            code = "unknown-error";
        }
        if (Strings.isNullOrEmpty((String)(msg = response.error))) {
            msg = String.format("Unexpected HTTP response with status: %d; body: %s", e.getStatusCode(), e.getContent());
        }
        return new FirebaseMessagingException(code, msg, e);
    }

    private static class InstanceIdServiceErrorResponse {
        @Key(value="error")
        private String error;

        private InstanceIdServiceErrorResponse() {
        }
    }

    private static class InstanceIdServiceResponse {
        @Key(value="results")
        private List<GenericJson> results;

        private InstanceIdServiceResponse() {
        }
    }
}

