/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.messaging;

import com.google.api.client.googleapis.batch.BatchCallback;
import com.google.api.client.googleapis.batch.BatchRequest;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.ApiClientUtils;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.SdkUtils;
import com.google.firebase.messaging.BatchResponse;
import com.google.firebase.messaging.FirebaseMessagingException;
import com.google.firebase.messaging.Message;
import com.google.firebase.messaging.SendResponse;
import com.google.firebase.messaging.internal.MessagingServiceErrorResponse;
import com.google.firebase.messaging.internal.MessagingServiceResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

final class FirebaseMessagingClient {
    private static final String FCM_URL = "https://fcm.googleapis.com/v1/projects/%s/messages:send";
    private static final String FCM_BATCH_URL = "https://fcm.googleapis.com/batch";
    private static final Map<String, String> FCM_ERROR_CODES = ImmutableMap.builder().put((Object)"NOT_FOUND", (Object)"registration-token-not-registered").put((Object)"PERMISSION_DENIED", (Object)"mismatched-credential").put((Object)"RESOURCE_EXHAUSTED", (Object)"message-rate-exceeded").put((Object)"UNAUTHENTICATED", (Object)"invalid-apns-credentials").put((Object)"APNS_AUTH_ERROR", (Object)"invalid-apns-credentials").put((Object)"INTERNAL", (Object)"internal-error").put((Object)"INVALID_ARGUMENT", (Object)"invalid-argument").put((Object)"QUOTA_EXCEEDED", (Object)"message-rate-exceeded").put((Object)"SENDER_ID_MISMATCH", (Object)"mismatched-credential").put((Object)"UNAVAILABLE", (Object)"server-unavailable").put((Object)"UNREGISTERED", (Object)"registration-token-not-registered").build();
    private final String fcmSendUrl;
    private final HttpRequestFactory requestFactory;
    private final HttpRequestFactory childRequestFactory;
    private final JsonFactory jsonFactory;
    private final HttpResponseInterceptor responseInterceptor;
    private final String clientVersion = "Java/Admin/" + SdkUtils.getVersion();

    FirebaseMessagingClient(FirebaseApp app, @Nullable HttpResponseInterceptor responseInterceptor) {
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access messaging service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        this.fcmSendUrl = String.format(FCM_URL, projectId);
        this.requestFactory = ApiClientUtils.newAuthorizedRequestFactory(app);
        this.childRequestFactory = ApiClientUtils.newUnauthorizedRequestFactory(app);
        this.jsonFactory = app.getOptions().getJsonFactory();
        this.responseInterceptor = responseInterceptor;
    }

    String send(Message message, boolean dryRun) throws FirebaseMessagingException {
        try {
            return this.sendSingleRequest(message, dryRun);
        }
        catch (HttpResponseException e) {
            throw this.createExceptionFromResponse(e);
        }
        catch (IOException e) {
            throw new FirebaseMessagingException("internal-error", "Error while calling FCM backend service", e);
        }
    }

    BatchResponse sendAll(List<Message> messages, boolean dryRun) throws FirebaseMessagingException {
        try {
            return this.sendBatchRequest(messages, dryRun);
        }
        catch (HttpResponseException e) {
            throw this.createExceptionFromResponse(e);
        }
        catch (IOException e) {
            throw new FirebaseMessagingException("internal-error", "Error while calling FCM backend service", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String sendSingleRequest(Message message, boolean dryRun) throws IOException {
        HttpRequest request = this.requestFactory.buildPostRequest(new GenericUrl(this.fcmSendUrl), (HttpContent)new JsonHttpContent(this.jsonFactory, message.wrapForTransport(dryRun)));
        this.setCommonFcmHeaders(request.getHeaders());
        request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
        request.setResponseInterceptor(this.responseInterceptor);
        HttpResponse response = request.execute();
        try {
            MessagingServiceResponse parsed = new MessagingServiceResponse();
            this.jsonFactory.createJsonParser(response.getContent()).parseAndClose((Object)parsed);
            String string = parsed.getMessageId();
            return string;
        }
        finally {
            ApiClientUtils.disconnectQuietly(response);
        }
    }

    private BatchResponse sendBatchRequest(List<Message> messages, boolean dryRun) throws IOException {
        MessagingBatchCallback callback = new MessagingBatchCallback();
        BatchRequest batch = this.newBatchRequest(messages, dryRun, callback);
        batch.execute();
        return new BatchResponse(callback.getResponses());
    }

    private BatchRequest newBatchRequest(List<Message> messages, boolean dryRun, MessagingBatchCallback callback) throws IOException {
        BatchRequest batch = new BatchRequest(this.requestFactory.getTransport(), this.getBatchRequestInitializer());
        batch.setBatchUrl(new GenericUrl(FCM_BATCH_URL));
        JsonObjectParser jsonParser = new JsonObjectParser(this.jsonFactory);
        GenericUrl sendUrl = new GenericUrl(this.fcmSendUrl);
        for (Message message : messages) {
            HttpRequest request = this.childRequestFactory.buildPostRequest(sendUrl, (HttpContent)new JsonHttpContent(this.jsonFactory, message.wrapForTransport(dryRun)));
            request.setParser((ObjectParser)jsonParser);
            this.setCommonFcmHeaders(request.getHeaders());
            batch.queue(request, MessagingServiceResponse.class, MessagingServiceErrorResponse.class, (BatchCallback)callback);
        }
        return batch;
    }

    private void setCommonFcmHeaders(HttpHeaders headers) {
        headers.set("X-GOOG-API-FORMAT-VERSION", (Object)"2");
        headers.set("X-Client-Version", (Object)this.clientVersion);
    }

    private FirebaseMessagingException createExceptionFromResponse(HttpResponseException e) {
        MessagingServiceErrorResponse response = new MessagingServiceErrorResponse();
        if (e.getContent() != null) {
            try {
                JsonParser parser = this.jsonFactory.createJsonParser(e.getContent());
                parser.parseAndClose((Object)response);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FirebaseMessagingClient.newException(response, e);
    }

    private HttpRequestInitializer getBatchRequestInitializer() {
        return new HttpRequestInitializer(){

            public void initialize(HttpRequest request) throws IOException {
                FirebaseMessagingClient.this.requestFactory.getInitializer().initialize(request);
                request.setResponseInterceptor(FirebaseMessagingClient.this.responseInterceptor);
            }
        };
    }

    private static FirebaseMessagingException newException(MessagingServiceErrorResponse response) {
        return FirebaseMessagingClient.newException(response, null);
    }

    private static FirebaseMessagingException newException(MessagingServiceErrorResponse response, @Nullable HttpResponseException e) {
        String msg;
        String code = FCM_ERROR_CODES.get(response.getErrorCode());
        if (code == null) {
            code = "unknown-error";
        }
        if (Strings.isNullOrEmpty((String)(msg = response.getErrorMessage()))) {
            msg = e != null ? String.format("Unexpected HTTP response with status: %d; body: %s", e.getStatusCode(), e.getContent()) : String.format("Unexpected HTTP response: %s", response.toString());
        }
        return new FirebaseMessagingException(code, msg, e);
    }

    private static class MessagingBatchCallback
    implements BatchCallback<MessagingServiceResponse, MessagingServiceErrorResponse> {
        private final ImmutableList.Builder<SendResponse> responses = ImmutableList.builder();

        private MessagingBatchCallback() {
        }

        public void onSuccess(MessagingServiceResponse response, HttpHeaders responseHeaders) {
            this.responses.add((Object)SendResponse.fromMessageId(response.getMessageId()));
        }

        public void onFailure(MessagingServiceErrorResponse error, HttpHeaders responseHeaders) {
            this.responses.add((Object)SendResponse.fromException(FirebaseMessagingClient.newException(error)));
        }

        List<SendResponse> getResponses() {
            return this.responses.build();
        }
    }
}

