/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.multitenancy;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.FirebaseApp;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.internal.AuthHttpClient;
import com.google.firebase.auth.internal.ListTenantsResponse;
import com.google.firebase.auth.multitenancy.Tenant;
import com.google.firebase.internal.ApiClientUtils;
import java.util.Map;

final class FirebaseTenantClient {
    static final int MAX_LIST_TENANTS_RESULTS = 100;
    private static final String ID_TOOLKIT_URL = "https://identitytoolkit.googleapis.com/%s/projects/%s";
    private final String tenantMgtBaseUrl;
    private final AuthHttpClient httpClient;

    FirebaseTenantClient(FirebaseApp app) {
        Preconditions.checkNotNull((Object)app, (Object)"FirebaseApp must not be null");
        String projectId = ImplFirebaseTrampolines.getProjectId(app);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Project ID is required to access the auth service. Use a service account credential or set the project ID explicitly via FirebaseOptions. Alternatively you can also set the project ID via the GOOGLE_CLOUD_PROJECT environment variable.");
        this.tenantMgtBaseUrl = String.format(ID_TOOLKIT_URL, "v2", projectId);
        JsonFactory jsonFactory = app.getOptions().getJsonFactory();
        HttpRequestFactory requestFactory = ApiClientUtils.newAuthorizedRequestFactory(app);
        this.httpClient = new AuthHttpClient(jsonFactory, requestFactory);
    }

    void setInterceptor(HttpResponseInterceptor interceptor) {
        this.httpClient.setInterceptor(interceptor);
    }

    Tenant getTenant(String tenantId) throws FirebaseAuthException {
        GenericUrl url = new GenericUrl(this.tenantMgtBaseUrl + FirebaseTenantClient.getTenantUrlSuffix(tenantId));
        return this.httpClient.sendRequest("GET", url, null, Tenant.class);
    }

    Tenant createTenant(Tenant.CreateRequest request) throws FirebaseAuthException {
        GenericUrl url = new GenericUrl(this.tenantMgtBaseUrl + "/tenants");
        return this.httpClient.sendRequest("POST", url, request.getProperties(), Tenant.class);
    }

    Tenant updateTenant(Tenant.UpdateRequest request) throws FirebaseAuthException {
        Map<String, Object> properties = request.getProperties();
        GenericUrl url = new GenericUrl(this.tenantMgtBaseUrl + FirebaseTenantClient.getTenantUrlSuffix(request.getTenantId()));
        url.put("updateMask", (Object)Joiner.on((String)",").join(AuthHttpClient.generateMask(properties)));
        return this.httpClient.sendRequest("PATCH", url, properties, Tenant.class);
    }

    void deleteTenant(String tenantId) throws FirebaseAuthException {
        GenericUrl url = new GenericUrl(this.tenantMgtBaseUrl + FirebaseTenantClient.getTenantUrlSuffix(tenantId));
        this.httpClient.sendRequest("DELETE", url, null, GenericJson.class);
    }

    ListTenantsResponse listTenants(int maxResults, String pageToken) throws FirebaseAuthException {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"pageSize", (Object)maxResults);
        if (pageToken != null) {
            Preconditions.checkArgument((!pageToken.equals("") ? 1 : 0) != 0, (Object)"Invalid end of list page token.");
            builder.put((Object)"pageToken", (Object)pageToken);
        }
        GenericUrl url = new GenericUrl(this.tenantMgtBaseUrl + "/tenants");
        url.putAll((Map)builder.build());
        ListTenantsResponse response = this.httpClient.sendRequest("GET", url, null, ListTenantsResponse.class);
        if (response == null) {
            throw new FirebaseAuthException("internal-error", "Failed to retrieve tenants.");
        }
        return response;
    }

    private static String getTenantUrlSuffix(String tenantId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)tenantId) ? 1 : 0) != 0, (Object)"Tenant ID must not be null or empty.");
        return "/tenants/" + tenantId;
    }
}

