/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpResponseInterceptor;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.internal.HttpErrorResponse;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.SdkUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public final class AuthHttpClient {
    public static final String CONFIGURATION_NOT_FOUND_ERROR = "configuration-not-found";
    public static final String INTERNAL_ERROR = "internal-error";
    public static final String TENANT_NOT_FOUND_ERROR = "tenant-not-found";
    public static final String USER_NOT_FOUND_ERROR = "user-not-found";
    private static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    private static final String CLIENT_VERSION = "Java/Admin/" + SdkUtils.getVersion();
    private static final Map<String, String> ERROR_CODES = ImmutableMap.builder().put((Object)"CLAIMS_TOO_LARGE", (Object)"claims-too-large").put((Object)"CONFIGURATION_NOT_FOUND", (Object)"configuration-not-found").put((Object)"INSUFFICIENT_PERMISSION", (Object)"insufficient-permission").put((Object)"DUPLICATE_EMAIL", (Object)"email-already-exists").put((Object)"DUPLICATE_LOCAL_ID", (Object)"uid-already-exists").put((Object)"EMAIL_EXISTS", (Object)"email-already-exists").put((Object)"INVALID_CLAIMS", (Object)"invalid-claims").put((Object)"INVALID_EMAIL", (Object)"invalid-email").put((Object)"INVALID_PAGE_SELECTION", (Object)"invalid-page-token").put((Object)"INVALID_PHONE_NUMBER", (Object)"invalid-phone-number").put((Object)"PHONE_NUMBER_EXISTS", (Object)"phone-number-already-exists").put((Object)"PROJECT_NOT_FOUND", (Object)"project-not-found").put((Object)"USER_NOT_FOUND", (Object)"user-not-found").put((Object)"WEAK_PASSWORD", (Object)"invalid-password").put((Object)"UNAUTHORIZED_DOMAIN", (Object)"unauthorized-continue-uri").put((Object)"INVALID_DYNAMIC_LINK_DOMAIN", (Object)"invalid-dynamic-link-domain").put((Object)"TENANT_NOT_FOUND", (Object)"tenant-not-found").build();
    private final JsonFactory jsonFactory;
    private final HttpRequestFactory requestFactory;
    private HttpResponseInterceptor interceptor;

    public AuthHttpClient(JsonFactory jsonFactory, HttpRequestFactory requestFactory) {
        this.jsonFactory = jsonFactory;
        this.requestFactory = requestFactory;
    }

    public static Set<String> generateMask(Map<String, Object> properties) {
        ImmutableSortedSet.Builder maskBuilder = ImmutableSortedSet.naturalOrder();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (entry.getValue() instanceof Map) {
                Set<String> childMask = AuthHttpClient.generateMask((Map)entry.getValue());
                for (String childProperty : childMask) {
                    maskBuilder.add((Object)(entry.getKey() + "." + childProperty));
                }
                continue;
            }
            maskBuilder.add((Object)entry.getKey());
        }
        return maskBuilder.build();
    }

    public void setInterceptor(HttpResponseInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    public <T> T sendRequest(String method, GenericUrl url, @Nullable Object content, Class<T> clazz) throws FirebaseAuthException {
        Object object;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)method) ? 1 : 0) != 0, (Object)"method must not be null or empty");
        Preconditions.checkNotNull((Object)url, (Object)"url must not be null");
        Preconditions.checkNotNull(clazz, (Object)"response class must not be null");
        HttpResponse response = null;
        try {
            JsonHttpContent httpContent = content != null ? new JsonHttpContent(this.jsonFactory, content) : null;
            HttpRequest request = this.requestFactory.buildRequest(method.equals("PATCH") ? "POST" : method, url, (HttpContent)httpContent);
            request.setParser((ObjectParser)new JsonObjectParser(this.jsonFactory));
            request.getHeaders().set(CLIENT_VERSION_HEADER, (Object)CLIENT_VERSION);
            if (method.equals("PATCH")) {
                request.getHeaders().set("X-HTTP-Method-Override", (Object)"PATCH");
            }
            request.setResponseInterceptor(this.interceptor);
            response = request.execute();
            object = response.parseAs(clazz);
        }
        catch (HttpResponseException e) {
            this.handleHttpError(e);
            T t = null;
            return t;
        }
        catch (IOException e) {
            throw new FirebaseAuthException(INTERNAL_ERROR, "Error while calling the Firebase Auth backend service", e);
        }
        finally {
            if (response != null) {
                try {
                    response.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return (T)object;
    }

    private void handleHttpError(HttpResponseException e) throws FirebaseAuthException {
        try {
            HttpErrorResponse response = (HttpErrorResponse)this.jsonFactory.fromString(e.getContent(), HttpErrorResponse.class);
            String code = ERROR_CODES.get(response.getErrorCode());
            if (code != null) {
                throw new FirebaseAuthException(code, "Firebase Auth service responded with an error", e);
            }
        }
        catch (IOException response) {
            // empty catch block
        }
        String msg = String.format("Unexpected HTTP response with status: %d; body: %s", e.getStatusCode(), e.getContent());
        throw new FirebaseAuthException(INTERNAL_ERROR, msg, e);
    }
}

