/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.auth.FirebaseUserManager;
import com.google.firebase.auth.ProviderUserInfo;
import com.google.firebase.auth.UserInfo;
import com.google.firebase.auth.UserMetadata;
import com.google.firebase.auth.internal.GetAccountInfoResponse;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UserRecord
implements UserInfo {
    private static final String PROVIDER_ID = "firebase";
    private static final Map<String, String> REMOVABLE_FIELDS = ImmutableMap.of((Object)"displayName", (Object)"DISPLAY_NAME", (Object)"photoUrl", (Object)"PHOTO_URL");
    private static final String CUSTOM_ATTRIBUTES = "customAttributes";
    private static final int MAX_CLAIMS_PAYLOAD_SIZE = 1000;
    private final String uid;
    private final String email;
    private final String phoneNumber;
    private final boolean emailVerified;
    private final String displayName;
    private final String photoUrl;
    private final boolean disabled;
    private final ProviderUserInfo[] providers;
    private final long tokensValidAfterTimestamp;
    private final UserMetadata userMetadata;
    private final Map<String, Object> customClaims;

    UserRecord(GetAccountInfoResponse.User response, JsonFactory jsonFactory) {
        Preconditions.checkNotNull((Object)response, (Object)"response must not be null");
        Preconditions.checkNotNull((Object)jsonFactory, (Object)"jsonFactory must not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)response.getUid()) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
        this.uid = response.getUid();
        this.email = response.getEmail();
        this.phoneNumber = response.getPhoneNumber();
        this.emailVerified = response.isEmailVerified();
        this.displayName = response.getDisplayName();
        this.photoUrl = response.getPhotoUrl();
        this.disabled = response.isDisabled();
        if (response.getProviders() == null || response.getProviders().length == 0) {
            this.providers = new ProviderUserInfo[0];
        } else {
            this.providers = new ProviderUserInfo[response.getProviders().length];
            for (int i = 0; i < this.providers.length; ++i) {
                this.providers[i] = new ProviderUserInfo(response.getProviders()[i]);
            }
        }
        this.tokensValidAfterTimestamp = response.getValidSince() * 1000L;
        this.userMetadata = new UserMetadata(response.getCreatedAt(), response.getLastLoginAt());
        this.customClaims = this.parseCustomClaims(response.getCustomClaims(), jsonFactory);
    }

    private Map<String, Object> parseCustomClaims(String customClaims, JsonFactory jsonFactory) {
        if (Strings.isNullOrEmpty((String)customClaims)) {
            return ImmutableMap.of();
        }
        try {
            HashMap parsed = new HashMap();
            jsonFactory.createJsonParser(customClaims).parseAndClose(parsed);
            return ImmutableMap.copyOf(parsed);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse custom claims json", e);
        }
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public String getProviderId() {
        return PROVIDER_ID;
    }

    @Override
    @Nullable
    public String getEmail() {
        return this.email;
    }

    @Override
    @Nullable
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public boolean isEmailVerified() {
        return this.emailVerified;
    }

    @Override
    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Nullable
    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public UserInfo[] getProviderData() {
        return this.providers;
    }

    public long getTokensValidAfterTimestamp() {
        return this.tokensValidAfterTimestamp;
    }

    public UserMetadata getUserMetadata() {
        return this.userMetadata;
    }

    @NonNull
    public Map<String, Object> getCustomClaims() {
        return this.customClaims;
    }

    public UpdateRequest updateRequest() {
        return new UpdateRequest(this.uid);
    }

    private static void checkEmail(String email) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)email) ? 1 : 0) != 0, (Object)"email cannot be null or empty");
        Preconditions.checkArgument((boolean)email.matches("^[^@]+@[^@]+$"));
    }

    private static void checkPhoneNumber(String phoneNumber) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)phoneNumber) ? 1 : 0) != 0, (Object)"phone number cannot be null or empty");
        Preconditions.checkState((boolean)phoneNumber.startsWith("+"), (Object)"phone number must be a valid, E.164 compliant identifier starting with a '+' sign");
    }

    private static void checkPassword(String password) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)password) ? 1 : 0) != 0, (Object)"password cannot be null or empty");
        Preconditions.checkArgument((password.length() >= 6 ? 1 : 0) != 0, (Object)"password must be at least 6 characters long");
    }

    private static void checkCustomClaims(Map<String, Object> customClaims) {
        if (customClaims == null) {
            return;
        }
        for (String key : customClaims.keySet()) {
            Preconditions.checkArgument((!FirebaseUserManager.RESERVED_CLAIMS.contains(key) ? 1 : 0) != 0, (Object)("Claim '" + key + "' is reserved and cannot be set"));
        }
    }

    private static void checkValidSince(long epochSeconds) {
        Preconditions.checkArgument((epochSeconds > 0L ? 1 : 0) != 0, (Object)("validSince (seconds since epoch) must be greater than 0: " + Long.toString(epochSeconds)));
    }

    private static String serializeCustomClaims(Map customClaims, JsonFactory jsonFactory) {
        Preconditions.checkNotNull((Object)jsonFactory, (Object)"JsonFactory must not be null");
        if (customClaims == null || customClaims.isEmpty()) {
            return "{}";
        }
        try {
            String claimsPayload = jsonFactory.toString((Object)customClaims);
            Preconditions.checkArgument((claimsPayload.length() <= 1000 ? 1 : 0) != 0, (Object)"customClaims payload cannot be larger than 1000 characters");
            return claimsPayload;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to serialize custom claims into JSON", e);
        }
    }

    public static class UpdateRequest {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public UpdateRequest(String uid) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid must not be null or empty");
            this.properties.put("localId", uid);
        }

        String getUid() {
            return (String)this.properties.get("localId");
        }

        public UpdateRequest setEmail(String email) {
            UserRecord.checkEmail(email);
            this.properties.put("email", email);
            return this;
        }

        public UpdateRequest setPhoneNumber(@Nullable String phone) {
            if (phone != null) {
                UserRecord.checkPhoneNumber(phone);
            }
            this.properties.put("phoneNumber", phone);
            return this;
        }

        public UpdateRequest setEmailVerified(boolean emailVerified) {
            this.properties.put("emailVerified", emailVerified);
            return this;
        }

        public UpdateRequest setDisplayName(@Nullable String displayName) {
            this.properties.put("displayName", displayName);
            return this;
        }

        public UpdateRequest setPhotoUrl(@Nullable String photoUrl) {
            if (photoUrl != null) {
                try {
                    new URL(photoUrl);
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("malformed photoUrl string", e);
                }
            }
            this.properties.put("photoUrl", photoUrl);
            return this;
        }

        public UpdateRequest setDisabled(boolean disabled) {
            this.properties.put("disableUser", disabled);
            return this;
        }

        public UpdateRequest setPassword(String password) {
            UserRecord.checkPassword(password);
            this.properties.put("password", password);
            return this;
        }

        public UpdateRequest setCustomClaims(Map<String, Object> customClaims) {
            UserRecord.checkCustomClaims(customClaims);
            this.properties.put(UserRecord.CUSTOM_ATTRIBUTES, customClaims);
            return this;
        }

        UpdateRequest setValidSince(long epochSeconds) {
            UserRecord.checkValidSince(epochSeconds);
            this.properties.put("validSince", epochSeconds);
            return this;
        }

        Map<String, Object> getProperties(JsonFactory jsonFactory) {
            HashMap<String, Object> copy = new HashMap<String, Object>(this.properties);
            ArrayList remove = new ArrayList();
            for (Map.Entry entry : REMOVABLE_FIELDS.entrySet()) {
                if (!copy.containsKey(entry.getKey()) || copy.get(entry.getKey()) != null) continue;
                remove.add(entry.getValue());
                copy.remove(entry.getKey());
            }
            if (!remove.isEmpty()) {
                copy.put("deleteAttribute", ImmutableList.copyOf(remove));
            }
            if (copy.containsKey("phoneNumber") && copy.get("phoneNumber") == null) {
                copy.put("deleteProvider", ImmutableList.of((Object)"phone"));
                copy.remove("phoneNumber");
            }
            if (copy.containsKey(UserRecord.CUSTOM_ATTRIBUTES)) {
                Map customClaims = (Map)copy.remove(UserRecord.CUSTOM_ATTRIBUTES);
                copy.put(UserRecord.CUSTOM_ATTRIBUTES, UserRecord.serializeCustomClaims(customClaims, jsonFactory));
            }
            return ImmutableMap.copyOf(copy);
        }
    }

    public static class CreateRequest {
        private final Map<String, Object> properties = new HashMap<String, Object>();

        public CreateRequest setUid(String uid) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)uid) ? 1 : 0) != 0, (Object)"uid cannot be null or empty");
            Preconditions.checkArgument((uid.length() <= 128 ? 1 : 0) != 0, (Object)"UID cannot be longer than 128 characters");
            this.properties.put("localId", uid);
            return this;
        }

        public CreateRequest setEmail(String email) {
            UserRecord.checkEmail(email);
            this.properties.put("email", email);
            return this;
        }

        public CreateRequest setPhoneNumber(String phone) {
            UserRecord.checkPhoneNumber(phone);
            this.properties.put("phoneNumber", phone);
            return this;
        }

        public CreateRequest setEmailVerified(boolean emailVerified) {
            this.properties.put("emailVerified", emailVerified);
            return this;
        }

        public CreateRequest setDisplayName(String displayName) {
            Preconditions.checkNotNull((Object)displayName, (Object)"displayName cannot be null or empty");
            this.properties.put("displayName", displayName);
            return this;
        }

        public CreateRequest setPhotoUrl(String photoUrl) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)photoUrl) ? 1 : 0) != 0, (Object)"photoUrl cannot be null or empty");
            try {
                new URL(photoUrl);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("malformed photoUrl string", e);
            }
            this.properties.put("photoUrl", photoUrl);
            return this;
        }

        public CreateRequest setDisabled(boolean disabled) {
            this.properties.put("disabled", disabled);
            return this;
        }

        public CreateRequest setPassword(String password) {
            UserRecord.checkPassword(password);
            this.properties.put("password", password);
            return this;
        }

        Map<String, Object> getProperties() {
            return ImmutableMap.copyOf(this.properties);
        }
    }
}

