/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.firebase.internal.GaeThreadFactory;
import com.google.firebase.internal.RevivingScheduledExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

class GaeExecutorService
implements ExecutorService {
    private final AtomicReference<ExecutorWrapper> executor = new AtomicReference();
    private final String threadName;
    private boolean shutdown;

    GaeExecutorService(String threadName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)threadName) ? 1 : 0) != 0);
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService ensureExecutorService() {
        ExecutorWrapper wrapper = this.executor.get();
        if (wrapper == null) {
            AtomicReference<ExecutorWrapper> atomicReference = this.executor;
            synchronized (atomicReference) {
                Preconditions.checkState((!this.shutdown ? 1 : 0) != 0);
                wrapper = this.executor.get();
                if (wrapper == null) {
                    wrapper = new ExecutorWrapper(this.threadName);
                    this.executor.compareAndSet(null, wrapper);
                }
            }
        }
        return wrapper.getExecutorService();
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.ensureExecutorService().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.ensureExecutorService().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.ensureExecutorService().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.ensureExecutorService().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.ensureExecutorService().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.ensureExecutorService().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.ensureExecutorService().invokeAny(tasks, timeout, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        AtomicReference<ExecutorWrapper> atomicReference = this.executor;
        synchronized (atomicReference) {
            ExecutorWrapper wrapper = this.executor.get();
            if (wrapper != null && !this.shutdown) {
                wrapper.getExecutorService().shutdown();
            }
            this.shutdown = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        AtomicReference<ExecutorWrapper> atomicReference = this.executor;
        synchronized (atomicReference) {
            ExecutorWrapper wrapper = this.executor.get();
            Object result = wrapper != null && !this.shutdown ? wrapper.getExecutorService().shutdownNow() : ImmutableList.of();
            this.shutdown = true;
            return result;
        }
    }

    @Override
    public boolean isShutdown() {
        return this.ensureExecutorService().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.ensureExecutorService().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.ensureExecutorService().awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.ensureExecutorService().execute(command);
    }

    private static class ExecutorWrapper {
        private final ExecutorService executorService;

        ExecutorWrapper(String threadName) {
            GaeThreadFactory threadFactory = GaeThreadFactory.getInstance();
            this.executorService = threadFactory.isUsingBackgroundThreads() ? new RevivingScheduledExecutor(threadFactory, threadName, true) : new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }

        ExecutorService getExecutorService() {
            return this.executorService;
        }
    }
}

