/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.firebase.internal.GaeThreadFactory;
import com.google.firebase.internal.RevivingScheduledExecutor;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public class GaeScheduledExecutorService
implements ScheduledExecutorService {
    private final AtomicReference<ExecutorWrapper> executor = new AtomicReference();
    private final String threadName;

    GaeScheduledExecutorService(String threadName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)threadName) ? 1 : 0) != 0);
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorWrapper ensureExecutorWrapper() {
        ExecutorWrapper wrapper = this.executor.get();
        if (wrapper == null) {
            AtomicReference<ExecutorWrapper> atomicReference = this.executor;
            synchronized (atomicReference) {
                wrapper = this.executor.get();
                if (wrapper == null) {
                    wrapper = new ExecutorWrapper(this.threadName);
                    this.executor.compareAndSet(null, wrapper);
                }
            }
        }
        return wrapper;
    }

    private ExecutorService ensureExecutorService() {
        return this.ensureExecutorWrapper().getExecutorService();
    }

    private ScheduledExecutorService ensureScheduledExecutorService() {
        ScheduledExecutorService scheduledExecutorService = this.ensureExecutorWrapper().getScheduledExecutorService();
        if (scheduledExecutorService != null) {
            return scheduledExecutorService;
        }
        throw new UnsupportedOperationException("ScheduledExecutorService not available. A manually-scaled instance is required when running the Firebase Admin SDK on GAE.");
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.ensureScheduledExecutorService().schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.ensureScheduledExecutorService().schedule(callable, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.ensureScheduledExecutorService().scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.ensureScheduledExecutorService().scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.ensureExecutorService().submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.ensureExecutorService().submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.ensureExecutorService().submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.ensureExecutorService().invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.ensureExecutorService().invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.ensureExecutorService().invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.ensureExecutorService().invokeAny(tasks, timeout, unit);
    }

    @Override
    public void shutdown() {
        this.ensureExecutorService().shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.ensureExecutorService().shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.ensureExecutorService().isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.ensureExecutorService().isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.ensureExecutorService().awaitTermination(timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.ensureExecutorService().execute(command);
    }

    private static class ExecutorWrapper {
        private final ExecutorService executorService;
        private final ScheduledExecutorService scheduledExecutorService;

        ExecutorWrapper(String threadName) {
            GaeThreadFactory threadFactory = GaeThreadFactory.getInstance();
            if (threadFactory.isUsingBackgroundThreads()) {
                this.scheduledExecutorService = new RevivingScheduledExecutor(threadFactory, threadName, true);
                this.executorService = this.scheduledExecutorService;
            } else {
                this.scheduledExecutorService = null;
                this.executorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
            }
        }

        ExecutorService getExecutorService() {
            return this.executorService;
        }

        ScheduledExecutorService getScheduledExecutorService() {
            return this.scheduledExecutorService;
        }
    }
}

