/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.connection.util;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;

public class StringListReader
extends Reader {
    private List<String> strings = null;
    private boolean closed = false;
    private int charPos;
    private int stringListPos;
    private int markedCharPos = this.charPos;
    private int markedStringListPos = this.stringListPos;
    private boolean frozen = false;

    public StringListReader() {
        this.strings = new ArrayList<String>();
    }

    public void addString(String string) {
        if (this.frozen) {
            throw new IllegalStateException("Trying to add string after reading");
        }
        if (string.length() > 0) {
            this.strings.add(string);
        }
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Trying to freeze frozen StringListReader");
        }
        this.frozen = true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (String string : this.strings) {
            builder.append(string);
        }
        return builder.toString();
    }

    @Override
    public void reset() throws IOException {
        this.charPos = this.markedCharPos;
        this.stringListPos = this.markedStringListPos;
    }

    private String currentString() {
        return this.stringListPos < this.strings.size() ? this.strings.get(this.stringListPos) : null;
    }

    private int currentStringRemainingChars() {
        String current = this.currentString();
        return current == null ? 0 : current.length() - this.charPos;
    }

    private void checkState() throws IOException {
        if (this.closed) {
            throw new IOException("Stream already closed");
        }
        if (!this.frozen) {
            throw new IOException("Reader needs to be frozen before read operations can be called");
        }
    }

    private long advance(long numChars) {
        long advanced = 0L;
        while (this.stringListPos < this.strings.size() && advanced < numChars) {
            long remainingChars = numChars - advanced;
            int remainingStringChars = this.currentStringRemainingChars();
            if (remainingChars < (long)remainingStringChars) {
                this.charPos = (int)((long)this.charPos + remainingChars);
                advanced += remainingChars;
                continue;
            }
            advanced += (long)remainingStringChars;
            this.charPos = 0;
            ++this.stringListPos;
        }
        return advanced;
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        this.checkState();
        int remaining = target.remaining();
        int total = 0;
        String current = this.currentString();
        while (remaining > 0 && current != null) {
            int strLength = Math.min(current.length() - this.charPos, remaining);
            target.put(this.strings.get(this.stringListPos), this.charPos, this.charPos + strLength);
            remaining -= strLength;
            total += strLength;
            this.advance(strLength);
            current = this.currentString();
        }
        if (total > 0 || current != null) {
            return total;
        }
        return -1;
    }

    @Override
    public int read() throws IOException {
        this.checkState();
        String current = this.currentString();
        if (current == null) {
            return -1;
        }
        char c = current.charAt(this.charPos);
        this.advance(1L);
        return c;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int charsCopied;
        int copyLength;
        this.checkState();
        String current = this.currentString();
        for (charsCopied = 0; current != null && charsCopied < len; charsCopied += copyLength) {
            copyLength = Math.min(this.currentStringRemainingChars(), len - charsCopied);
            current.getChars(this.charPos, this.charPos + copyLength, cbuf, off + charsCopied);
            this.advance(copyLength);
            current = this.currentString();
        }
        if (charsCopied > 0 || current != null) {
            return charsCopied;
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkState();
        return this.advance(n);
    }

    @Override
    public boolean ready() throws IOException {
        this.checkState();
        return true;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.checkState();
        this.markedCharPos = this.charPos;
        this.markedStringListPos = this.stringListPos;
    }

    @Override
    public void close() throws IOException {
        this.checkState();
        this.closed = true;
    }
}

