/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.firebase.internal.GaeThreadFactory;
import com.google.firebase.internal.NonNull;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class TaskExecutors {
    public static final Executor DEFAULT_THREAD_POOL;
    static final Executor DIRECT;

    private TaskExecutors() {
    }

    static {
        DIRECT = new Executor(){

            @Override
            public void execute(@NonNull Runnable command) {
                command.run();
            }
        };
        if (GaeThreadFactory.isAvailable()) {
            DEFAULT_THREAD_POOL = GaeThreadFactory.DEFAULT_EXECUTOR;
        } else {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("task-exec-%d").setDaemon(true).build();
            DEFAULT_THREAD_POOL = Executors.newCachedThreadPool(threadFactory);
        }
    }
}

