/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth.internal;

import com.google.api.client.auth.openidconnect.IdToken;
import com.google.api.client.auth.openidconnect.IdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.util.ArrayMap;
import com.google.api.client.util.Clock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.firebase.auth.FirebaseAuthException;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;

public final class FirebaseTokenVerifier
extends IdTokenVerifier {
    @VisibleForTesting
    static final String CLIENT_CERT_URL = "https://www.googleapis.com/robot/v1/metadata/x509/securetoken@system.gserviceaccount.com";
    public static final GooglePublicKeysManager DEFAULT_KEY_MANAGER = new GooglePublicKeysManager.Builder((HttpTransport)new NetHttpTransport.Builder().build(), (JsonFactory)new GsonFactory()).setClock(Clock.SYSTEM).setPublicCertsEncodedUrl("https://www.googleapis.com/robot/v1/metadata/x509/securetoken@system.gserviceaccount.com").build();
    private static final String ISSUER_PREFIX = "https://securetoken.google.com/";
    private static final String FIREBASE_AUDIENCE = "https://identitytoolkit.googleapis.com/google.identity.identitytoolkit.v1.IdentityToolkit";
    private static final String ERROR_INVALID_CREDENTIAL = "ERROR_INVALID_CREDENTIAL";
    private static final String ERROR_RUNTIME_EXCEPTION = "ERROR_RUNTIME_EXCEPTION";
    private static final String PROJECT_ID_MATCH_MESSAGE = " Make sure the ID token comes from the same Firebase project as the service account used to authenticate this SDK.";
    private static final String VERIFY_ID_TOKEN_DOCS_MESSAGE = " See https://firebase.google.com/docs/auth/admin/verify-id-tokens for details on how to retrieve an ID token.";
    private static final String ALGORITHM = "RS256";
    private String projectId;
    private GooglePublicKeysManager publicKeysManager;

    protected FirebaseTokenVerifier(Builder builder) {
        super((IdTokenVerifier.Builder)builder);
        Preconditions.checkArgument((builder.projectId != null ? 1 : 0) != 0, (Object)"projectId must be set");
        this.projectId = builder.projectId;
        this.publicKeysManager = builder.publicKeysManager;
    }

    public boolean verifyTokenAndSignature(IdToken token) throws FirebaseAuthException {
        boolean isLegacyCustomToken;
        IdToken.Payload payload = token.getPayload();
        JsonWebSignature.Header header = token.getHeader();
        String errorMessage = null;
        boolean isCustomToken = payload.getAudience() != null && payload.getAudience().equals(FIREBASE_AUDIENCE);
        boolean bl = isLegacyCustomToken = header.getAlgorithm() != null && header.getAlgorithm().equals("HS256") && payload.get((Object)"v") != null && payload.get((Object)"v").equals(new BigDecimal(0)) && payload.get((Object)"d") != null && payload.get((Object)"d") instanceof ArrayMap && ((ArrayMap)payload.get((Object)"d")).get((Object)"uid") != null;
        if (header.getKeyId() == null) {
            errorMessage = isCustomToken ? "verifyIdToken() expects an ID token, but was given a custom token." : (isLegacyCustomToken ? "verifyIdToken() expects an ID token, but was given a legacy custom token." : "Firebase ID token has no \"kid\" claim.");
        } else if (header.getAlgorithm() == null || !header.getAlgorithm().equals(ALGORITHM)) {
            errorMessage = String.format("Firebase ID token has incorrect algorithm. Expected \"%s\" but got \"%s\".", ALGORITHM, header.getAlgorithm());
        } else if (!token.verifyAudience(this.getAudience())) {
            errorMessage = String.format("Firebase ID token has incorrect \"aud\" (audience) claim. Expected \"%s\" but got \"%s\".", this.concat(this.getAudience()), this.concat(token.getPayload().getAudienceAsList()));
            errorMessage = errorMessage + PROJECT_ID_MATCH_MESSAGE;
        } else if (!token.verifyIssuer(this.getIssuers())) {
            errorMessage = String.format("Firebase ID token has incorrect \"iss\" (issuer) claim. Expected \"%s\" but got \"%s\".", this.concat(this.getIssuers()), token.getPayload().getIssuer());
            errorMessage = errorMessage + PROJECT_ID_MATCH_MESSAGE;
        } else if (payload.getSubject() == null) {
            errorMessage = "Firebase ID token has no \"sub\" (subject) claim.";
        } else if (payload.getSubject().isEmpty()) {
            errorMessage = "Firebase ID token has an empty string \"sub\" (subject) claim.";
        } else if (payload.getSubject().length() > 128) {
            errorMessage = "Firebase ID token has \"sub\" (subject) claim longer than 128 characters.";
        } else if (!token.verifyTime(this.getClock().currentTimeMillis(), this.getAcceptableTimeSkewSeconds())) {
            errorMessage = "Firebase ID token has expired or is not yet valid. Get a fresh token from your client app and try again.";
        }
        if (errorMessage != null) {
            errorMessage = errorMessage + VERIFY_ID_TOKEN_DOCS_MESSAGE;
            throw new FirebaseAuthException(ERROR_INVALID_CREDENTIAL, errorMessage);
        }
        try {
            if (!this.verifySignature(token)) {
                throw new FirebaseAuthException(ERROR_INVALID_CREDENTIAL, "Firebase ID token isn't signed by a valid public key. See https://firebase.google.com/docs/auth/admin/verify-id-tokens for details on how to retrieve an ID token.");
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new FirebaseAuthException(ERROR_RUNTIME_EXCEPTION, "Error while verifying token signature.", e);
        }
        return true;
    }

    private String concat(Collection<String> collection) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String inputLine : collection) {
            stringBuilder.append(inputLine.trim()).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    private boolean verifySignature(IdToken token) throws GeneralSecurityException, IOException {
        for (PublicKey key : this.publicKeysManager.getPublicKeys()) {
            if (!token.verifySignature(key)) continue;
            return true;
        }
        return false;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public static GooglePublicKeysManager buildGooglePublicKeysManager(HttpTransport transport) {
        return new GooglePublicKeysManager.Builder(transport, (JsonFactory)new GsonFactory()).setClock(Clock.SYSTEM).setPublicCertsEncodedUrl(CLIENT_CERT_URL).build();
    }

    public static class Builder
    extends IdTokenVerifier.Builder {
        String projectId;
        GooglePublicKeysManager publicKeysManager = DEFAULT_KEY_MANAGER;

        public String getProjectId() {
            return this.projectId;
        }

        public Builder setProjectId(String projectId) {
            this.projectId = projectId;
            this.setIssuer(FirebaseTokenVerifier.ISSUER_PREFIX + projectId);
            this.setAudience(Collections.singleton(projectId));
            return this;
        }

        public Builder setClock(Clock clock) {
            return (Builder)super.setClock(clock);
        }

        public GooglePublicKeysManager getPublicKeyManager() {
            return this.publicKeysManager;
        }

        public Builder setPublicKeysManager(GooglePublicKeysManager publicKeysManager) {
            this.publicKeysManager = publicKeysManager;
            return this;
        }

        public FirebaseTokenVerifier build() {
            return new FirebaseTokenVerifier(this);
        }
    }
}

