/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.OnFailureListener;
import com.google.firebase.tasks.OnSuccessListener;
import com.google.firebase.tasks.RuntimeExecutionException;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import com.google.firebase.tasks.TaskExecutors;
import com.google.firebase.tasks.TaskImpl;
import java.util.concurrent.Executor;

class ContinueWithTaskCompletionListener<T, R>
implements TaskCompletionListener<T>,
OnSuccessListener<R>,
OnFailureListener {
    private final Executor executor;
    private final Continuation<T, Task<R>> continuation;
    private final TaskImpl<R> continuationTask;

    public ContinueWithTaskCompletionListener(@NonNull Executor executor, @NonNull Continuation<T, Task<R>> continuation, @NonNull TaskImpl<R> continuationTask) {
        this.executor = executor;
        this.continuation = continuation;
        this.continuationTask = continuationTask;
    }

    @Override
    public void onComplete(final @NonNull Task<T> task) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                Task resultTask;
                try {
                    resultTask = (Task)ContinueWithTaskCompletionListener.this.continuation.then(task);
                }
                catch (RuntimeExecutionException e) {
                    if (e.getCause() instanceof Exception) {
                        ContinueWithTaskCompletionListener.this.continuationTask.setException((Exception)e.getCause());
                    } else {
                        ContinueWithTaskCompletionListener.this.continuationTask.setException(e);
                    }
                    return;
                }
                catch (Exception e) {
                    ContinueWithTaskCompletionListener.this.continuationTask.setException(e);
                    return;
                }
                if (resultTask == null) {
                    ContinueWithTaskCompletionListener.this.onFailure(new NullPointerException("Continuation returned null"));
                    return;
                }
                resultTask.addOnSuccessListener(TaskExecutors.DIRECT, ContinueWithTaskCompletionListener.this);
                resultTask.addOnFailureListener(TaskExecutors.DIRECT, ContinueWithTaskCompletionListener.this);
            }
        });
    }

    @Override
    public void onSuccess(R result) {
        this.continuationTask.setResult(result);
    }

    @Override
    public void onFailure(@NonNull Exception e) {
        this.continuationTask.setException(e);
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException();
    }
}

