/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.annotations.NotNull;
import com.google.firebase.database.annotations.Nullable;
import com.google.firebase.database.collection.LLRBNode;
import com.google.firebase.database.connection.CompoundHash;
import com.google.firebase.database.connection.ListenHashProvider;
import com.google.firebase.database.core.CompoundWrite;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.EventRegistration;
import com.google.firebase.database.core.Path;
import com.google.firebase.database.core.ServerValues;
import com.google.firebase.database.core.SyncPoint;
import com.google.firebase.database.core.Tag;
import com.google.firebase.database.core.UserWriteRecord;
import com.google.firebase.database.core.WriteTree;
import com.google.firebase.database.core.WriteTreeRef;
import com.google.firebase.database.core.operation.AckUserWrite;
import com.google.firebase.database.core.operation.ListenComplete;
import com.google.firebase.database.core.operation.Merge;
import com.google.firebase.database.core.operation.Operation;
import com.google.firebase.database.core.operation.OperationSource;
import com.google.firebase.database.core.operation.Overwrite;
import com.google.firebase.database.core.persistence.PersistenceManager;
import com.google.firebase.database.core.utilities.ImmutableTree;
import com.google.firebase.database.core.view.CacheNode;
import com.google.firebase.database.core.view.Change;
import com.google.firebase.database.core.view.DataEvent;
import com.google.firebase.database.core.view.Event;
import com.google.firebase.database.core.view.QuerySpec;
import com.google.firebase.database.core.view.View;
import com.google.firebase.database.logging.LogWrapper;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.EmptyNode;
import com.google.firebase.database.snapshot.IndexedNode;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.RangeMerge;
import com.google.firebase.database.utilities.Clock;
import com.google.firebase.database.utilities.NodeSizeEstimator;
import com.google.firebase.database.utilities.Pair;
import com.google.firebase.database.utilities.Utilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class SyncTree {
    private static final long SIZE_THRESHOLD_FOR_COMPOUND_HASH = 1024L;
    private final WriteTree pendingWriteTree;
    private final Map<Tag, QuerySpec> tagToQueryMap;
    private final Map<QuerySpec, Tag> queryToTagMap;
    private final Set<QuerySpec> keepSyncedQueries;
    private final ListenProvider listenProvider;
    private final PersistenceManager persistenceManager;
    private final LogWrapper logger;
    private ImmutableTree<SyncPoint> syncPointTree = ImmutableTree.emptyInstance();
    private long nextQueryTag = 1L;

    public SyncTree(Context context, PersistenceManager persistenceManager, ListenProvider listenProvider) {
        this.pendingWriteTree = new WriteTree();
        this.tagToQueryMap = new HashMap<Tag, QuerySpec>();
        this.queryToTagMap = new HashMap<QuerySpec, Tag>();
        this.keepSyncedQueries = new HashSet<QuerySpec>();
        this.listenProvider = listenProvider;
        this.persistenceManager = persistenceManager;
        this.logger = context.getLogger("SyncTree");
    }

    public boolean isEmpty() {
        return this.syncPointTree.isEmpty();
    }

    public List<? extends Event> applyUserOverwrite(final Path path, final Node newDataUnresolved, final Node newData, final long writeId, final boolean visible, final boolean persist) {
        Utilities.hardAssert(visible || !persist, "We shouldn't be persisting non-visible writes.");
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                if (persist) {
                    SyncTree.this.persistenceManager.saveUserOverwrite(path, newDataUnresolved, writeId);
                }
                SyncTree.this.pendingWriteTree.addOverwrite(path, newData, writeId, visible);
                if (!visible) {
                    return Collections.emptyList();
                }
                return SyncTree.this.applyOperationToSyncPoints(new Overwrite(OperationSource.USER, path, newData));
            }
        });
    }

    public List<? extends Event> applyUserMerge(final Path path, final CompoundWrite unresolvedChildren, final CompoundWrite children, final long writeId, final boolean persist) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() throws Exception {
                if (persist) {
                    SyncTree.this.persistenceManager.saveUserMerge(path, unresolvedChildren, writeId);
                }
                SyncTree.this.pendingWriteTree.addMerge(path, children, writeId);
                return SyncTree.this.applyOperationToSyncPoints(new Merge(OperationSource.USER, path, children));
            }
        });
    }

    public List<? extends Event> ackUserWrite(final long writeId, final boolean revert, final boolean persist, final Clock serverClock) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                if (persist) {
                    SyncTree.this.persistenceManager.removeUserWrite(writeId);
                }
                UserWriteRecord write = SyncTree.this.pendingWriteTree.getWrite(writeId);
                boolean needToReevaluate = SyncTree.this.pendingWriteTree.removeWrite(writeId);
                if (write.isVisible() && !revert) {
                    Map<String, Object> serverValues = ServerValues.generateServerValues(serverClock);
                    if (write.isOverwrite()) {
                        Node resolvedNode = ServerValues.resolveDeferredValueSnapshot(write.getOverwrite(), serverValues);
                        SyncTree.this.persistenceManager.applyUserWriteToServerCache(write.getPath(), resolvedNode);
                    } else {
                        CompoundWrite resolvedMerge = ServerValues.resolveDeferredValueMerge(write.getMerge(), serverValues);
                        SyncTree.this.persistenceManager.applyUserWriteToServerCache(write.getPath(), resolvedMerge);
                    }
                }
                if (!needToReevaluate) {
                    return Collections.emptyList();
                }
                ImmutableTree<Boolean> affectedTree = ImmutableTree.emptyInstance();
                if (write.isOverwrite()) {
                    affectedTree = affectedTree.set(Path.getEmptyPath(), true);
                } else {
                    for (Map.Entry<Path, Node> entry : write.getMerge()) {
                        affectedTree = affectedTree.set(entry.getKey(), true);
                    }
                }
                return SyncTree.this.applyOperationToSyncPoints(new AckUserWrite(write.getPath(), affectedTree, revert));
            }
        });
    }

    public List<? extends Event> removeAllWrites() {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() throws Exception {
                SyncTree.this.persistenceManager.removeAllUserWrites();
                List<UserWriteRecord> purgedWrites = SyncTree.this.pendingWriteTree.purgeAllWrites();
                if (purgedWrites.isEmpty()) {
                    return Collections.emptyList();
                }
                ImmutableTree<Boolean> affectedTree = new ImmutableTree<Boolean>(true);
                return SyncTree.this.applyOperationToSyncPoints(new AckUserWrite(Path.getEmptyPath(), affectedTree, true));
            }
        });
    }

    public List<? extends Event> applyServerOverwrite(final Path path, final Node newData) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                SyncTree.this.persistenceManager.updateServerCache(QuerySpec.defaultQueryAtPath(path), newData);
                return SyncTree.this.applyOperationToSyncPoints(new Overwrite(OperationSource.SERVER, path, newData));
            }
        });
    }

    public List<? extends Event> applyServerMerge(final Path path, final Map<Path, Node> changedChildren) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                CompoundWrite merge = CompoundWrite.fromPathMerge(changedChildren);
                SyncTree.this.persistenceManager.updateServerCache(path, merge);
                return SyncTree.this.applyOperationToSyncPoints(new Merge(OperationSource.SERVER, path, merge));
            }
        });
    }

    public List<? extends Event> applyServerRangeMerges(Path path, List<RangeMerge> rangeMerges) {
        SyncPoint syncPoint = this.syncPointTree.get(path);
        if (syncPoint == null) {
            return Collections.emptyList();
        }
        View view = syncPoint.getCompleteView();
        if (view != null) {
            Node serverNode = view.getServerCache();
            for (RangeMerge merge : rangeMerges) {
                serverNode = merge.applyTo(serverNode);
            }
            return this.applyServerOverwrite(path, serverNode);
        }
        return Collections.emptyList();
    }

    public List<? extends Event> applyTaggedRangeMerges(Path path, List<RangeMerge> rangeMerges, Tag tag) {
        QuerySpec query = this.queryForTag(tag);
        if (query != null) {
            assert (path.equals(query.getPath()));
            SyncPoint syncPoint = this.syncPointTree.get(query.getPath());
            assert (syncPoint != null) : "Missing sync point for query tag that we're tracking";
            View view = syncPoint.viewForQuery(query);
            assert (view != null) : "Missing view for query tag that we're tracking";
            Node serverNode = view.getServerCache();
            for (RangeMerge merge : rangeMerges) {
                serverNode = merge.applyTo(serverNode);
            }
            return this.applyTaggedQueryOverwrite(path, serverNode, tag);
        }
        return Collections.emptyList();
    }

    public List<? extends Event> applyListenComplete(final Path path) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                SyncTree.this.persistenceManager.setQueryComplete(QuerySpec.defaultQueryAtPath(path));
                return SyncTree.this.applyOperationToSyncPoints(new ListenComplete(OperationSource.SERVER, path));
            }
        });
    }

    public List<? extends Event> applyTaggedListenComplete(final Tag tag) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                QuerySpec query = SyncTree.this.queryForTag(tag);
                if (query != null) {
                    SyncTree.this.persistenceManager.setQueryComplete(query);
                    ListenComplete op = new ListenComplete(OperationSource.forServerTaggedQuery(query.getParams()), Path.getEmptyPath());
                    return SyncTree.this.applyTaggedOperation(query, op);
                }
                return Collections.emptyList();
            }
        });
    }

    private List<? extends Event> applyTaggedOperation(QuerySpec query, Operation operation) {
        Path queryPath = query.getPath();
        SyncPoint syncPoint = this.syncPointTree.get(queryPath);
        assert (syncPoint != null) : "Missing sync point for query tag that we're tracking";
        WriteTreeRef writesCache = this.pendingWriteTree.childWrites(queryPath);
        return syncPoint.applyOperation(operation, writesCache, null);
    }

    public List<? extends Event> applyTaggedQueryOverwrite(final Path path, final Node snap, final Tag tag) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                QuerySpec query = SyncTree.this.queryForTag(tag);
                if (query != null) {
                    Path relativePath = Path.getRelative(query.getPath(), path);
                    QuerySpec queryToOverwrite = relativePath.isEmpty() ? query : QuerySpec.defaultQueryAtPath(path);
                    SyncTree.this.persistenceManager.updateServerCache(queryToOverwrite, snap);
                    Overwrite op = new Overwrite(OperationSource.forServerTaggedQuery(query.getParams()), relativePath, snap);
                    return SyncTree.this.applyTaggedOperation(query, op);
                }
                return Collections.emptyList();
            }
        });
    }

    public List<? extends Event> applyTaggedQueryMerge(final Path path, final Map<Path, Node> changedChildren, final Tag tag) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                QuerySpec query = SyncTree.this.queryForTag(tag);
                if (query != null) {
                    Path relativePath = Path.getRelative(query.getPath(), path);
                    CompoundWrite merge = CompoundWrite.fromPathMerge(changedChildren);
                    SyncTree.this.persistenceManager.updateServerCache(path, merge);
                    Merge op = new Merge(OperationSource.forServerTaggedQuery(query.getParams()), relativePath, merge);
                    return SyncTree.this.applyTaggedOperation(query, op);
                }
                return Collections.emptyList();
            }
        });
    }

    public List<? extends Event> addEventRegistration(final @NotNull EventRegistration eventRegistration) {
        return this.persistenceManager.runInTransaction(new Callable<List<? extends Event>>(){

            @Override
            public List<? extends Event> call() {
                CacheNode serverCache;
                QuerySpec query = eventRegistration.getQuerySpec();
                Path path = query.getPath();
                Node serverCacheNode = null;
                boolean foundAncestorDefaultView = false;
                ImmutableTree tree = SyncTree.this.syncPointTree;
                Path currentPath = path;
                while (!tree.isEmpty()) {
                    SyncPoint currentSyncPoint = (SyncPoint)tree.getValue();
                    if (currentSyncPoint != null) {
                        serverCacheNode = serverCacheNode != null ? serverCacheNode : currentSyncPoint.getCompleteServerCache(currentPath);
                        foundAncestorDefaultView = foundAncestorDefaultView || currentSyncPoint.hasCompleteView();
                    }
                    ChildKey front = currentPath.isEmpty() ? ChildKey.fromString("") : currentPath.getFront();
                    tree = tree.getChild(front);
                    currentPath = currentPath.popFront();
                }
                SyncPoint syncPoint = (SyncPoint)SyncTree.this.syncPointTree.get(path);
                if (syncPoint == null) {
                    syncPoint = new SyncPoint(SyncTree.this.persistenceManager);
                    SyncTree.this.syncPointTree = SyncTree.this.syncPointTree.set(path, syncPoint);
                } else {
                    foundAncestorDefaultView = foundAncestorDefaultView || syncPoint.hasCompleteView();
                    serverCacheNode = serverCacheNode != null ? serverCacheNode : syncPoint.getCompleteServerCache(Path.getEmptyPath());
                }
                SyncTree.this.persistenceManager.setQueryActive(query);
                if (serverCacheNode != null) {
                    serverCache = new CacheNode(IndexedNode.from(serverCacheNode, query.getIndex()), true, false);
                } else {
                    CacheNode persistentServerCache = SyncTree.this.persistenceManager.serverCache(query);
                    if (persistentServerCache.isFullyInitialized()) {
                        serverCache = persistentServerCache;
                    } else {
                        serverCacheNode = EmptyNode.Empty();
                        ImmutableTree subtree = SyncTree.this.syncPointTree.subtree(path);
                        for (Map.Entry entry : subtree.getChildren()) {
                            Node completeCache;
                            SyncPoint childSyncPoint = (SyncPoint)entry.getValue().getValue();
                            if (childSyncPoint == null || (completeCache = childSyncPoint.getCompleteServerCache(Path.getEmptyPath())) == null) continue;
                            serverCacheNode = serverCacheNode.updateImmediateChild(entry.getKey(), completeCache);
                        }
                        for (NamedNode namedNode : persistentServerCache.getNode()) {
                            if (serverCacheNode.hasChild(namedNode.getName())) continue;
                            serverCacheNode = serverCacheNode.updateImmediateChild(namedNode.getName(), namedNode.getNode());
                        }
                        serverCache = new CacheNode(IndexedNode.from(serverCacheNode, query.getIndex()), false, false);
                    }
                }
                boolean viewAlreadyExists = syncPoint.viewExistsForQuery(query);
                if (!viewAlreadyExists && !query.loadsAllData()) {
                    assert (!SyncTree.this.queryToTagMap.containsKey(query)) : "View does not exist but we have a tag";
                    Tag tag = SyncTree.this.getNextQueryTag();
                    SyncTree.this.queryToTagMap.put(query, tag);
                    SyncTree.this.tagToQueryMap.put(tag, query);
                }
                WriteTreeRef writesCache = SyncTree.this.pendingWriteTree.childWrites(path);
                List<DataEvent> events = syncPoint.addEventRegistration(eventRegistration, writesCache, serverCache);
                if (!viewAlreadyExists && !foundAncestorDefaultView) {
                    View view = syncPoint.viewForQuery(query);
                    SyncTree.this.setupListener(query, view);
                }
                return events;
            }
        });
    }

    public List<Event> removeAllEventRegistrations(@NotNull QuerySpec query, @NotNull DatabaseError error) {
        return this.removeEventRegistration(query, null, error);
    }

    public List<Event> removeEventRegistration(@NotNull EventRegistration eventRegistration) {
        return this.removeEventRegistration(eventRegistration.getQuerySpec(), eventRegistration, null);
    }

    private List<Event> removeEventRegistration(final @NotNull QuerySpec query, final @Nullable EventRegistration eventRegistration, final @Nullable DatabaseError cancelError) {
        return this.persistenceManager.runInTransaction(new Callable<List<Event>>(){

            @Override
            public List<Event> call() {
                Path path = query.getPath();
                SyncPoint maybeSyncPoint = (SyncPoint)SyncTree.this.syncPointTree.get(path);
                List<Event> cancelEvents = new ArrayList<Event>();
                if (maybeSyncPoint != null && (query.isDefault() || maybeSyncPoint.viewExistsForQuery(query))) {
                    ImmutableTree subtree;
                    Pair<List<QuerySpec>, List<Event>> removedAndEvents = maybeSyncPoint.removeEventRegistration(query, eventRegistration, cancelError);
                    if (maybeSyncPoint.isEmpty()) {
                        SyncTree.this.syncPointTree = SyncTree.this.syncPointTree.remove(path);
                    }
                    List<QuerySpec> removed = removedAndEvents.getFirst();
                    cancelEvents = removedAndEvents.getSecond();
                    boolean removingDefault = false;
                    for (QuerySpec queryRemoved : removed) {
                        SyncTree.this.persistenceManager.setQueryInactive(query);
                        removingDefault = removingDefault || queryRemoved.loadsAllData();
                    }
                    ImmutableTree currentTree = SyncTree.this.syncPointTree;
                    boolean covered = currentTree.getValue() != null && ((SyncPoint)currentTree.getValue()).hasCompleteView();
                    for (ChildKey component : path) {
                        currentTree = currentTree.getChild(component);
                        boolean bl = covered = covered || currentTree.getValue() != null && ((SyncPoint)currentTree.getValue()).hasCompleteView();
                        if (!covered && !currentTree.isEmpty()) continue;
                        break;
                    }
                    if (removingDefault && !covered && !(subtree = SyncTree.this.syncPointTree.subtree(path)).isEmpty()) {
                        List newViews = SyncTree.this.collectDistinctViewsForSubTree(subtree);
                        for (View view : newViews) {
                            ListenContainer container = new ListenContainer(view);
                            QuerySpec newQuery = view.getQuery();
                            SyncTree.this.listenProvider.startListening(SyncTree.this.queryForListening(newQuery), container.tag, container, container);
                        }
                    }
                    if (!covered && !removed.isEmpty() && cancelError == null) {
                        if (removingDefault) {
                            SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(query), null);
                        } else {
                            for (QuerySpec queryToRemove : removed) {
                                Tag tag = SyncTree.this.tagForQuery(queryToRemove);
                                assert (tag != null);
                                SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(queryToRemove), tag);
                            }
                        }
                    }
                    SyncTree.this.removeTags(removed);
                }
                return cancelEvents;
            }
        });
    }

    public void keepSynced(QuerySpec query, boolean keep) {
        if (keep && !this.keepSyncedQueries.contains(query)) {
            this.addEventRegistration(new KeepSyncedEventRegistration(query));
            this.keepSyncedQueries.add(query);
        } else if (!keep && this.keepSyncedQueries.contains(query)) {
            this.removeEventRegistration(new KeepSyncedEventRegistration(query));
            this.keepSyncedQueries.remove(query);
        }
    }

    private List<View> collectDistinctViewsForSubTree(ImmutableTree<SyncPoint> subtree) {
        ArrayList<View> accumulator = new ArrayList<View>();
        this.collectDistinctViewsForSubTree(subtree, accumulator);
        return accumulator;
    }

    private void collectDistinctViewsForSubTree(ImmutableTree<SyncPoint> subtree, List<View> accumulator) {
        SyncPoint maybeSyncPoint = subtree.getValue();
        if (maybeSyncPoint != null && maybeSyncPoint.hasCompleteView()) {
            accumulator.add(maybeSyncPoint.getCompleteView());
        } else {
            if (maybeSyncPoint != null) {
                accumulator.addAll(maybeSyncPoint.getQueryViews());
            }
            for (Map.Entry<ChildKey, ImmutableTree<SyncPoint>> entry : subtree.getChildren()) {
                this.collectDistinctViewsForSubTree(entry.getValue(), accumulator);
            }
        }
    }

    private void removeTags(List<QuerySpec> queries) {
        for (QuerySpec removedQuery : queries) {
            if (removedQuery.loadsAllData()) continue;
            Tag tag = this.tagForQuery(removedQuery);
            assert (tag != null);
            this.queryToTagMap.remove(removedQuery);
            this.tagToQueryMap.remove(tag);
        }
    }

    private QuerySpec queryForListening(QuerySpec query) {
        if (query.loadsAllData() && !query.isDefault()) {
            return QuerySpec.defaultQueryAtPath(query.getPath());
        }
        return query;
    }

    private void setupListener(QuerySpec query, View view) {
        Path path = query.getPath();
        Tag tag = this.tagForQuery(query);
        ListenContainer container = new ListenContainer(view);
        this.listenProvider.startListening(this.queryForListening(query), tag, container, container);
        ImmutableTree<SyncPoint> subtree = this.syncPointTree.subtree(path);
        if (tag != null) {
            assert (!subtree.getValue().hasCompleteView()) : "If we're adding a query, it shouldn't be shadowed";
        } else {
            subtree.foreach(new ImmutableTree.TreeVisitor<SyncPoint, Void>(){

                @Override
                public Void onNodeValue(Path relativePath, SyncPoint maybeChildSyncPoint, Void accum) {
                    if (!relativePath.isEmpty() && maybeChildSyncPoint.hasCompleteView()) {
                        QuerySpec query = maybeChildSyncPoint.getCompleteView().getQuery();
                        SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(query), SyncTree.this.tagForQuery(query));
                    } else {
                        for (View syncPointView : maybeChildSyncPoint.getQueryViews()) {
                            QuerySpec childQuery = syncPointView.getQuery();
                            SyncTree.this.listenProvider.stopListening(SyncTree.this.queryForListening(childQuery), SyncTree.this.tagForQuery(childQuery));
                        }
                    }
                    return null;
                }
            });
        }
    }

    private QuerySpec queryForTag(Tag tag) {
        return this.tagToQueryMap.get(tag);
    }

    private Tag tagForQuery(QuerySpec query) {
        return this.queryToTagMap.get(query);
    }

    public Node calcCompleteEventCache(Path path, List<Long> writeIdsToExclude) {
        ImmutableTree<SyncPoint> tree = this.syncPointTree;
        SyncPoint currentSyncPoint = tree.getValue();
        Node serverCache = null;
        Path pathToFollow = path;
        Path pathSoFar = Path.getEmptyPath();
        do {
            ChildKey front = pathToFollow.getFront();
            pathToFollow = pathToFollow.popFront();
            pathSoFar = pathSoFar.child(front);
            Path relativePath = Path.getRelative(pathSoFar, path);
            tree = front != null ? tree.getChild(front) : ImmutableTree.emptyInstance();
            currentSyncPoint = tree.getValue();
            if (currentSyncPoint == null) continue;
            serverCache = currentSyncPoint.getCompleteServerCache(relativePath);
        } while (!pathToFollow.isEmpty() && serverCache == null);
        return this.pendingWriteTree.calcCompleteEventCache(path, serverCache, writeIdsToExclude, true);
    }

    private Tag getNextQueryTag() {
        return new Tag(this.nextQueryTag++);
    }

    private List<Event> applyOperationToSyncPoints(Operation operation) {
        return this.applyOperationHelper(operation, this.syncPointTree, null, this.pendingWriteTree.childWrites(Path.getEmptyPath()));
    }

    private List<Event> applyOperationHelper(Operation operation, ImmutableTree<SyncPoint> syncPointTree, Node serverCache, WriteTreeRef writesCache) {
        if (operation.getPath().isEmpty()) {
            return this.applyOperationDescendantsHelper(operation, syncPointTree, serverCache, writesCache);
        }
        SyncPoint syncPoint = syncPointTree.getValue();
        if (serverCache == null && syncPoint != null) {
            serverCache = syncPoint.getCompleteServerCache(Path.getEmptyPath());
        }
        ArrayList<Event> events = new ArrayList<Event>();
        ChildKey childKey = operation.getPath().getFront();
        Operation childOperation = operation.operationForChild(childKey);
        ImmutableTree<SyncPoint> childTree = syncPointTree.getChildren().get(childKey);
        if (childTree != null && childOperation != null) {
            Node childServerCache = serverCache != null ? serverCache.getImmediateChild(childKey) : null;
            WriteTreeRef childWritesCache = writesCache.child(childKey);
            events.addAll(this.applyOperationHelper(childOperation, childTree, childServerCache, childWritesCache));
        }
        if (syncPoint != null) {
            events.addAll(syncPoint.applyOperation(operation, writesCache, serverCache));
        }
        return events;
    }

    private List<Event> applyOperationDescendantsHelper(final Operation operation, ImmutableTree<SyncPoint> syncPointTree, Node serverCache, final WriteTreeRef writesCache) {
        SyncPoint syncPoint = syncPointTree.getValue();
        final Node resolvedServerCache = serverCache == null && syncPoint != null ? syncPoint.getCompleteServerCache(Path.getEmptyPath()) : serverCache;
        final ArrayList<Event> events = new ArrayList<Event>();
        syncPointTree.getChildren().inOrderTraversal(new LLRBNode.NodeVisitor<ChildKey, ImmutableTree<SyncPoint>>(){

            @Override
            public void visitEntry(ChildKey key, ImmutableTree<SyncPoint> childTree) {
                Node childServerCache = null;
                if (resolvedServerCache != null) {
                    childServerCache = resolvedServerCache.getImmediateChild(key);
                }
                WriteTreeRef childWritesCache = writesCache.child(key);
                Operation childOperation = operation.operationForChild(key);
                if (childOperation != null) {
                    events.addAll(SyncTree.this.applyOperationDescendantsHelper(childOperation, childTree, childServerCache, childWritesCache));
                }
            }
        });
        if (syncPoint != null) {
            events.addAll(syncPoint.applyOperation(operation, writesCache, resolvedServerCache));
        }
        return events;
    }

    ImmutableTree<SyncPoint> getSyncPointTree() {
        return this.syncPointTree;
    }

    private class ListenContainer
    implements ListenHashProvider,
    CompletionListener {
        private final View view;
        private final Tag tag;

        public ListenContainer(View view) {
            this.view = view;
            this.tag = SyncTree.this.tagForQuery(view.getQuery());
        }

        @Override
        public CompoundHash getCompoundHash() {
            com.google.firebase.database.snapshot.CompoundHash hash = com.google.firebase.database.snapshot.CompoundHash.fromNode(this.view.getServerCache());
            List<Path> pathPosts = hash.getPosts();
            ArrayList<List<String>> posts = new ArrayList<List<String>>(pathPosts.size());
            for (Path path : pathPosts) {
                posts.add(path.asList());
            }
            return new CompoundHash(posts, hash.getHashes());
        }

        @Override
        public String getSimpleHash() {
            return this.view.getServerCache().getHash();
        }

        @Override
        public boolean shouldIncludeCompoundHash() {
            return NodeSizeEstimator.estimateSerializedNodeSize(this.view.getServerCache()) > 1024L;
        }

        @Override
        public List<? extends Event> onListenComplete(DatabaseError error) {
            if (error == null) {
                QuerySpec query = this.view.getQuery();
                if (this.tag != null) {
                    return SyncTree.this.applyTaggedListenComplete(this.tag);
                }
                return SyncTree.this.applyListenComplete(query.getPath());
            }
            SyncTree.this.logger.warn("Listen at " + this.view.getQuery().getPath() + " failed: " + error.toString());
            return SyncTree.this.removeAllEventRegistrations(this.view.getQuery(), error);
        }
    }

    private static class KeepSyncedEventRegistration
    extends EventRegistration {
        private QuerySpec spec;

        public KeepSyncedEventRegistration(@NotNull QuerySpec spec) {
            this.spec = spec;
        }

        @Override
        public boolean respondsTo(Event.EventType eventType) {
            return false;
        }

        @Override
        public DataEvent createEvent(Change change, QuerySpec query) {
            return null;
        }

        @Override
        public void fireEvent(DataEvent dataEvent) {
        }

        @Override
        public void fireCancelEvent(DatabaseError error) {
        }

        @Override
        public EventRegistration clone(QuerySpec newQuery) {
            return new KeepSyncedEventRegistration(newQuery);
        }

        @Override
        public boolean isSameListener(EventRegistration other) {
            return other instanceof KeepSyncedEventRegistration;
        }

        @Override
        @NotNull
        public QuerySpec getQuerySpec() {
            return this.spec;
        }

        public boolean equals(Object other) {
            return other instanceof KeepSyncedEventRegistration && ((KeepSyncedEventRegistration)other).spec.equals(this.spec);
        }

        public int hashCode() {
            return this.spec.hashCode();
        }
    }

    public static interface ListenProvider {
        public void startListening(QuerySpec var1, Tag var2, ListenHashProvider var3, CompletionListener var4);

        public void stopListening(QuerySpec var1, Tag var2);
    }

    public static interface CompletionListener {
        public List<? extends Event> onListenComplete(DatabaseError var1);
    }
}

