/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.core;

import com.google.firebase.FirebaseApp;
import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.InternalHelpers;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.DatabaseConfig;
import com.google.firebase.database.core.Repo;
import com.google.firebase.database.core.RepoInfo;
import com.google.firebase.database.core.RunLoop;
import java.util.HashMap;
import java.util.Map;

public class RepoManager {
    private static final RepoManager instance = new RepoManager();
    private final Map<Context, Map<String, Repo>> repos = new HashMap<Context, Map<String, Repo>>();

    public static Repo getRepo(Context ctx, RepoInfo info) throws DatabaseException {
        return instance.getLocalRepo(ctx, info);
    }

    public static Repo createRepo(Context ctx, RepoInfo info, FirebaseDatabase database) throws DatabaseException {
        return instance.createLocalRepo(ctx, info, database);
    }

    public static void interrupt(Context ctx) {
        instance.interruptInternal(ctx);
    }

    public static void interrupt(final Repo repo) {
        repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                repo.interrupt();
            }
        });
    }

    public static void resume(final Repo repo) {
        repo.scheduleNow(new Runnable(){

            @Override
            public void run() {
                repo.resume();
            }
        });
    }

    public static void resume(Context ctx) {
        instance.resumeInternal(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Repo getLocalRepo(Context ctx, RepoInfo info) throws DatabaseException {
        ctx.freeze();
        String repoHash = "https://" + info.host + "/" + info.namespace;
        Map<Context, Map<String, Repo>> map = this.repos;
        synchronized (map) {
            if (!this.repos.containsKey(ctx) || !this.repos.get(ctx).containsKey(repoHash)) {
                InternalHelpers.createDatabaseForTests(FirebaseApp.getInstance(), info, (DatabaseConfig)ctx);
            }
            return this.repos.get(ctx).get(repoHash);
        }
    }

    private Repo createLocalRepo(Context ctx, RepoInfo info, FirebaseDatabase database) throws DatabaseException {
        ctx.freeze();
        String repoHash = "https://" + info.host + "/" + info.namespace;
        Map<Context, Map<String, Repo>> map = this.repos;
        synchronized (map) {
            Map<Object, Object> innerMap;
            if (!this.repos.containsKey(ctx)) {
                innerMap = new HashMap();
                this.repos.put(ctx, innerMap);
            }
            if (!(innerMap = this.repos.get(ctx)).containsKey(repoHash)) {
                Repo repo = new Repo(info, ctx, database);
                innerMap.put(repoHash, repo);
                return repo;
            }
            throw new IllegalStateException("createLocalRepo() called for existing repo.");
        }
    }

    private void interruptInternal(final Context ctx) {
        RunLoop runLoop = ctx.getRunLoop();
        if (runLoop != null) {
            runLoop.scheduleNow(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = RepoManager.this.repos;
                    synchronized (map) {
                        boolean allEmpty = true;
                        if (RepoManager.this.repos.containsKey(ctx)) {
                            for (Repo repo : ((Map)RepoManager.this.repos.get(ctx)).values()) {
                                repo.interrupt();
                                allEmpty = allEmpty && !repo.hasListeners();
                            }
                            if (allEmpty) {
                                ctx.stop();
                            }
                        }
                    }
                }
            });
        }
    }

    private void resumeInternal(final Context ctx) {
        RunLoop runLoop = ctx.getRunLoop();
        if (runLoop != null) {
            runLoop.scheduleNow(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Map map = RepoManager.this.repos;
                    synchronized (map) {
                        if (RepoManager.this.repos.containsKey(ctx)) {
                            for (Repo repo : ((Map)RepoManager.this.repos.get(ctx)).values()) {
                                repo.resume();
                            }
                        }
                    }
                }
            });
        }
    }
}

