/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.Clock;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseException;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.FirebaseCredentials;
import com.google.firebase.auth.FirebaseToken;
import com.google.firebase.auth.internal.FirebaseTokenFactory;
import com.google.firebase.auth.internal.FirebaseTokenVerifier;
import com.google.firebase.internal.FirebaseService;
import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.util.Map;

public class FirebaseAuth {
    private static final JsonFactory jsonFactory = new GsonFactory();
    private final FirebaseApp firebaseApp;
    private final GooglePublicKeysManager googlePublicKeysManager;
    private final Clock clock;
    private static final String SERVICE_ID = FirebaseAuth.class.getName();

    private FirebaseAuth(FirebaseApp firebaseApp) {
        this(firebaseApp, FirebaseTokenVerifier.DEFAULT_KEY_MANAGER, Clock.SYSTEM);
    }

    @VisibleForTesting
    FirebaseAuth(FirebaseApp firebaseApp, GooglePublicKeysManager googlePublicKeysManager, Clock clock) {
        this.firebaseApp = firebaseApp;
        this.googlePublicKeysManager = googlePublicKeysManager;
        this.clock = clock;
    }

    public static FirebaseAuth getInstance() {
        return FirebaseAuth.getInstance(FirebaseApp.getInstance());
    }

    public static synchronized FirebaseAuth getInstance(FirebaseApp app) {
        FirebaseAuthService service = ImplFirebaseTrampolines.getService(app, SERVICE_ID, FirebaseAuthService.class);
        if (service == null) {
            service = ImplFirebaseTrampolines.addService(app, new FirebaseAuthService(app));
        }
        return (FirebaseAuth)service.getInstance();
    }

    public Task<String> createCustomToken(String uid) {
        return this.createCustomToken(uid, null);
    }

    public Task<String> createCustomToken(final String uid, final Map<String, Object> developerClaims) {
        FirebaseCredential credential = ImplFirebaseTrampolines.getCredential(this.firebaseApp);
        if (!(credential instanceof FirebaseCredentials.CertCredential)) {
            return Tasks.forException(new FirebaseException("Must initialize FirebaseApp with a certificate credential to call createCustomToken()"));
        }
        return ((FirebaseCredentials.CertCredential)credential).getCertificate().continueWith(new Continuation<GoogleCredential, String>(){

            @Override
            public String then(@NonNull Task<GoogleCredential> task) throws Exception {
                GoogleCredential baseCredential = task.getResult();
                FirebaseTokenFactory tokenFactory = FirebaseTokenFactory.getInstance();
                return tokenFactory.createSignedCustomAuthTokenForUser(uid, developerClaims, baseCredential.getServiceAccountId(), baseCredential.getServiceAccountPrivateKey());
            }
        });
    }

    public Task<FirebaseToken> verifyIdToken(final String token) {
        FirebaseCredential credential = ImplFirebaseTrampolines.getCredential(this.firebaseApp);
        if (!(credential instanceof FirebaseCredentials.CertCredential)) {
            return Tasks.forException(new FirebaseException("Must initialize FirebaseApp with a certificate credential to call verifyIdToken()"));
        }
        return ((FirebaseCredentials.CertCredential)credential).getProjectId().continueWith(new Continuation<String, FirebaseToken>(){

            @Override
            public FirebaseToken then(@NonNull Task<String> task) throws Exception {
                FirebaseTokenVerifier firebaseTokenVerifier = new FirebaseTokenVerifier.Builder().setProjectId(task.getResult()).setPublicKeysManager(FirebaseAuth.this.googlePublicKeysManager).setClock(FirebaseAuth.this.clock).build();
                FirebaseToken firebaseToken = FirebaseToken.parse(jsonFactory, token);
                firebaseTokenVerifier.verifyTokenAndSignature(firebaseToken.getToken());
                return firebaseToken;
            }
        });
    }

    private static class FirebaseAuthService
    extends FirebaseService<FirebaseAuth> {
        FirebaseAuthService(FirebaseApp app) {
            super(SERVICE_ID, new FirebaseAuth(app));
        }

        @Override
        public void destroy() {
        }
    }
}

