/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.firebase.auth.FirebaseCredential;
import com.google.firebase.auth.FirebaseCredentials;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class FirebaseOptions {
    private final String databaseUrl;
    private final FirebaseCredential firebaseCredential;
    private final Map<String, Object> databaseAuthVariableOverride;

    private FirebaseOptions(@Nullable String databaseUrl, @NonNull FirebaseCredential firebaseCredential, @Nullable Map<String, Object> databaseAuthVariableOverride) {
        this.databaseUrl = databaseUrl;
        this.firebaseCredential = (FirebaseCredential)Preconditions.checkNotNull((Object)firebaseCredential, (Object)"Service Account must be provided.");
        this.databaseAuthVariableOverride = databaseAuthVariableOverride;
    }

    public String getDatabaseUrl() {
        return this.databaseUrl;
    }

    FirebaseCredential getCredential() {
        return this.firebaseCredential;
    }

    public Map<String, Object> getDatabaseAuthVariableOverride() {
        return this.databaseAuthVariableOverride;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FirebaseOptions)) {
            return false;
        }
        FirebaseOptions other = (FirebaseOptions)obj;
        return Objects.equal((Object)this.databaseUrl, (Object)other.databaseUrl) && Objects.equal((Object)this.firebaseCredential, (Object)other.firebaseCredential) && Objects.equal(this.databaseAuthVariableOverride, other.databaseAuthVariableOverride);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.databaseUrl, this.firebaseCredential, this.databaseAuthVariableOverride});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("databaseUrl", (Object)this.databaseUrl).add("credential", (Object)this.firebaseCredential).add("databaseAuthVariableOverride", this.databaseAuthVariableOverride).toString();
    }

    public static final class Builder {
        private String databaseUrl;
        private FirebaseCredential firebaseCredential;
        private FirebaseCredential serviceAccountCredential;
        private Map<String, Object> databaseAuthVariableOverride = new HashMap<String, Object>();

        public Builder() {
        }

        public Builder(FirebaseOptions options) {
            this.databaseUrl = options.databaseUrl;
            this.firebaseCredential = options.firebaseCredential;
            this.databaseAuthVariableOverride = options.databaseAuthVariableOverride;
        }

        public Builder setDatabaseUrl(@Nullable String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        @Deprecated
        public Builder setServiceAccount(@NonNull InputStream stream) {
            this.serviceAccountCredential = FirebaseCredentials.fromCertificate(stream);
            return this;
        }

        public Builder setCredential(@NonNull FirebaseCredential credential) {
            this.firebaseCredential = (FirebaseCredential)Preconditions.checkNotNull((Object)credential);
            return this;
        }

        public Builder setDatabaseAuthVariableOverride(@Nullable Map<String, Object> databaseAuthVariableOverride) {
            this.databaseAuthVariableOverride = databaseAuthVariableOverride;
            return this;
        }

        public FirebaseOptions build() {
            if (this.serviceAccountCredential == null && this.firebaseCredential == null) {
                throw new IllegalStateException("FirebaseOptions must be initialized with setCredential().");
            }
            if (this.serviceAccountCredential != null && this.firebaseCredential != null) {
                throw new IllegalStateException("FirebaseOptions cannot be initialized with both setCredential() and setServiceAccount().");
            }
            FirebaseCredential firebaseCredential = this.firebaseCredential != null ? this.firebaseCredential : this.serviceAccountCredential;
            return new FirebaseOptions(this.databaseUrl, firebaseCredential, this.databaseAuthVariableOverride);
        }
    }
}

