/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.internal;

import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.ImplFirebaseTrampolines;
import com.google.firebase.internal.Base64Utils;
import com.google.firebase.internal.FirebaseAppStore;
import com.google.firebase.internal.Joiner;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class SharedPrefsFirebaseAppStore
extends FirebaseAppStore {
    private static final int DATA_FORMAT_VERSION = 1;
    private static final String KEY_DATA_FORMAT_VERSION_VERSION = "version";
    private static final String KEY_FIREBASE_APP_NAMES = "firebase-app-names";
    private static final String KEY_PREFIX_API_KEY = "apiKey-";
    private static final String KEY_PREFIX_APP_ID = "appId-";
    private static final String KEY_PREFIX_DATABASE_URL = "dbUrl-";
    private static final String KEY_PREFIX_GA_TRACKING_ID = "gaTrackingId-";
    private static final String KEY_PREFIX_GCM_SENDER_ID = "gcmSenderId-";
    private static final String KEY_PREFIX_STORAGE_BUCKET = "storageBucket-";
    private static final String VALUE_SEPARATOR = ",";
    private final Object mLock = new Object();
    private Preferences mPreferences;

    SharedPrefsFirebaseAppStore() {
    }

    @Override
    public Set<String> getAllPersistedAppNames() {
        this.ensurePrefsInitialized();
        List<String> encodedAppNames = this.getEncodedAppNames();
        HashSet<String> persistedAppNames = new HashSet<String>();
        for (String encodedAppName : encodedAppNames) {
            persistedAppNames.add(SharedPrefsFirebaseAppStore.decodeValue(encodedAppName));
        }
        return persistedAppNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void persistApp(@NonNull FirebaseApp app) {
        Object object = this.mLock;
        synchronized (object) {
            Preferences prefs = this.ensurePrefsInitialized();
            String encodedAppName = SharedPrefsFirebaseAppStore.encodeValue(app.getName());
            String encodedAppNamesValue = prefs.get(KEY_FIREBASE_APP_NAMES, "");
            List<String> encodedAppNames = Arrays.asList(encodedAppNamesValue.split(VALUE_SEPARATOR));
            if (!ImplFirebaseTrampolines.isDefaultApp(app) && encodedAppNames.contains(encodedAppName)) {
                this.checkPersistedAppCompatible(app);
                return;
            }
            FirebaseOptions options = app.getOptions();
            String string = String.valueOf(VALUE_SEPARATOR);
            prefs.put(KEY_FIREBASE_APP_NAMES, new StringBuilder(String.valueOf(encodedAppNamesValue).length() + String.valueOf(string).length() + String.valueOf(encodedAppName).length()).append(encodedAppNamesValue).append(string).append(encodedAppName).toString());
            String string2 = String.valueOf(KEY_PREFIX_DATABASE_URL);
            String string3 = String.valueOf(encodedAppName);
            SharedPrefsFirebaseAppStore.writeValue(prefs, string3.length() != 0 ? string2.concat(string3) : new String(string2), options.getDatabaseUrl());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeApp(@NonNull String name) {
        Object object = this.mLock;
        synchronized (object) {
            Preferences prefs = this.ensurePrefsInitialized();
            String encodedAppName = SharedPrefsFirebaseAppStore.encodeValue(name);
            String encodedAppNamesValue = prefs.get(KEY_FIREBASE_APP_NAMES, "");
            List<String> encodedAppNames = Arrays.asList(encodedAppNamesValue.split(VALUE_SEPARATOR));
            ArrayList<String> updatedEncodedAppNames = new ArrayList<String>(encodedAppNames);
            updatedEncodedAppNames.remove(encodedAppName);
            prefs.put(KEY_FIREBASE_APP_NAMES, Joiner.on(VALUE_SEPARATOR).join(updatedEncodedAppNames));
            String string = String.valueOf(KEY_PREFIX_API_KEY);
            String string2 = String.valueOf(encodedAppName);
            prefs.remove(string2.length() != 0 ? string.concat(string2) : new String(string));
            String string3 = String.valueOf(KEY_PREFIX_APP_ID);
            String string4 = String.valueOf(encodedAppName);
            prefs.remove(string4.length() != 0 ? string3.concat(string4) : new String(string3));
            String string5 = String.valueOf(KEY_PREFIX_DATABASE_URL);
            String string6 = String.valueOf(encodedAppName);
            prefs.remove(string6.length() != 0 ? string5.concat(string6) : new String(string5));
            String string7 = String.valueOf(KEY_PREFIX_GA_TRACKING_ID);
            String string8 = String.valueOf(encodedAppName);
            prefs.remove(string8.length() != 0 ? string7.concat(string8) : new String(string7));
            String string9 = String.valueOf(KEY_PREFIX_GCM_SENDER_ID);
            String string10 = String.valueOf(encodedAppName);
            prefs.remove(string10.length() != 0 ? string9.concat(string10) : new String(string9));
            String string11 = String.valueOf(KEY_PREFIX_STORAGE_BUCKET);
            String string12 = String.valueOf(encodedAppName);
            prefs.remove(string12.length() != 0 ? string11.concat(string12) : new String(string11));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FirebaseOptions restoreAppOptions(@NonNull String name) {
        Object object = this.mLock;
        synchronized (object) {
            Preferences prefs = this.ensurePrefsInitialized();
            String encodedName = SharedPrefsFirebaseAppStore.encodeValue(name);
            String string = String.valueOf(KEY_PREFIX_APP_ID);
            String string2 = String.valueOf(encodedName);
            String applicationId = prefs.get(string2.length() != 0 ? string.concat(string2) : new String(string), null);
            if (applicationId == null) {
                return null;
            }
            String string3 = String.valueOf(KEY_PREFIX_DATABASE_URL);
            String string4 = String.valueOf(encodedName);
            return new FirebaseOptions.Builder().setDatabaseUrl(SharedPrefsFirebaseAppStore.readValue(prefs, string4.length() != 0 ? string3.concat(string4) : new String(string3))).build();
        }
    }

    private void checkPersistedAppCompatible(FirebaseApp app) {
        String name = app.getName();
        FirebaseOptions options = this.restoreAppOptions(name);
        String string = String.valueOf(app.getName());
        String string2 = String.valueOf(options);
        String string3 = String.valueOf(app.getOptions());
        Preconditions.checkState(options.equals(app.getOptions()), new StringBuilder(99 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("FirebaseApp ").append(string).append(" incompatible with persisted version! Persisted options ").append(string2).append(" Newly initialized app options ").append(string3).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Preferences ensurePrefsInitialized() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPreferences == null) {
                this.mPreferences = Preferences.userNodeForPackage(FirebaseApp.class);
                int readDataVersion = this.mPreferences.getInt(KEY_DATA_FORMAT_VERSION_VERSION, -1);
                if (readDataVersion == -1) {
                    this.resetStore();
                } else if (readDataVersion != 1) {
                    throw new IllegalStateException(String.format("Unexpected data format version. Was %d, but expected %d.", readDataVersion, 1));
                }
            }
        }
        return this.mPreferences;
    }

    private List<String> getEncodedAppNames() {
        String encodedAppNamesValue = this.mPreferences.get(KEY_FIREBASE_APP_NAMES, "");
        ArrayList<String> encodedAppNames = new ArrayList<String>();
        for (String encodedAppName : encodedAppNamesValue.split(VALUE_SEPARATOR)) {
            if (encodedAppName == null || encodedAppName.equals("")) continue;
            encodedAppNames.add(encodedAppName);
        }
        return encodedAppNames;
    }

    @Override
    protected void resetStore() {
        try {
            this.mPreferences.clear();
        }
        catch (BackingStoreException e) {
            throw new IllegalStateException("Could not clear Preferences", e);
        }
        this.mPreferences.putInt(KEY_DATA_FORMAT_VERSION_VERSION, 1);
    }

    private static String encodeValue(String value) {
        if (value == null) {
            value = "";
        }
        return Base64Utils.encodeUrlSafeNoPadding(value.getBytes(StandardCharsets.UTF_8));
    }

    private static String decodeValue(String encodedValue) {
        String decodedValue = new String(Base64Utils.decodeUrlSafeNoPadding(encodedValue), StandardCharsets.UTF_8);
        if (decodedValue == null || decodedValue.equals("")) {
            return null;
        }
        return decodedValue;
    }

    private static void writeValue(Preferences prefs, String key, String value) {
        if (value != null) {
            prefs.put(key, SharedPrefsFirebaseAppStore.encodeValue(value));
        }
    }

    private static String readValue(Preferences prefs, String key) {
        String encodedValue = prefs.get(key, null);
        if (encodedValue != null) {
            return SharedPrefsFirebaseAppStore.decodeValue(encodedValue);
        }
        return null;
    }
}

