/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.utilities;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.annotations.Nullable;
import com.google.firebase.database.core.Context;
import com.google.firebase.database.core.RepoManager;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.internal.RevivingScheduledExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class DefaultRunLoop
implements RunLoop {
    private ScheduledThreadPoolExecutor executor;

    public abstract void handleException(Throwable var1);

    public DefaultRunLoop() {
        this(Executors.defaultThreadFactory(), false, null);
    }

    public DefaultRunLoop(ThreadFactory threadFactory, boolean periodicRestart, final @Nullable Context context) {
        this.executor = new RevivingScheduledExecutor(threadFactory, "FirebaseDatabaseWorker", periodicRestart){

            @Override
            protected void handleException(Throwable t) {
                DefaultRunLoop.this.handleException(t);
            }

            @Override
            protected void beforeRestart() {
                if (context != null) {
                    RepoManager.interrupt(context);
                }
            }

            @Override
            protected void afterRestart() {
                if (context != null) {
                    RepoManager.resume(context);
                }
            }
        };
        this.executor.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public void scheduleNow(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    public ScheduledFuture schedule(Runnable runnable, long milliseconds) {
        return this.executor.schedule(runnable, milliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.executor.setCorePoolSize(0);
    }

    @Override
    public void restart() {
        this.executor.setCorePoolSize(1);
    }

    public static String messageForException(Throwable t) {
        if (t instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (t instanceof DatabaseException) {
            return "";
        }
        String string = String.valueOf(FirebaseDatabase.getSdkVersion());
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }
}

