/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.collection.ImmutableSortedSet;
import com.google.firebase.database.snapshot.ChildKey;
import com.google.firebase.database.snapshot.ChildrenNode;
import com.google.firebase.database.snapshot.Index;
import com.google.firebase.database.snapshot.KeyIndex;
import com.google.firebase.database.snapshot.NamedNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.PriorityIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class IndexedNode
implements Iterable<NamedNode> {
    private static final ImmutableSortedSet<NamedNode> FALLBACK_INDEX = new ImmutableSortedSet(Collections.emptyList(), null);
    private final Node node;
    private ImmutableSortedSet<NamedNode> indexed;
    private final Index index;

    private IndexedNode(Node node, Index index) {
        this.index = index;
        this.node = node;
        this.indexed = null;
    }

    private IndexedNode(Node node, Index index, ImmutableSortedSet<NamedNode> indexed) {
        this.index = index;
        this.node = node;
        this.indexed = indexed;
    }

    private void ensureIndexed() {
        if (this.indexed == null) {
            if (this.index.equals(KeyIndex.getInstance())) {
                this.indexed = FALLBACK_INDEX;
            } else {
                ArrayList<NamedNode> children = new ArrayList<NamedNode>();
                boolean sawIndexedValue = false;
                for (NamedNode entry : this.node) {
                    sawIndexedValue = sawIndexedValue || this.index.isDefinedOn(entry.getNode());
                    NamedNode namedNode = new NamedNode(entry.getName(), entry.getNode());
                    children.add(namedNode);
                }
                this.indexed = sawIndexedValue ? new ImmutableSortedSet<NamedNode>(children, this.index) : FALLBACK_INDEX;
            }
        }
    }

    public static IndexedNode from(Node node) {
        return new IndexedNode(node, PriorityIndex.getInstance());
    }

    public static IndexedNode from(Node node, Index index) {
        return new IndexedNode(node, index);
    }

    public boolean hasIndex(Index index) {
        return this.index.equals(index);
    }

    public Node getNode() {
        return this.node;
    }

    @Override
    public Iterator<NamedNode> iterator() {
        this.ensureIndexed();
        if (this.indexed == FALLBACK_INDEX) {
            return this.node.iterator();
        }
        return this.indexed.iterator();
    }

    public Iterator<NamedNode> reverseIterator() {
        this.ensureIndexed();
        if (this.indexed == FALLBACK_INDEX) {
            return this.node.reverseIterator();
        }
        return this.indexed.reverseIterator();
    }

    public IndexedNode updateChild(ChildKey key, Node child) {
        Node newNode = this.node.updateImmediateChild(key, child);
        if (this.indexed == FALLBACK_INDEX && !this.index.isDefinedOn(child)) {
            return new IndexedNode(newNode, this.index, FALLBACK_INDEX);
        }
        if (this.indexed == null || this.indexed == FALLBACK_INDEX) {
            return new IndexedNode(newNode, this.index, null);
        }
        Node oldChild = this.node.getImmediateChild(key);
        ImmutableSortedSet<NamedNode> newIndexed = this.indexed.remove(new NamedNode(key, oldChild));
        if (!child.isEmpty()) {
            newIndexed = newIndexed.insert(new NamedNode(key, child));
        }
        return new IndexedNode(newNode, this.index, newIndexed);
    }

    public IndexedNode updatePriority(Node priority) {
        return new IndexedNode(this.node.updatePriority(priority), this.index, this.indexed);
    }

    public NamedNode getFirstChild() {
        if (!(this.node instanceof ChildrenNode)) {
            return null;
        }
        this.ensureIndexed();
        if (this.indexed == FALLBACK_INDEX) {
            ChildKey firstKey = ((ChildrenNode)this.node).getFirstChildKey();
            return new NamedNode(firstKey, this.node.getImmediateChild(firstKey));
        }
        return this.indexed.getMinEntry();
    }

    public NamedNode getLastChild() {
        if (!(this.node instanceof ChildrenNode)) {
            return null;
        }
        this.ensureIndexed();
        if (this.indexed == FALLBACK_INDEX) {
            ChildKey lastKey = ((ChildrenNode)this.node).getLastChildKey();
            return new NamedNode(lastKey, this.node.getImmediateChild(lastKey));
        }
        return this.indexed.getMaxEntry();
    }

    public ChildKey getPredecessorChildName(ChildKey childKey, Node childNode, Index index) {
        if (!this.index.equals(KeyIndex.getInstance()) && !this.index.equals(index)) {
            throw new IllegalArgumentException("Index not available in IndexedNode!");
        }
        this.ensureIndexed();
        if (this.indexed == FALLBACK_INDEX) {
            return this.node.getPredecessorChildKey(childKey);
        }
        NamedNode node = this.indexed.getPredecessorEntry(new NamedNode(childKey, childNode));
        return node != null ? node.getName() : null;
    }
}

