/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.snapshot;

import com.google.firebase.database.snapshot.LeafNode;
import com.google.firebase.database.snapshot.Node;
import com.google.firebase.database.snapshot.PriorityUtilities;
import java.util.Map;

public class DeferredValueNode
extends LeafNode<DeferredValueNode> {
    private Map<Object, Object> value;

    public DeferredValueNode(Map<Object, Object> value, Node priority) {
        super(priority);
        this.value = value;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getHashRepresentation(Node.HashVersion version) {
        String string = String.valueOf(this.getPriorityHash(version));
        String string2 = String.valueOf(this.value);
        return new StringBuilder(14 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("deferredValue:").append(string2).toString();
    }

    @Override
    public DeferredValueNode updatePriority(Node priority) {
        assert (PriorityUtilities.isValidPriority(priority));
        return new DeferredValueNode(this.value, priority);
    }

    @Override
    protected LeafNode.LeafType getLeafType() {
        return LeafNode.LeafType.DeferredValue;
    }

    @Override
    protected int compareLeafValues(DeferredValueNode other) {
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof DeferredValueNode)) {
            return false;
        }
        DeferredValueNode otherDeferredValueNode = (DeferredValueNode)other;
        return this.value.equals(otherDeferredValueNode.value) && this.priority.equals(otherDeferredValueNode.priority);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode() + this.priority.hashCode();
    }
}

