/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.database.utilities;

import com.google.firebase.database.DatabaseException;
import com.google.firebase.database.FirebaseDatabase;
import com.google.firebase.database.core.RunLoop;
import com.google.firebase.database.core.ThreadInitializer;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public abstract class DefaultRunLoop
implements RunLoop {
    private ScheduledThreadPoolExecutor executor;

    protected ThreadFactory getThreadFactory() {
        return Executors.defaultThreadFactory();
    }

    protected ThreadInitializer getThreadInitializer() {
        return ThreadInitializer.defaultInstance;
    }

    public abstract void handleException(Throwable var1);

    public DefaultRunLoop() {
        int threadsInPool = 1;
        FirebaseThreadFactory threadFactory = new FirebaseThreadFactory();
        this.executor = new ScheduledThreadPoolExecutor(threadsInPool, threadFactory){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                if (t == null && r instanceof Future) {
                    Future future = (Future)((Object)r);
                    try {
                        if (future.isDone()) {
                            future.get();
                        }
                    }
                    catch (CancellationException cancellationException) {
                    }
                    catch (ExecutionException ee) {
                        t = ee.getCause();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (t != null) {
                    DefaultRunLoop.this.handleException(t);
                }
            }
        };
        this.executor.setKeepAliveTime(3L, TimeUnit.SECONDS);
    }

    public ScheduledExecutorService getExecutorService() {
        return this.executor;
    }

    @Override
    public void scheduleNow(Runnable runnable) {
        this.executor.execute(runnable);
    }

    @Override
    public ScheduledFuture schedule(Runnable runnable, long milliseconds) {
        return this.executor.schedule(runnable, milliseconds, TimeUnit.MILLISECONDS);
    }

    @Override
    public void shutdown() {
        this.executor.setCorePoolSize(0);
    }

    @Override
    public void restart() {
        this.executor.setCorePoolSize(1);
    }

    public static String messageForException(Throwable t) {
        if (t instanceof OutOfMemoryError) {
            return "Firebase Database encountered an OutOfMemoryError. You may need to reduce the amount of data you are syncing to the client (e.g. by using queries or syncing a deeper path). See https://firebase.google.com/docs/database/ios/structure-data#best_practices_for_data_structure and https://firebase.google.com/docs/database/android/retrieve-data#filtering_data";
        }
        if (t instanceof DatabaseException) {
            return "";
        }
        String string = String.valueOf(FirebaseDatabase.getSdkVersion());
        return new StringBuilder(104 + String.valueOf(string).length()).append("Uncaught exception in Firebase Database runloop (").append(string).append("). Please report to firebase-database-client@google.com").toString();
    }

    private class FirebaseThreadFactory
    implements ThreadFactory {
        private FirebaseThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = DefaultRunLoop.this.getThreadFactory().newThread(r);
            ThreadInitializer initializer = DefaultRunLoop.this.getThreadInitializer();
            initializer.setName(thread, "FirebaseDatabaseWorker");
            initializer.setDaemon(thread, true);
            initializer.setUncaughtExceptionHandler(thread, new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    DefaultRunLoop.this.handleException(e);
                }
            });
            return thread;
        }
    }
}

