/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.common.annotations.VisibleForTesting;
import com.google.firebase.FirebaseAppLifecycleListener;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.internal.Base64Utils;
import com.google.firebase.internal.FirebaseAppStore;
import com.google.firebase.internal.GetTokenResult;
import com.google.firebase.internal.GuardedBy;
import com.google.firebase.internal.Joiner;
import com.google.firebase.internal.NonNull;
import com.google.firebase.internal.Nullable;
import com.google.firebase.internal.Objects;
import com.google.firebase.internal.Preconditions;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.Tasks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class FirebaseApp {
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    static final Map<String, FirebaseApp> sInstances = new HashMap<String, FirebaseApp>();
    private final String mName;
    private final FirebaseOptions mOptions;
    private final AtomicBoolean mDeleted = new AtomicBoolean();
    private final List<FirebaseAppLifecycleListener> mLifecycleListeners = new CopyOnWriteArrayList<FirebaseAppLifecycleListener>();
    private Task<GetTokenResult> mCachedGetTokenTask;
    private final Object mCachedGetTokenTaskLock = new Object();

    @NonNull
    public String getName() {
        this.checkNotDeleted();
        return this.mName;
    }

    @NonNull
    public FirebaseOptions getOptions() {
        this.checkNotDeleted();
        return this.mOptions;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseApp)) {
            return false;
        }
        return this.mName.equals(((FirebaseApp)o).getName());
    }

    public int hashCode() {
        return this.mName.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper(this).add("name", this.mName).add("options", this.mOptions).toString();
    }

    public static List<FirebaseApp> getApps() {
        return new ArrayList<FirebaseApp>(sInstances.values());
    }

    @Nullable
    public static FirebaseApp getInstance() {
        return FirebaseApp.getInstance(DEFAULT_APP_NAME);
    }

    public static FirebaseApp getInstance(@NonNull String name) {
        Object object = sLock;
        synchronized (object) {
            String availableAppNamesMessage;
            FirebaseApp firebaseApp = sInstances.get(FirebaseApp.normalize(name));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> availableAppNames = FirebaseApp.getAllAppNames();
            if (availableAppNames.isEmpty()) {
                availableAppNamesMessage = "";
            } else {
                String string = String.valueOf(Joiner.on(", ").join(availableAppNames));
                availableAppNamesMessage = string.length() != 0 ? "Available app names: ".concat(string) : new String("Available app names: ");
            }
            String errorMessage = String.format("FirebaseApp with name %s doesn't exist. %s", name, availableAppNamesMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    public static FirebaseApp initializeApp(FirebaseOptions options) {
        return FirebaseApp.initializeApp(options, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FirebaseApp initializeApp(FirebaseOptions options, String name) {
        FirebaseApp firebaseApp;
        FirebaseAppStore appStore = FirebaseAppStore.initialize();
        String normalizedName = FirebaseApp.normalize(name);
        Object object = sLock;
        synchronized (object) {
            Preconditions.checkState(!sInstances.containsKey(normalizedName), new StringBuilder(33 + String.valueOf(normalizedName).length()).append("FirebaseApp name ").append(normalizedName).append(" already exists!").toString());
            firebaseApp = new FirebaseApp(normalizedName, options);
            sInstances.put(normalizedName, firebaseApp);
        }
        appStore.persistApp(firebaseApp);
        return firebaseApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        boolean valueChanged = this.mDeleted.compareAndSet(false, true);
        if (!valueChanged) {
            return;
        }
        Object object = sLock;
        synchronized (object) {
            sInstances.remove(this.mName);
        }
        FirebaseAppStore appStore = FirebaseAppStore.getInstance();
        if (appStore != null) {
            appStore.removeApp(this.mName);
        }
        this.notifyOnAppDeleted();
    }

    private FirebaseApp(String name, FirebaseOptions options) {
        this.mName = Preconditions.checkNotEmpty(name);
        this.mOptions = Preconditions.checkNotNull(options);
    }

    private void checkNotDeleted() {
        Preconditions.checkState(!this.mDeleted.get(), "FirebaseApp was deleted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<GetTokenResult> getToken(boolean forceRefresh) {
        this.checkNotDeleted();
        Object object = this.mCachedGetTokenTaskLock;
        synchronized (object) {
            if (this.mCachedGetTokenTask == null || this.mCachedGetTokenTask.isComplete() && (!this.mCachedGetTokenTask.isSuccessful() || forceRefresh)) {
                final GoogleCredential scoped = this.mOptions.getServiceAccountCredential().createScoped(Arrays.asList("https://www.googleapis.com/auth/firebase.database", "https://www.googleapis.com/auth/userinfo.email"));
                this.mCachedGetTokenTask = Tasks.call(new Callable<GetTokenResult>(this){

                    @Override
                    public GetTokenResult call() throws Exception {
                        scoped.refreshToken();
                        if (scoped.getAccessToken() == null) {
                            throw new AssertionError((Object)"Access token should not be null after refresh.");
                        }
                        return new GetTokenResult(scoped.getAccessToken());
                    }
                });
            }
            return this.mCachedGetTokenTask;
        }
    }

    boolean isDefaultApp() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    String getPersistenceKey() {
        return FirebaseApp.getPersistenceKey(this.getName(), this.getOptions());
    }

    void addLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        this.mLifecycleListeners.add(listener);
    }

    void removeLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull(listener);
        this.mLifecycleListeners.remove(listener);
    }

    private void notifyOnAppDeleted() {
        for (FirebaseAppLifecycleListener listener : this.mLifecycleListeners) {
            listener.onDeleted(this.mName, this.mOptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static void clearInstancesForTest() {
        Object object = sLock;
        synchronized (object) {
            sInstances.clear();
        }
    }

    static String getPersistenceKey(String name, FirebaseOptions options) {
        return Base64Utils.encodeUrlSafeNoPadding(name.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAppNames() {
        HashSet<String> allAppNames = new HashSet<String>();
        Object object = sLock;
        synchronized (object) {
            for (FirebaseApp app : sInstances.values()) {
                allAppNames.add(app.getName());
            }
            FirebaseAppStore appStore = FirebaseAppStore.getInstance();
            if (appStore != null) {
                allAppNames.addAll(appStore.getAllPersistedAppNames());
            }
        }
        ArrayList<String> sortedNameList = new ArrayList<String>(allAppNames);
        Collections.sort(sortedNameList);
        return sortedNameList;
    }

    private static String normalize(@NonNull String name) {
        return name.trim();
    }
}

