/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.tasks;

import com.google.firebase.internal.NonNull;
import com.google.firebase.tasks.Continuation;
import com.google.firebase.tasks.OnFailureListener;
import com.google.firebase.tasks.OnSuccessListener;
import com.google.firebase.tasks.RuntimeExecutionException;
import com.google.firebase.tasks.Task;
import com.google.firebase.tasks.TaskCompletionListener;
import com.google.firebase.tasks.TaskExecutors;
import com.google.firebase.tasks.TaskImpl;
import java.util.concurrent.Executor;

class ContinueWithTaskCompletionListener<TResult, TContinuationResult>
implements TaskCompletionListener<TResult>,
OnSuccessListener<TContinuationResult>,
OnFailureListener {
    private final Executor mExecutor;
    private final Continuation<TResult, Task<TContinuationResult>> mContinuation;
    private final TaskImpl<TContinuationResult> mContinuationTask;

    public ContinueWithTaskCompletionListener(@NonNull Executor executor, @NonNull Continuation<TResult, Task<TContinuationResult>> continuation, @NonNull TaskImpl<TContinuationResult> continuationTask) {
        this.mExecutor = executor;
        this.mContinuation = continuation;
        this.mContinuationTask = continuationTask;
    }

    @Override
    public void onComplete(final @NonNull Task<TResult> task) {
        this.mExecutor.execute(new Runnable(){

            @Override
            public void run() {
                Task resultTask;
                try {
                    resultTask = (Task)ContinueWithTaskCompletionListener.this.mContinuation.then(task);
                }
                catch (RuntimeExecutionException e) {
                    if (e.getCause() instanceof Exception) {
                        ContinueWithTaskCompletionListener.this.mContinuationTask.setException((Exception)e.getCause());
                    } else {
                        ContinueWithTaskCompletionListener.this.mContinuationTask.setException(e);
                    }
                    return;
                }
                catch (Exception e) {
                    ContinueWithTaskCompletionListener.this.mContinuationTask.setException(e);
                    return;
                }
                if (resultTask == null) {
                    ContinueWithTaskCompletionListener.this.onFailure(new NullPointerException("Continuation returned null"));
                    return;
                }
                resultTask.addOnSuccessListener(TaskExecutors.DIRECT, ContinueWithTaskCompletionListener.this);
                resultTask.addOnFailureListener(TaskExecutors.DIRECT, ContinueWithTaskCompletionListener.this);
            }
        });
    }

    @Override
    public void onSuccess(TContinuationResult result) {
        this.mContinuationTask.setResult(result);
    }

    @Override
    public void onFailure(@NonNull Exception e) {
        this.mContinuationTask.setException(e);
    }

    @Override
    public void cancel() {
        throw new UnsupportedOperationException();
    }
}

