// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/servicecontrol/v1/quota_controller.proto

package com.google.api.servicecontrol.v1;

/**
 * <pre>
 * Represents information regarding a quota operation.
 * </pre>
 *
 * Protobuf type {@code google.api.servicecontrol.v1.QuotaOperation}
 */
public  final class QuotaOperation extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:google.api.servicecontrol.v1.QuotaOperation)
    QuotaOperationOrBuilder {
  // Use QuotaOperation.newBuilder() to construct.
  private QuotaOperation(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private QuotaOperation() {
    operationId_ = "";
    methodName_ = "";
    consumerId_ = "";
    quotaMetrics_ = java.util.Collections.emptyList();
    quotaMode_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return com.google.protobuf.UnknownFieldSet.getDefaultInstance();
  }
  private QuotaOperation(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    int mutable_bitField0_ = 0;
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default: {
            if (!input.skipField(tag)) {
              done = true;
            }
            break;
          }
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            operationId_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();

            methodName_ = s;
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            consumerId_ = s;
            break;
          }
          case 34: {
            if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
              labels_ = com.google.protobuf.MapField.newMapField(
                  LabelsDefaultEntryHolder.defaultEntry);
              mutable_bitField0_ |= 0x00000008;
            }
            com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
            labels = input.readMessage(
                LabelsDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
            labels_.getMutableMap().put(labels.getKey(), labels.getValue());
            break;
          }
          case 42: {
            if (!((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
              quotaMetrics_ = new java.util.ArrayList<com.google.api.servicecontrol.v1.MetricValueSet>();
              mutable_bitField0_ |= 0x00000010;
            }
            quotaMetrics_.add(
                input.readMessage(com.google.api.servicecontrol.v1.MetricValueSet.parser(), extensionRegistry));
            break;
          }
          case 48: {
            int rawValue = input.readEnum();

            quotaMode_ = rawValue;
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000010) == 0x00000010)) {
        quotaMetrics_ = java.util.Collections.unmodifiableList(quotaMetrics_);
      }
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.servicecontrol.v1.QuotaControllerProto.internal_static_google_api_servicecontrol_v1_QuotaOperation_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  protected com.google.protobuf.MapField internalGetMapField(
      int number) {
    switch (number) {
      case 4:
        return internalGetLabels();
      default:
        throw new RuntimeException(
            "Invalid map field number: " + number);
    }
  }
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.servicecontrol.v1.QuotaControllerProto.internal_static_google_api_servicecontrol_v1_QuotaOperation_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.servicecontrol.v1.QuotaOperation.class, com.google.api.servicecontrol.v1.QuotaOperation.Builder.class);
  }

  /**
   * <pre>
   * Supported quota modes. This can be specified only when the operation is
   * associated with a AllocateQuota and ReleaseQuota request.
   * </pre>
   *
   * Protobuf enum {@code google.api.servicecontrol.v1.QuotaOperation.QuotaMode}
   */
  public enum QuotaMode
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>UNSPECIFIED = 0;</code>
     */
    UNSPECIFIED(0),
    /**
     * <pre>
     * For AllocateQuota request, allocates quota for the amount specified in
     * the service configuration or specified using the quota metrics. If the
     * amount is higher than the available quota, allocation error will be
     * returned and no quota will be allocated.
     * For ReleaseQuota request, this mode is supported only for precise quota
     * limits. In this case, this operation releases quota for the amount
     * specified in the service configuration or specified using the quota
     * metrics. If the release can make available quota negative, release error
     * will be returned and no quota will be released.
     * </pre>
     *
     * <code>NORMAL = 1;</code>
     */
    NORMAL(1),
    /**
     * <pre>
     * For AllocateQuota request, this mode is supported only for imprecise
     * quota limits. In this case, the operation allocates quota for the amount
     * specified in the service configuration or specified using the quota
     * metrics. If the amount is higher than the available quota, request does
     * not fail but all available quota will be allocated.
     * For ReleaseQuota request, this mode is supported for both precise quota
     * limits and imprecise quota limits. In this case, this operation releases
     * quota for the amount specified in the service configuration or specified
     * using the quota metrics. If the release can make available quota
     * negative, request does not fail but only the available quota will be
     * released. After the ReleaseQuota request completes, the available quota
     * will be 0, and never goes to negative.
     * </pre>
     *
     * <code>BEST_EFFORT = 2;</code>
     */
    BEST_EFFORT(2),
    /**
     * <pre>
     * For AllocateQuota request, only checks if there is enough quota
     * available and does not change the available quota. No lock is placed on
     * the available quota either. Not supported for ReleaseQuota request.
     * </pre>
     *
     * <code>CHECK_ONLY = 3;</code>
     */
    CHECK_ONLY(3),
    UNRECOGNIZED(-1),
    ;

    /**
     * <code>UNSPECIFIED = 0;</code>
     */
    public static final int UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * For AllocateQuota request, allocates quota for the amount specified in
     * the service configuration or specified using the quota metrics. If the
     * amount is higher than the available quota, allocation error will be
     * returned and no quota will be allocated.
     * For ReleaseQuota request, this mode is supported only for precise quota
     * limits. In this case, this operation releases quota for the amount
     * specified in the service configuration or specified using the quota
     * metrics. If the release can make available quota negative, release error
     * will be returned and no quota will be released.
     * </pre>
     *
     * <code>NORMAL = 1;</code>
     */
    public static final int NORMAL_VALUE = 1;
    /**
     * <pre>
     * For AllocateQuota request, this mode is supported only for imprecise
     * quota limits. In this case, the operation allocates quota for the amount
     * specified in the service configuration or specified using the quota
     * metrics. If the amount is higher than the available quota, request does
     * not fail but all available quota will be allocated.
     * For ReleaseQuota request, this mode is supported for both precise quota
     * limits and imprecise quota limits. In this case, this operation releases
     * quota for the amount specified in the service configuration or specified
     * using the quota metrics. If the release can make available quota
     * negative, request does not fail but only the available quota will be
     * released. After the ReleaseQuota request completes, the available quota
     * will be 0, and never goes to negative.
     * </pre>
     *
     * <code>BEST_EFFORT = 2;</code>
     */
    public static final int BEST_EFFORT_VALUE = 2;
    /**
     * <pre>
     * For AllocateQuota request, only checks if there is enough quota
     * available and does not change the available quota. No lock is placed on
     * the available quota either. Not supported for ReleaseQuota request.
     * </pre>
     *
     * <code>CHECK_ONLY = 3;</code>
     */
    public static final int CHECK_ONLY_VALUE = 3;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QuotaMode valueOf(int value) {
      return forNumber(value);
    }

    public static QuotaMode forNumber(int value) {
      switch (value) {
        case 0: return UNSPECIFIED;
        case 1: return NORMAL;
        case 2: return BEST_EFFORT;
        case 3: return CHECK_ONLY;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<QuotaMode>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        QuotaMode> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<QuotaMode>() {
            public QuotaMode findValueByNumber(int number) {
              return QuotaMode.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.api.servicecontrol.v1.QuotaOperation.getDescriptor().getEnumTypes().get(0);
    }

    private static final QuotaMode[] VALUES = values();

    public static QuotaMode valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private QuotaMode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.servicecontrol.v1.QuotaOperation.QuotaMode)
  }

  private int bitField0_;
  public static final int OPERATION_ID_FIELD_NUMBER = 1;
  private volatile java.lang.Object operationId_;
  /**
   * <pre>
   * Identity of the operation. This must be unique within the scope of the
   * service that generated the operation. If the service calls AllocateQuota
   * and ReleaseQuota on the same operation, the two calls should carry the
   * same ID.
   * UUID version 4 is recommended, though not required. In scenarios where an
   * operation is computed from existing information and an idempotent id is
   * desirable for deduplication purpose, UUID version 5 is recommended. See
   * RFC 4122 for details.
   * </pre>
   *
   * <code>optional string operation_id = 1;</code>
   */
  public java.lang.String getOperationId() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      operationId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Identity of the operation. This must be unique within the scope of the
   * service that generated the operation. If the service calls AllocateQuota
   * and ReleaseQuota on the same operation, the two calls should carry the
   * same ID.
   * UUID version 4 is recommended, though not required. In scenarios where an
   * operation is computed from existing information and an idempotent id is
   * desirable for deduplication purpose, UUID version 5 is recommended. See
   * RFC 4122 for details.
   * </pre>
   *
   * <code>optional string operation_id = 1;</code>
   */
  public com.google.protobuf.ByteString
      getOperationIdBytes() {
    java.lang.Object ref = operationId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      operationId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int METHOD_NAME_FIELD_NUMBER = 2;
  private volatile java.lang.Object methodName_;
  /**
   * <pre>
   * Fully qualified name of the API method for which this quota operation is
   * requested. This name is used for matching quota rules or metric rules and
   * billing status rules defined in service configuration. This field is not
   * required if the quota operation is performed on non-API resources.
   * Example of an RPC method name:
   *     google.example.library.v1.LibraryService.CreateShelf
   * </pre>
   *
   * <code>optional string method_name = 2;</code>
   */
  public java.lang.String getMethodName() {
    java.lang.Object ref = methodName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      methodName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Fully qualified name of the API method for which this quota operation is
   * requested. This name is used for matching quota rules or metric rules and
   * billing status rules defined in service configuration. This field is not
   * required if the quota operation is performed on non-API resources.
   * Example of an RPC method name:
   *     google.example.library.v1.LibraryService.CreateShelf
   * </pre>
   *
   * <code>optional string method_name = 2;</code>
   */
  public com.google.protobuf.ByteString
      getMethodNameBytes() {
    java.lang.Object ref = methodName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      methodName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CONSUMER_ID_FIELD_NUMBER = 3;
  private volatile java.lang.Object consumerId_;
  /**
   * <pre>
   * Identity of the consumer for whom this quota operation is being performed.
   * This can be in one of the following formats:
   *   project:&lt;project_id&gt;,
   *   project_number:&lt;project_number&gt;,
   *   api_key:&lt;api_key&gt;.
   * (--GOOGLE_INTERNAL:
   *   spatula_header:&lt;spatula_header&gt; and
   *   loas:&lt;loas_role&gt; are also accepted.
   * --)
   * </pre>
   *
   * <code>optional string consumer_id = 3;</code>
   */
  public java.lang.String getConsumerId() {
    java.lang.Object ref = consumerId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      consumerId_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Identity of the consumer for whom this quota operation is being performed.
   * This can be in one of the following formats:
   *   project:&lt;project_id&gt;,
   *   project_number:&lt;project_number&gt;,
   *   api_key:&lt;api_key&gt;.
   * (--GOOGLE_INTERNAL:
   *   spatula_header:&lt;spatula_header&gt; and
   *   loas:&lt;loas_role&gt; are also accepted.
   * --)
   * </pre>
   *
   * <code>optional string consumer_id = 3;</code>
   */
  public com.google.protobuf.ByteString
      getConsumerIdBytes() {
    java.lang.Object ref = consumerId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      consumerId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int LABELS_FIELD_NUMBER = 4;
  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
        java.lang.String, java.lang.String> defaultEntry =
            com.google.protobuf.MapEntry
            .<java.lang.String, java.lang.String>newDefaultInstance(
                com.google.api.servicecontrol.v1.QuotaControllerProto.internal_static_google_api_servicecontrol_v1_QuotaOperation_LabelsEntry_descriptor, 
                com.google.protobuf.WireFormat.FieldType.STRING,
                "",
                com.google.protobuf.WireFormat.FieldType.STRING,
                "");
  }
  private com.google.protobuf.MapField<
      java.lang.String, java.lang.String> labels_;
  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
  internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }
  /**
   * <pre>
   * Labels describing the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */

  public boolean containsLabels(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    return internalGetLabels().getMap().containsKey(key);
  }
  /**
   * Use {@link #getLabelsMap()} instead.
   */
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }
  /**
   * <pre>
   * Labels describing the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */

  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }
  /**
   * <pre>
   * Labels describing the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */

  public java.lang.String getLabelsOrDefault(
      java.lang.String key,
      java.lang.String defaultValue) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   * <pre>
   * Labels describing the operation.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 4;</code>
   */

  public java.lang.String getLabelsOrThrow(
      java.lang.String key) {
    if (key == null) { throw new java.lang.NullPointerException(); }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int QUOTA_METRICS_FIELD_NUMBER = 5;
  private java.util.List<com.google.api.servicecontrol.v1.MetricValueSet> quotaMetrics_;
  /**
   * <pre>
   * Represents information about this operation. Each MetricValueSet
   * corresponds to a metric defined in the service configuration.
   * The data type used in the MetricValueSet must agree with
   * the data type specified in the metric definition.
   * Within a single operation, it is not allowed to have more than one
   * MetricValue instances that have the same metric names and identical
   * label value combinations. If a request has such duplicated MetricValue
   * instances, the entire request is rejected with
   * an invalid argument error.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
   */
  public java.util.List<com.google.api.servicecontrol.v1.MetricValueSet> getQuotaMetricsList() {
    return quotaMetrics_;
  }
  /**
   * <pre>
   * Represents information about this operation. Each MetricValueSet
   * corresponds to a metric defined in the service configuration.
   * The data type used in the MetricValueSet must agree with
   * the data type specified in the metric definition.
   * Within a single operation, it is not allowed to have more than one
   * MetricValue instances that have the same metric names and identical
   * label value combinations. If a request has such duplicated MetricValue
   * instances, the entire request is rejected with
   * an invalid argument error.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
   */
  public java.util.List<? extends com.google.api.servicecontrol.v1.MetricValueSetOrBuilder> 
      getQuotaMetricsOrBuilderList() {
    return quotaMetrics_;
  }
  /**
   * <pre>
   * Represents information about this operation. Each MetricValueSet
   * corresponds to a metric defined in the service configuration.
   * The data type used in the MetricValueSet must agree with
   * the data type specified in the metric definition.
   * Within a single operation, it is not allowed to have more than one
   * MetricValue instances that have the same metric names and identical
   * label value combinations. If a request has such duplicated MetricValue
   * instances, the entire request is rejected with
   * an invalid argument error.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
   */
  public int getQuotaMetricsCount() {
    return quotaMetrics_.size();
  }
  /**
   * <pre>
   * Represents information about this operation. Each MetricValueSet
   * corresponds to a metric defined in the service configuration.
   * The data type used in the MetricValueSet must agree with
   * the data type specified in the metric definition.
   * Within a single operation, it is not allowed to have more than one
   * MetricValue instances that have the same metric names and identical
   * label value combinations. If a request has such duplicated MetricValue
   * instances, the entire request is rejected with
   * an invalid argument error.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
   */
  public com.google.api.servicecontrol.v1.MetricValueSet getQuotaMetrics(int index) {
    return quotaMetrics_.get(index);
  }
  /**
   * <pre>
   * Represents information about this operation. Each MetricValueSet
   * corresponds to a metric defined in the service configuration.
   * The data type used in the MetricValueSet must agree with
   * the data type specified in the metric definition.
   * Within a single operation, it is not allowed to have more than one
   * MetricValue instances that have the same metric names and identical
   * label value combinations. If a request has such duplicated MetricValue
   * instances, the entire request is rejected with
   * an invalid argument error.
   * </pre>
   *
   * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
   */
  public com.google.api.servicecontrol.v1.MetricValueSetOrBuilder getQuotaMetricsOrBuilder(
      int index) {
    return quotaMetrics_.get(index);
  }

  public static final int QUOTA_MODE_FIELD_NUMBER = 6;
  private int quotaMode_;
  /**
   * <pre>
   * Quota mode for this operation.
   * </pre>
   *
   * <code>optional .google.api.servicecontrol.v1.QuotaOperation.QuotaMode quota_mode = 6;</code>
   */
  public int getQuotaModeValue() {
    return quotaMode_;
  }
  /**
   * <pre>
   * Quota mode for this operation.
   * </pre>
   *
   * <code>optional .google.api.servicecontrol.v1.QuotaOperation.QuotaMode quota_mode = 6;</code>
   */
  public com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode getQuotaMode() {
    com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode result = com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode.valueOf(quotaMode_);
    return result == null ? com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getOperationIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, operationId_);
    }
    if (!getMethodNameBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, methodName_);
    }
    if (!getConsumerIdBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, consumerId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
         : internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
      labels = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      output.writeMessage(4, labels);
    }
    for (int i = 0; i < quotaMetrics_.size(); i++) {
      output.writeMessage(5, quotaMetrics_.get(i));
    }
    if (quotaMode_ != com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode.UNSPECIFIED.getNumber()) {
      output.writeEnum(6, quotaMode_);
    }
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getOperationIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, operationId_);
    }
    if (!getMethodNameBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, methodName_);
    }
    if (!getConsumerIdBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, consumerId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry
         : internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
      labels = LabelsDefaultEntryHolder.defaultEntry.newBuilderForType()
          .setKey(entry.getKey())
          .setValue(entry.getValue())
          .build();
      size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, labels);
    }
    for (int i = 0; i < quotaMetrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, quotaMetrics_.get(i));
    }
    if (quotaMode_ != com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(6, quotaMode_);
    }
    memoizedSize = size;
    return size;
  }

  private static final long serialVersionUID = 0L;
  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.servicecontrol.v1.QuotaOperation)) {
      return super.equals(obj);
    }
    com.google.api.servicecontrol.v1.QuotaOperation other = (com.google.api.servicecontrol.v1.QuotaOperation) obj;

    boolean result = true;
    result = result && getOperationId()
        .equals(other.getOperationId());
    result = result && getMethodName()
        .equals(other.getMethodName());
    result = result && getConsumerId()
        .equals(other.getConsumerId());
    result = result && internalGetLabels().equals(
        other.internalGetLabels());
    result = result && getQuotaMetricsList()
        .equals(other.getQuotaMetricsList());
    result = result && quotaMode_ == other.quotaMode_;
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptorForType().hashCode();
    hash = (37 * hash) + OPERATION_ID_FIELD_NUMBER;
    hash = (53 * hash) + getOperationId().hashCode();
    hash = (37 * hash) + METHOD_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getMethodName().hashCode();
    hash = (37 * hash) + CONSUMER_ID_FIELD_NUMBER;
    hash = (53 * hash) + getConsumerId().hashCode();
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    if (getQuotaMetricsCount() > 0) {
      hash = (37 * hash) + QUOTA_METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getQuotaMetricsList().hashCode();
    }
    hash = (37 * hash) + QUOTA_MODE_FIELD_NUMBER;
    hash = (53 * hash) + quotaMode_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.servicecontrol.v1.QuotaOperation parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.servicecontrol.v1.QuotaOperation prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Represents information regarding a quota operation.
   * </pre>
   *
   * Protobuf type {@code google.api.servicecontrol.v1.QuotaOperation}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.servicecontrol.v1.QuotaOperation)
      com.google.api.servicecontrol.v1.QuotaOperationOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.servicecontrol.v1.QuotaControllerProto.internal_static_google_api_servicecontrol_v1_QuotaOperation_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(
        int number) {
      switch (number) {
        case 4:
          return internalGetLabels();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(
        int number) {
      switch (number) {
        case 4:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException(
              "Invalid map field number: " + number);
      }
    }
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.servicecontrol.v1.QuotaControllerProto.internal_static_google_api_servicecontrol_v1_QuotaOperation_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.servicecontrol.v1.QuotaOperation.class, com.google.api.servicecontrol.v1.QuotaOperation.Builder.class);
    }

    // Construct using com.google.api.servicecontrol.v1.QuotaOperation.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        getQuotaMetricsFieldBuilder();
      }
    }
    public Builder clear() {
      super.clear();
      operationId_ = "";

      methodName_ = "";

      consumerId_ = "";

      internalGetMutableLabels().clear();
      if (quotaMetricsBuilder_ == null) {
        quotaMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
      } else {
        quotaMetricsBuilder_.clear();
      }
      quotaMode_ = 0;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.servicecontrol.v1.QuotaControllerProto.internal_static_google_api_servicecontrol_v1_QuotaOperation_descriptor;
    }

    public com.google.api.servicecontrol.v1.QuotaOperation getDefaultInstanceForType() {
      return com.google.api.servicecontrol.v1.QuotaOperation.getDefaultInstance();
    }

    public com.google.api.servicecontrol.v1.QuotaOperation build() {
      com.google.api.servicecontrol.v1.QuotaOperation result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.api.servicecontrol.v1.QuotaOperation buildPartial() {
      com.google.api.servicecontrol.v1.QuotaOperation result = new com.google.api.servicecontrol.v1.QuotaOperation(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.operationId_ = operationId_;
      result.methodName_ = methodName_;
      result.consumerId_ = consumerId_;
      result.labels_ = internalGetLabels();
      result.labels_.makeImmutable();
      if (quotaMetricsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) == 0x00000010)) {
          quotaMetrics_ = java.util.Collections.unmodifiableList(quotaMetrics_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.quotaMetrics_ = quotaMetrics_;
      } else {
        result.quotaMetrics_ = quotaMetricsBuilder_.build();
      }
      result.quotaMode_ = quotaMode_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.setField(field, value);
    }
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.servicecontrol.v1.QuotaOperation) {
        return mergeFrom((com.google.api.servicecontrol.v1.QuotaOperation)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.servicecontrol.v1.QuotaOperation other) {
      if (other == com.google.api.servicecontrol.v1.QuotaOperation.getDefaultInstance()) return this;
      if (!other.getOperationId().isEmpty()) {
        operationId_ = other.operationId_;
        onChanged();
      }
      if (!other.getMethodName().isEmpty()) {
        methodName_ = other.methodName_;
        onChanged();
      }
      if (!other.getConsumerId().isEmpty()) {
        consumerId_ = other.consumerId_;
        onChanged();
      }
      internalGetMutableLabels().mergeFrom(
          other.internalGetLabels());
      if (quotaMetricsBuilder_ == null) {
        if (!other.quotaMetrics_.isEmpty()) {
          if (quotaMetrics_.isEmpty()) {
            quotaMetrics_ = other.quotaMetrics_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureQuotaMetricsIsMutable();
            quotaMetrics_.addAll(other.quotaMetrics_);
          }
          onChanged();
        }
      } else {
        if (!other.quotaMetrics_.isEmpty()) {
          if (quotaMetricsBuilder_.isEmpty()) {
            quotaMetricsBuilder_.dispose();
            quotaMetricsBuilder_ = null;
            quotaMetrics_ = other.quotaMetrics_;
            bitField0_ = (bitField0_ & ~0x00000010);
            quotaMetricsBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getQuotaMetricsFieldBuilder() : null;
          } else {
            quotaMetricsBuilder_.addAllMessages(other.quotaMetrics_);
          }
        }
      }
      if (other.quotaMode_ != 0) {
        setQuotaModeValue(other.getQuotaModeValue());
      }
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.servicecontrol.v1.QuotaOperation parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.servicecontrol.v1.QuotaOperation) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object operationId_ = "";
    /**
     * <pre>
     * Identity of the operation. This must be unique within the scope of the
     * service that generated the operation. If the service calls AllocateQuota
     * and ReleaseQuota on the same operation, the two calls should carry the
     * same ID.
     * UUID version 4 is recommended, though not required. In scenarios where an
     * operation is computed from existing information and an idempotent id is
     * desirable for deduplication purpose, UUID version 5 is recommended. See
     * RFC 4122 for details.
     * </pre>
     *
     * <code>optional string operation_id = 1;</code>
     */
    public java.lang.String getOperationId() {
      java.lang.Object ref = operationId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        operationId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Identity of the operation. This must be unique within the scope of the
     * service that generated the operation. If the service calls AllocateQuota
     * and ReleaseQuota on the same operation, the two calls should carry the
     * same ID.
     * UUID version 4 is recommended, though not required. In scenarios where an
     * operation is computed from existing information and an idempotent id is
     * desirable for deduplication purpose, UUID version 5 is recommended. See
     * RFC 4122 for details.
     * </pre>
     *
     * <code>optional string operation_id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getOperationIdBytes() {
      java.lang.Object ref = operationId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        operationId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Identity of the operation. This must be unique within the scope of the
     * service that generated the operation. If the service calls AllocateQuota
     * and ReleaseQuota on the same operation, the two calls should carry the
     * same ID.
     * UUID version 4 is recommended, though not required. In scenarios where an
     * operation is computed from existing information and an idempotent id is
     * desirable for deduplication purpose, UUID version 5 is recommended. See
     * RFC 4122 for details.
     * </pre>
     *
     * <code>optional string operation_id = 1;</code>
     */
    public Builder setOperationId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      operationId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Identity of the operation. This must be unique within the scope of the
     * service that generated the operation. If the service calls AllocateQuota
     * and ReleaseQuota on the same operation, the two calls should carry the
     * same ID.
     * UUID version 4 is recommended, though not required. In scenarios where an
     * operation is computed from existing information and an idempotent id is
     * desirable for deduplication purpose, UUID version 5 is recommended. See
     * RFC 4122 for details.
     * </pre>
     *
     * <code>optional string operation_id = 1;</code>
     */
    public Builder clearOperationId() {
      
      operationId_ = getDefaultInstance().getOperationId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Identity of the operation. This must be unique within the scope of the
     * service that generated the operation. If the service calls AllocateQuota
     * and ReleaseQuota on the same operation, the two calls should carry the
     * same ID.
     * UUID version 4 is recommended, though not required. In scenarios where an
     * operation is computed from existing information and an idempotent id is
     * desirable for deduplication purpose, UUID version 5 is recommended. See
     * RFC 4122 for details.
     * </pre>
     *
     * <code>optional string operation_id = 1;</code>
     */
    public Builder setOperationIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      operationId_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object methodName_ = "";
    /**
     * <pre>
     * Fully qualified name of the API method for which this quota operation is
     * requested. This name is used for matching quota rules or metric rules and
     * billing status rules defined in service configuration. This field is not
     * required if the quota operation is performed on non-API resources.
     * Example of an RPC method name:
     *     google.example.library.v1.LibraryService.CreateShelf
     * </pre>
     *
     * <code>optional string method_name = 2;</code>
     */
    public java.lang.String getMethodName() {
      java.lang.Object ref = methodName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        methodName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Fully qualified name of the API method for which this quota operation is
     * requested. This name is used for matching quota rules or metric rules and
     * billing status rules defined in service configuration. This field is not
     * required if the quota operation is performed on non-API resources.
     * Example of an RPC method name:
     *     google.example.library.v1.LibraryService.CreateShelf
     * </pre>
     *
     * <code>optional string method_name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getMethodNameBytes() {
      java.lang.Object ref = methodName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        methodName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Fully qualified name of the API method for which this quota operation is
     * requested. This name is used for matching quota rules or metric rules and
     * billing status rules defined in service configuration. This field is not
     * required if the quota operation is performed on non-API resources.
     * Example of an RPC method name:
     *     google.example.library.v1.LibraryService.CreateShelf
     * </pre>
     *
     * <code>optional string method_name = 2;</code>
     */
    public Builder setMethodName(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      methodName_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fully qualified name of the API method for which this quota operation is
     * requested. This name is used for matching quota rules or metric rules and
     * billing status rules defined in service configuration. This field is not
     * required if the quota operation is performed on non-API resources.
     * Example of an RPC method name:
     *     google.example.library.v1.LibraryService.CreateShelf
     * </pre>
     *
     * <code>optional string method_name = 2;</code>
     */
    public Builder clearMethodName() {
      
      methodName_ = getDefaultInstance().getMethodName();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Fully qualified name of the API method for which this quota operation is
     * requested. This name is used for matching quota rules or metric rules and
     * billing status rules defined in service configuration. This field is not
     * required if the quota operation is performed on non-API resources.
     * Example of an RPC method name:
     *     google.example.library.v1.LibraryService.CreateShelf
     * </pre>
     *
     * <code>optional string method_name = 2;</code>
     */
    public Builder setMethodNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      methodName_ = value;
      onChanged();
      return this;
    }

    private java.lang.Object consumerId_ = "";
    /**
     * <pre>
     * Identity of the consumer for whom this quota operation is being performed.
     * This can be in one of the following formats:
     *   project:&lt;project_id&gt;,
     *   project_number:&lt;project_number&gt;,
     *   api_key:&lt;api_key&gt;.
     * (--GOOGLE_INTERNAL:
     *   spatula_header:&lt;spatula_header&gt; and
     *   loas:&lt;loas_role&gt; are also accepted.
     * --)
     * </pre>
     *
     * <code>optional string consumer_id = 3;</code>
     */
    public java.lang.String getConsumerId() {
      java.lang.Object ref = consumerId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        consumerId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Identity of the consumer for whom this quota operation is being performed.
     * This can be in one of the following formats:
     *   project:&lt;project_id&gt;,
     *   project_number:&lt;project_number&gt;,
     *   api_key:&lt;api_key&gt;.
     * (--GOOGLE_INTERNAL:
     *   spatula_header:&lt;spatula_header&gt; and
     *   loas:&lt;loas_role&gt; are also accepted.
     * --)
     * </pre>
     *
     * <code>optional string consumer_id = 3;</code>
     */
    public com.google.protobuf.ByteString
        getConsumerIdBytes() {
      java.lang.Object ref = consumerId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        consumerId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Identity of the consumer for whom this quota operation is being performed.
     * This can be in one of the following formats:
     *   project:&lt;project_id&gt;,
     *   project_number:&lt;project_number&gt;,
     *   api_key:&lt;api_key&gt;.
     * (--GOOGLE_INTERNAL:
     *   spatula_header:&lt;spatula_header&gt; and
     *   loas:&lt;loas_role&gt; are also accepted.
     * --)
     * </pre>
     *
     * <code>optional string consumer_id = 3;</code>
     */
    public Builder setConsumerId(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      consumerId_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Identity of the consumer for whom this quota operation is being performed.
     * This can be in one of the following formats:
     *   project:&lt;project_id&gt;,
     *   project_number:&lt;project_number&gt;,
     *   api_key:&lt;api_key&gt;.
     * (--GOOGLE_INTERNAL:
     *   spatula_header:&lt;spatula_header&gt; and
     *   loas:&lt;loas_role&gt; are also accepted.
     * --)
     * </pre>
     *
     * <code>optional string consumer_id = 3;</code>
     */
    public Builder clearConsumerId() {
      
      consumerId_ = getDefaultInstance().getConsumerId();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Identity of the consumer for whom this quota operation is being performed.
     * This can be in one of the following formats:
     *   project:&lt;project_id&gt;,
     *   project_number:&lt;project_number&gt;,
     *   api_key:&lt;api_key&gt;.
     * (--GOOGLE_INTERNAL:
     *   spatula_header:&lt;spatula_header&gt; and
     *   loas:&lt;loas_role&gt; are also accepted.
     * --)
     * </pre>
     *
     * <code>optional string consumer_id = 3;</code>
     */
    public Builder setConsumerIdBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      consumerId_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<
        java.lang.String, java.lang.String> labels_;
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }
    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
    internalGetMutableLabels() {
      onChanged();;
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(
            LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }
    /**
     * <pre>
     * Labels describing the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */

    public boolean containsLabels(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      return internalGetLabels().getMap().containsKey(key);
    }
    /**
     * Use {@link #getLabelsMap()} instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }
    /**
     * <pre>
     * Labels describing the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */

    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }
    /**
     * <pre>
     * Labels describing the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */

    public java.lang.String getLabelsOrDefault(
        java.lang.String key,
        java.lang.String defaultValue) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     * <pre>
     * Labels describing the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */

    public java.lang.String getLabelsOrThrow(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      getMutableLabels().clear();
      return this;
    }
    /**
     * <pre>
     * Labels describing the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */

    public Builder removeLabels(
        java.lang.String key) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      getMutableLabels().remove(key);
      return this;
    }
    /**
     * Use alternate mutation accessors instead.
     */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String>
    getMutableLabels() {
      return internalGetMutableLabels().getMutableMap();
    }
    /**
     * <pre>
     * Labels describing the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */
    public Builder putLabels(
        java.lang.String key,
        java.lang.String value) {
      if (key == null) { throw new java.lang.NullPointerException(); }
      if (value == null) { throw new java.lang.NullPointerException(); }
      getMutableLabels().put(key, value);
      return this;
    }
    /**
     * <pre>
     * Labels describing the operation.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 4;</code>
     */

    public Builder putAllLabels(
        java.util.Map<java.lang.String, java.lang.String> values) {
      getMutableLabels().putAll(values);
      return this;
    }

    private java.util.List<com.google.api.servicecontrol.v1.MetricValueSet> quotaMetrics_ =
      java.util.Collections.emptyList();
    private void ensureQuotaMetricsIsMutable() {
      if (!((bitField0_ & 0x00000010) == 0x00000010)) {
        quotaMetrics_ = new java.util.ArrayList<com.google.api.servicecontrol.v1.MetricValueSet>(quotaMetrics_);
        bitField0_ |= 0x00000010;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.servicecontrol.v1.MetricValueSet, com.google.api.servicecontrol.v1.MetricValueSet.Builder, com.google.api.servicecontrol.v1.MetricValueSetOrBuilder> quotaMetricsBuilder_;

    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public java.util.List<com.google.api.servicecontrol.v1.MetricValueSet> getQuotaMetricsList() {
      if (quotaMetricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(quotaMetrics_);
      } else {
        return quotaMetricsBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public int getQuotaMetricsCount() {
      if (quotaMetricsBuilder_ == null) {
        return quotaMetrics_.size();
      } else {
        return quotaMetricsBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public com.google.api.servicecontrol.v1.MetricValueSet getQuotaMetrics(int index) {
      if (quotaMetricsBuilder_ == null) {
        return quotaMetrics_.get(index);
      } else {
        return quotaMetricsBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder setQuotaMetrics(
        int index, com.google.api.servicecontrol.v1.MetricValueSet value) {
      if (quotaMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotaMetricsIsMutable();
        quotaMetrics_.set(index, value);
        onChanged();
      } else {
        quotaMetricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder setQuotaMetrics(
        int index, com.google.api.servicecontrol.v1.MetricValueSet.Builder builderForValue) {
      if (quotaMetricsBuilder_ == null) {
        ensureQuotaMetricsIsMutable();
        quotaMetrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        quotaMetricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder addQuotaMetrics(com.google.api.servicecontrol.v1.MetricValueSet value) {
      if (quotaMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotaMetricsIsMutable();
        quotaMetrics_.add(value);
        onChanged();
      } else {
        quotaMetricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder addQuotaMetrics(
        int index, com.google.api.servicecontrol.v1.MetricValueSet value) {
      if (quotaMetricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureQuotaMetricsIsMutable();
        quotaMetrics_.add(index, value);
        onChanged();
      } else {
        quotaMetricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder addQuotaMetrics(
        com.google.api.servicecontrol.v1.MetricValueSet.Builder builderForValue) {
      if (quotaMetricsBuilder_ == null) {
        ensureQuotaMetricsIsMutable();
        quotaMetrics_.add(builderForValue.build());
        onChanged();
      } else {
        quotaMetricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder addQuotaMetrics(
        int index, com.google.api.servicecontrol.v1.MetricValueSet.Builder builderForValue) {
      if (quotaMetricsBuilder_ == null) {
        ensureQuotaMetricsIsMutable();
        quotaMetrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        quotaMetricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder addAllQuotaMetrics(
        java.lang.Iterable<? extends com.google.api.servicecontrol.v1.MetricValueSet> values) {
      if (quotaMetricsBuilder_ == null) {
        ensureQuotaMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, quotaMetrics_);
        onChanged();
      } else {
        quotaMetricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder clearQuotaMetrics() {
      if (quotaMetricsBuilder_ == null) {
        quotaMetrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        quotaMetricsBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public Builder removeQuotaMetrics(int index) {
      if (quotaMetricsBuilder_ == null) {
        ensureQuotaMetricsIsMutable();
        quotaMetrics_.remove(index);
        onChanged();
      } else {
        quotaMetricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public com.google.api.servicecontrol.v1.MetricValueSet.Builder getQuotaMetricsBuilder(
        int index) {
      return getQuotaMetricsFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public com.google.api.servicecontrol.v1.MetricValueSetOrBuilder getQuotaMetricsOrBuilder(
        int index) {
      if (quotaMetricsBuilder_ == null) {
        return quotaMetrics_.get(index);  } else {
        return quotaMetricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public java.util.List<? extends com.google.api.servicecontrol.v1.MetricValueSetOrBuilder> 
         getQuotaMetricsOrBuilderList() {
      if (quotaMetricsBuilder_ != null) {
        return quotaMetricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(quotaMetrics_);
      }
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public com.google.api.servicecontrol.v1.MetricValueSet.Builder addQuotaMetricsBuilder() {
      return getQuotaMetricsFieldBuilder().addBuilder(
          com.google.api.servicecontrol.v1.MetricValueSet.getDefaultInstance());
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public com.google.api.servicecontrol.v1.MetricValueSet.Builder addQuotaMetricsBuilder(
        int index) {
      return getQuotaMetricsFieldBuilder().addBuilder(
          index, com.google.api.servicecontrol.v1.MetricValueSet.getDefaultInstance());
    }
    /**
     * <pre>
     * Represents information about this operation. Each MetricValueSet
     * corresponds to a metric defined in the service configuration.
     * The data type used in the MetricValueSet must agree with
     * the data type specified in the metric definition.
     * Within a single operation, it is not allowed to have more than one
     * MetricValue instances that have the same metric names and identical
     * label value combinations. If a request has such duplicated MetricValue
     * instances, the entire request is rejected with
     * an invalid argument error.
     * </pre>
     *
     * <code>repeated .google.api.servicecontrol.v1.MetricValueSet quota_metrics = 5;</code>
     */
    public java.util.List<com.google.api.servicecontrol.v1.MetricValueSet.Builder> 
         getQuotaMetricsBuilderList() {
      return getQuotaMetricsFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilderV3<
        com.google.api.servicecontrol.v1.MetricValueSet, com.google.api.servicecontrol.v1.MetricValueSet.Builder, com.google.api.servicecontrol.v1.MetricValueSetOrBuilder> 
        getQuotaMetricsFieldBuilder() {
      if (quotaMetricsBuilder_ == null) {
        quotaMetricsBuilder_ = new com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.api.servicecontrol.v1.MetricValueSet, com.google.api.servicecontrol.v1.MetricValueSet.Builder, com.google.api.servicecontrol.v1.MetricValueSetOrBuilder>(
                quotaMetrics_,
                ((bitField0_ & 0x00000010) == 0x00000010),
                getParentForChildren(),
                isClean());
        quotaMetrics_ = null;
      }
      return quotaMetricsBuilder_;
    }

    private int quotaMode_ = 0;
    /**
     * <pre>
     * Quota mode for this operation.
     * </pre>
     *
     * <code>optional .google.api.servicecontrol.v1.QuotaOperation.QuotaMode quota_mode = 6;</code>
     */
    public int getQuotaModeValue() {
      return quotaMode_;
    }
    /**
     * <pre>
     * Quota mode for this operation.
     * </pre>
     *
     * <code>optional .google.api.servicecontrol.v1.QuotaOperation.QuotaMode quota_mode = 6;</code>
     */
    public Builder setQuotaModeValue(int value) {
      quotaMode_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Quota mode for this operation.
     * </pre>
     *
     * <code>optional .google.api.servicecontrol.v1.QuotaOperation.QuotaMode quota_mode = 6;</code>
     */
    public com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode getQuotaMode() {
      com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode result = com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode.valueOf(quotaMode_);
      return result == null ? com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Quota mode for this operation.
     * </pre>
     *
     * <code>optional .google.api.servicecontrol.v1.QuotaOperation.QuotaMode quota_mode = 6;</code>
     */
    public Builder setQuotaMode(com.google.api.servicecontrol.v1.QuotaOperation.QuotaMode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      quotaMode_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Quota mode for this operation.
     * </pre>
     *
     * <code>optional .google.api.servicecontrol.v1.QuotaOperation.QuotaMode quota_mode = 6;</code>
     */
    public Builder clearQuotaMode() {
      
      quotaMode_ = 0;
      onChanged();
      return this;
    }
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return this;
    }


    // @@protoc_insertion_point(builder_scope:google.api.servicecontrol.v1.QuotaOperation)
  }

  // @@protoc_insertion_point(class_scope:google.api.servicecontrol.v1.QuotaOperation)
  private static final com.google.api.servicecontrol.v1.QuotaOperation DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.servicecontrol.v1.QuotaOperation();
  }

  public static com.google.api.servicecontrol.v1.QuotaOperation getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<QuotaOperation>
      PARSER = new com.google.protobuf.AbstractParser<QuotaOperation>() {
    public QuotaOperation parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
        return new QuotaOperation(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<QuotaOperation> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<QuotaOperation> getParserForType() {
    return PARSER;
  }

  public com.google.api.servicecontrol.v1.QuotaOperation getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

