/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.config;

import com.google.api.Service;
import com.google.api.config.ServiceConfigSupplier;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.concurrent.TimeUnit;

public class ServiceConfigFetcher {
    private final Supplier<Service> serviceSupplier;

    @VisibleForTesting
    ServiceConfigFetcher(Supplier<Service> supplier) {
        this.serviceSupplier = Suppliers.memoizeWithExpiration(supplier, (long)10L, (TimeUnit)TimeUnit.MINUTES);
    }

    public Service fetch() {
        return (Service)this.serviceSupplier.get();
    }

    public static ServiceConfigFetcher create() {
        return new ServiceConfigFetcher(ServiceConfigSupplier.create());
    }
}

