/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.auth.JwksSupplier;
import com.google.api.auth.KeyUriSupplier;
import com.google.api.auth.UnauthenticatedException;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.util.Preconditions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import java.util.Map;
import org.jose4j.jwk.EllipticCurveJsonWebKey;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.keys.X509Util;
import org.jose4j.lang.JoseException;

public class DefaultJwksSupplier
implements JwksSupplier {
    @VisibleForTesting
    static final String X509_CERT_PREFIX = "-----BEGIN CERTIFICATE-----";
    @VisibleForTesting
    static final String X509_CERT_SUFFIX = "-----END CERTIFICATE-----";
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final HttpRequestFactory httpRequestFactory;
    private final KeyUriSupplier keyUriSupplier;

    public DefaultJwksSupplier(HttpRequestFactory httpRequestFactory, KeyUriSupplier keyUriSupplier) {
        this.httpRequestFactory = (HttpRequestFactory)Preconditions.checkNotNull((Object)httpRequestFactory);
        this.keyUriSupplier = (KeyUriSupplier)Preconditions.checkNotNull((Object)keyUriSupplier);
    }

    @Override
    public JsonWebKeySet supply(String issuer) {
        Preconditions.checkNotNull((Object)issuer);
        Optional<GenericUrl> jwksUri = this.keyUriSupplier.supply(issuer);
        if (!jwksUri.isPresent()) {
            String message = String.format("Cannot find the jwks_uri for issuer %s: either the issuer is unknown or the OpenID discovery failed", issuer);
            throw new UnauthenticatedException(message);
        }
        String rawJson = this.retrieveJwksJson((GenericUrl)jwksUri.get());
        Map<String, Object> rawMap = DefaultJwksSupplier.parse(rawJson, new TypeReference<Map<String, Object>>(){});
        if (rawMap.containsKey("keys")) {
            return DefaultJwksSupplier.extractJwks(rawJson);
        }
        return this.extractX509Certificate(rawJson);
    }

    private String retrieveJwksJson(GenericUrl jwksUri) {
        try {
            HttpResponse response = this.httpRequestFactory.buildGetRequest(jwksUri).execute();
            return response.parseAsString();
        }
        catch (IOException exception) {
            String message = String.format("Cannot retrive the JWKS json from %s", jwksUri.build());
            throw new UnauthenticatedException(message, exception);
        }
    }

    private static <T> T parse(String json, TypeReference<T> typeReference) {
        try {
            return (T)OBJECT_MAPPER.readValue(json, typeReference);
        }
        catch (IOException exception) {
            throw new UnauthenticatedException("Cannot parse the JSON string", exception);
        }
    }

    private JsonWebKeySet extractX509Certificate(String json) {
        Map<String, String> certificates = DefaultJwksSupplier.parse(json, new TypeReference<Map<String, String>>(){});
        ImmutableList.Builder jwkBuilder = ImmutableList.builder();
        X509Util x509Util = new X509Util();
        for (Map.Entry<String, String> entry : certificates.entrySet()) {
            try {
                String cert = entry.getValue().trim().replace(X509_CERT_PREFIX, "").replace(X509_CERT_SUFFIX, "");
                X509Certificate x509Certificate = x509Util.fromBase64Der(cert);
                PublicKey publicKey = x509Certificate.getPublicKey();
                JsonWebKey jwk = DefaultJwksSupplier.toJsonWebKey(publicKey);
                jwk.setKeyId(entry.getKey());
                jwkBuilder.add((Object)jwk);
            }
            catch (JoseException exception) {
                throw new UnauthenticatedException("Failed to parse public key", exception);
            }
        }
        return new JsonWebKeySet((List)jwkBuilder.build());
    }

    private static JsonWebKeySet extractJwks(String json) {
        try {
            return new JsonWebKeySet(json);
        }
        catch (JoseException exception) {
            throw new UnauthenticatedException("Cannot create a JsonWebKeySet");
        }
    }

    private static JsonWebKey toJsonWebKey(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            return new RsaJsonWebKey((RSAPublicKey)publicKey);
        }
        if (publicKey instanceof ECPublicKey) {
            return new EllipticCurveJsonWebKey((ECPublicKey)publicKey);
        }
        String message = "Unsupported public key type: " + publicKey.getClass().getSimpleName();
        throw new UnauthenticatedException(message);
    }
}

