/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.AuthTokenVerifier;
import com.google.api.auth.JwksSupplier;
import com.google.api.auth.UnauthenticatedException;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwk.VerificationJwkSelector;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.lang.JoseException;

public class DefaultAuthTokenVerifier
implements AuthTokenVerifier {
    private final VerificationJwkSelector jwkSelector = new VerificationJwkSelector();
    private final JwksSupplier jwksSupplier;

    public DefaultAuthTokenVerifier(JwksSupplier jwksSupplier) {
        this.jwksSupplier = (JwksSupplier)Preconditions.checkNotNull((Object)jwksSupplier);
    }

    @Override
    public boolean verify(String authToken, String issuer) {
        Preconditions.checkNotNull((Object)authToken);
        Preconditions.checkNotNull((Object)issuer);
        try {
            JsonWebKeySet jwks = this.jwksSupplier.supply(issuer);
            JsonWebSignature jws = new JsonWebSignature();
            jws.setCompactSerialization(authToken);
            for (JsonWebKey jwk : this.jwkSelector.selectList(jws, (Collection)jwks.getJsonWebKeys())) {
                jws.setKey(jwk.getKey());
                if (!jws.verifySignature()) continue;
                return true;
            }
        }
        catch (JoseException exception) {
            throw new UnauthenticatedException("Cannot verify the signature", exception);
        }
        return false;
    }
}

