/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.JwksSupplier;
import com.google.api.client.util.Preconditions;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.jose4j.jwk.JsonWebKeySet;

public class CachingJwksSupplier
implements JwksSupplier {
    private static final int CACHE_EXPIRATION_IN_MINUTES = 5;
    private final LoadingCache<String, JsonWebKeySet> jwksCache;

    public CachingJwksSupplier(JwksSupplier jwksSupplier) {
        this((JwksSupplier)Preconditions.checkNotNull((Object)jwksSupplier), Ticker.systemTicker());
    }

    @VisibleForTesting
    CachingJwksSupplier(JwksSupplier jwksSupplier, Ticker ticker) {
        this.jwksCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).ticker(ticker).build((CacheLoader)new JwksCacheLoader(jwksSupplier));
    }

    @Override
    public JsonWebKeySet supply(String issuer) {
        Preconditions.checkNotNull((Object)issuer);
        return (JsonWebKeySet)this.jwksCache.getUnchecked((Object)issuer);
    }

    private static final class JwksCacheLoader
    extends CacheLoader<String, JsonWebKeySet> {
        private final JwksSupplier jwksSupplier;

        JwksCacheLoader(JwksSupplier jwksSupplier) {
            this.jwksSupplier = jwksSupplier;
        }

        public JsonWebKeySet load(String issuer) throws Exception {
            return this.jwksSupplier.supply(issuer);
        }
    }
}

