/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.auth;

import com.google.api.auth.AuthTokenDecoder;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import org.jose4j.jwt.JwtClaims;

public class CachingAuthTokenDecoder
implements AuthTokenDecoder {
    private static final int CACHE_CAPACITY = 200;
    private static final int CACHE_EXPIRATION_IN_MINUTES = 5;
    private final LoadingCache<String, JwtClaims> authTokenCache;

    public CachingAuthTokenDecoder(AuthTokenDecoder authTokenDecoder) {
        this(authTokenDecoder, Ticker.systemTicker());
    }

    @VisibleForTesting
    CachingAuthTokenDecoder(AuthTokenDecoder authTokenDecoder, Ticker ticker) {
        this.authTokenCache = CacheBuilder.newBuilder().maximumSize(200L).expireAfterWrite(5L, TimeUnit.MINUTES).ticker(ticker).build((CacheLoader)new DefaultCacheLoader(authTokenDecoder));
    }

    @Override
    public JwtClaims decode(String authToken) {
        Preconditions.checkNotNull((Object)authToken);
        return (JwtClaims)this.authTokenCache.getUnchecked((Object)authToken);
    }

    private static final class DefaultCacheLoader
    extends CacheLoader<String, JwtClaims> {
        private final AuthTokenDecoder authTokenDecoder;

        DefaultCacheLoader(AuthTokenDecoder authTokenDecoder) {
            this.authTokenDecoder = authTokenDecoder;
        }

        public JwtClaims load(String authToken) throws Exception {
            return this.authTokenDecoder.decode(authToken);
        }
    }
}

