/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.scope;

import com.google.api.server.spi.config.scope.AbstractAuthScopeExpression;
import com.google.api.server.spi.config.scope.AuthScopeExpression;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

class DisjunctAuthScopeExpression
extends AbstractAuthScopeExpression {
    private final ImmutableList<AbstractAuthScopeExpression> innerExpressions;

    DisjunctAuthScopeExpression(List<AbstractAuthScopeExpression> innerExpressions) {
        this.innerExpressions = ImmutableList.copyOf(innerExpressions);
    }

    @Override
    public String[] getAllScopes() {
        LinkedHashSet allScopes = Sets.newLinkedHashSet();
        for (AuthScopeExpression innerExpression : this.innerExpressions) {
            allScopes.addAll(Arrays.asList(innerExpression.getAllScopes()));
        }
        return allScopes.toArray(new String[allScopes.size()]);
    }

    @Override
    public boolean isAuthorized(Set<String> userScopes) {
        if (this.innerExpressions.isEmpty()) {
            return false;
        }
        for (AuthScopeExpression innerExpression : this.innerExpressions) {
            if (!innerExpression.isAuthorized(userScopes)) continue;
            return true;
        }
        return false;
    }

    @Override
    List<String> encode() {
        return ImmutableList.copyOf(this.encodeMutable());
    }

    @Override
    List<String> encodeMutable() {
        ArrayList<String> expression = new ArrayList<String>();
        for (AbstractAuthScopeExpression innerExpression : this.innerExpressions) {
            expression.addAll(innerExpression.encode());
        }
        return expression;
    }

    @Override
    public String toLoggingForm() {
        return "(" + Joiner.on((String)" || ").join(Iterables.transform(this.innerExpressions, (Function)new Function<AuthScopeExpression, String>(){

            public String apply(AuthScopeExpression scopeExpression) {
                return scopeExpression.toLoggingForm();
            }
        })) + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DisjunctAuthScopeExpression)) {
            return false;
        }
        DisjunctAuthScopeExpression that = (DisjunctAuthScopeExpression)obj;
        return this.innerExpressions.equals(that.innerExpressions);
    }

    public int hashCode() {
        return this.innerExpressions.hashCode();
    }
}

