/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.ArrayBuffer;
import elemental2.core.ArrayBufferView;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class WebSocket implements EventTarget {
  @JsFunction
  public interface OncloseCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsFunction
  public interface OnmessageCallbackFn {
    Object onInvoke(MessageEvent<Object> p0);
  }

  @JsFunction
  public interface OnopenCallbackFn {
    Object onInvoke(Event p0);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SendDataUnionType {
    @JsOverlay
    static SendDataUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBuffer asArrayBuffer() {
      return Js.cast(this);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default String asString() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isArrayBuffer() {
      return (Object) this instanceof ArrayBuffer;
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isString() {
      return (Object) this instanceof String;
    }
  }

  public static double CLOSED;
  public static double CLOSING;
  public static double CONNECTING;
  public static double OPEN;
  public String binaryType;
  public double bufferedAmount;
  public OncloseCallbackFn onclose;
  public OnmessageCallbackFn onmessage;
  public OnopenCallbackFn onopen;
  public double readyState;
  public String url;

  public WebSocket(String url, String protocol) {}

  public WebSocket(String url) {}

  public native void addEventListener(
      String type, EventListener listener, EventTarget.AddEventListenerOptionsUnionType options);

  public native void addEventListener(String type, EventListener listener);

  public native void close();

  public native void close(double code, String reason);

  public native void close(double code);

  public native boolean dispatchEvent(Event evt);

  public native void removeEventListener(
      String type, EventListener listener, EventTarget.RemoveEventListenerOptionsUnionType options);

  public native void removeEventListener(String type, EventListener listener);

  @JsOverlay
  public final boolean send(ArrayBuffer data) {
    return send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  @JsOverlay
  public final boolean send(ArrayBufferView data) {
    return send(Js.<SendDataUnionType>uncheckedCast(data));
  }

  public native boolean send(SendDataUnionType data);

  @JsOverlay
  public final boolean send(String data) {
    return send(Js.<SendDataUnionType>uncheckedCast(data));
  }
}
