/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.dom;

import elemental2.core.Date;
import elemental2.core.Iterator;
import elemental2.core.JsObject;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsProperty;
import jsinterop.annotations.JsType;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public interface RTCStatsReport {
  @JsFunction
  public interface ForEachCallbackFn {
    Object onInvoke(JsObject p0);
  }

  <SCOPE> Object forEach(ForEachCallbackFn callback, SCOPE thisObj);

  Object forEach(ForEachCallbackFn callback);

  JsObject get(String key);

  @JsProperty
  String getId();

  @JsProperty
  RTCStatsReport getLocal();

  @JsProperty
  RTCStatsReport getRemote();

  @JsProperty
  Date getTimestamp();

  @JsProperty
  String getType();

  Iterator<String> keys();

  String[] names();

  String stat(String name);
}
