/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package elemental2.core;

import java.lang.Double;
import java.lang.Object;
import java.lang.String;
import jsinterop.annotations.JsFunction;
import jsinterop.annotations.JsOverlay;
import jsinterop.annotations.JsPackage;
import jsinterop.annotations.JsType;
import jsinterop.base.Js;
import jsinterop.base.JsArrayLike;

@JsType(isNative = true, namespace = JsPackage.GLOBAL)
public class TypedArray extends ArrayBufferView implements Iterable<Double>, JsArrayLike<Double> {
  @JsFunction
  public interface EveryCallbackFn {
    Object onInvoke(double p0, double p1, TypedArray p2);
  }

  @JsFunction
  public interface FilterCallbackFn {
    boolean onInvoke(double p0, double p1, TypedArray p2);
  }

  @JsFunction
  public interface FindCallbackFn {
    boolean onInvoke(double p0, double p1, TypedArray p2);
  }

  @JsFunction
  public interface FindIndexCallbackFn {
    boolean onInvoke(double p0, double p1, TypedArray p2);
  }

  @JsFunction
  public interface ForEachCallbackFn {
    Object onInvoke(double p0, double p1, TypedArray p2);
  }

  @JsFunction
  public interface MapCallbackFn {
    double onInvoke(double p0, double p1, TypedArray p2);
  }

  @JsFunction
  public interface ReduceCallbackFn<RET, INIT> {
    @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
    public interface P0UnionType<RET, INIT> {
      @JsOverlay
      static ReduceCallbackFn.P0UnionType of(Object o) {
        return Js.cast(o);
      }

      @JsOverlay
      default double asDouble() {
        return Js.castToDouble(this);
      }

      @JsOverlay
      default INIT asINIT() {
        return Js.cast(this);
      }

      @JsOverlay
      default RET asRET() {
        return Js.cast(this);
      }

      @JsOverlay
      default boolean isDouble() {
        return (Object) this instanceof Double;
      }
    }

    RET onInvoke(ReduceCallbackFn.P0UnionType<RET, INIT> p0, double p1, double p2, TypedArray p3);
  }

  @JsFunction
  public interface ReduceRightCallbackFn<RET, INIT> {
    @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
    public interface P0UnionType<RET, INIT> {
      @JsOverlay
      static ReduceRightCallbackFn.P0UnionType of(Object o) {
        return Js.cast(o);
      }

      @JsOverlay
      default double asDouble() {
        return Js.castToDouble(this);
      }

      @JsOverlay
      default INIT asINIT() {
        return Js.cast(this);
      }

      @JsOverlay
      default RET asRET() {
        return Js.cast(this);
      }

      @JsOverlay
      default boolean isDouble() {
        return (Object) this instanceof Double;
      }
    }

    RET onInvoke(
        ReduceRightCallbackFn.P0UnionType<RET, INIT> p0, double p1, double p2, TypedArray p3);
  }

  @JsType(isNative = true, name = "?", namespace = JsPackage.GLOBAL)
  public interface SetArrayUnionType {
    @JsOverlay
    static SetArrayUnionType of(Object o) {
      return Js.cast(o);
    }

    @JsOverlay
    default ArrayBufferView asArrayBufferView() {
      return Js.cast(this);
    }

    @JsOverlay
    default double[] asDoubleArray() {
      return Js.cast(this);
    }

    @JsOverlay
    default boolean isArrayBufferView() {
      return (Object) this instanceof ArrayBufferView;
    }

    @JsOverlay
    default boolean isDoubleArray() {
      return (Object) this instanceof Object[];
    }
  }

  @JsFunction
  public interface SomeCallbackFn {
    boolean onInvoke(double p0, double p1, TypedArray p2);
  }

  @JsFunction
  public interface SortCompareFunctionCallbackFn {
    double onInvoke(double p0, double p1);
  }

  public double BYTES_PER_ELEMENT;
  public double length;

  public native <THIS> THIS copyWithin(double target, double start, double end);

  public native <THIS> THIS copyWithin(double target, double start);

  public native IteratorIterable<double[]> entries();

  public native <S> boolean every(EveryCallbackFn callback, S thisArg);

  public native boolean every(EveryCallbackFn callback);

  public native <THIS> THIS fill(double value, double begin, double end);

  public native <THIS> THIS fill(double value, double begin);

  public native <THIS> THIS fill(double value);

  public native <THIS, S> THIS filter(FilterCallbackFn callback, S thisArg);

  public native <THIS> THIS filter(FilterCallbackFn callback);

  public native <S> double find(FindCallbackFn callback, S thisArg);

  public native double find(FindCallbackFn callback);

  public native <S> double findIndex(FindIndexCallbackFn callback, S thisArg);

  public native double findIndex(FindIndexCallbackFn callback);

  public native <S> void forEach(ForEachCallbackFn callback, S thisArg);

  public native void forEach(ForEachCallbackFn callback);

  public native boolean includes(double searchElement, double fromIndex);

  public native boolean includes(double searchElement);

  public native double indexOf(double searchElement, double fromIndex);

  public native double indexOf(double searchElement);

  public native String join();

  public native String join(String separator);

  public native IteratorIterable<Double> keys();

  public native double lastIndexOf(double searchElement, double fromIndex);

  public native double lastIndexOf(double searchElement);

  public native <THIS, S> THIS map(MapCallbackFn callback, S thisArg);

  public native <THIS> THIS map(MapCallbackFn callback);

  public native <INIT, RET> RET reduce(ReduceCallbackFn<RET, INIT> callback, INIT initialValue);

  public native <INIT, RET> RET reduce(ReduceCallbackFn<RET, INIT> callback);

  public native <INIT, RET> RET reduceRight(
      ReduceRightCallbackFn<RET, INIT> callback, INIT initialValue);

  public native <INIT, RET> RET reduceRight(ReduceRightCallbackFn<RET, INIT> callback);

  public native <THIS> THIS reverse();

  @JsOverlay
  public final void set(ArrayBufferView array, double offset) {
    set(Js.<SetArrayUnionType>uncheckedCast(array), offset);
  }

  @JsOverlay
  public final void set(ArrayBufferView array) {
    set(Js.<SetArrayUnionType>uncheckedCast(array));
  }

  public native void set(SetArrayUnionType array, double offset);

  public native void set(SetArrayUnionType array);

  @JsOverlay
  public final void set(double[] array, double offset) {
    set(Js.<SetArrayUnionType>uncheckedCast(array), offset);
  }

  @JsOverlay
  public final void set(double[] array) {
    set(Js.<SetArrayUnionType>uncheckedCast(array));
  }

  public native <THIS> THIS slice();

  public native <THIS> THIS slice(double begin, double end);

  public native <THIS> THIS slice(double begin);

  public native <S> boolean some(SomeCallbackFn callback, S thisArg);

  public native boolean some(SomeCallbackFn callback);

  public native <THIS> THIS sort();

  public native <THIS> THIS sort(SortCompareFunctionCallbackFn compareFunction);

  public native <THIS> THIS subarray(double begin, double end);

  public native <THIS> THIS subarray(double begin);

  public native String toLocaleString();

  public native String toString();

  public native IteratorIterable<Double> values();
}
